/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.databases.LuceneDatabase;
import no.priv.garshol.duke.utils.Utils;

public class ConfigurationImpl
implements Configuration {
    private Collection<DataSource> datasources = new ArrayList<DataSource>();
    private Collection<DataSource> group1 = new ArrayList<DataSource>();
    private Collection<DataSource> group2 = new ArrayList<DataSource>();
    private double threshold;
    private double thresholdMaybe;
    private Map<String, Property> properties;
    private List<Property> proplist;
    private Collection<Property> lookups;
    private Database database = new LuceneDatabase();

    @Override
    public Collection<DataSource> getDataSources() {
        return this.datasources;
    }

    @Override
    public Collection<DataSource> getDataSources(int groupno) {
        if (groupno == 1) {
            return this.group1;
        }
        if (groupno == 2) {
            return this.group2;
        }
        throw new DukeConfigException("Invalid group number: " + groupno);
    }

    public void addDataSource(int groupno, DataSource datasource) {
        if (groupno == 0) {
            this.datasources.add(datasource);
        } else if (groupno == 1) {
            this.group1.add(datasource);
        } else if (groupno == 2) {
            this.group2.add(datasource);
        }
    }

    @Override
    public Database getDatabase(boolean overwrite) {
        this.database.setConfiguration(this);
        this.database.setOverwrite(overwrite);
        return this.database;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public double getMaybeThreshold() {
        return this.thresholdMaybe;
    }

    @Override
    public boolean isDeduplicationMode() {
        return !this.getDataSources().isEmpty();
    }

    public void setMaybeThreshold(double thresholdMaybe) {
        this.thresholdMaybe = thresholdMaybe;
    }

    public void setProperties(List<Property> props) {
        this.proplist = props;
        this.properties = new HashMap<String, Property>(props.size());
        for (Property prop : props) {
            this.properties.put(prop.getName(), prop);
        }
        this.findLookupProperties();
    }

    @Override
    public List<Property> getProperties() {
        return this.proplist;
    }

    @Override
    public Collection<Property> getIdentityProperties() {
        ArrayList<Property> ids = new ArrayList<Property>();
        for (Property p : this.getProperties()) {
            if (!p.isIdProperty()) continue;
            ids.add(p);
        }
        return ids;
    }

    @Override
    public Property getPropertyByName(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<Property> getLookupProperties() {
        return this.lookups;
    }

    @Override
    public void validate() {
        if (this.properties == null || this.properties.isEmpty()) {
            throw new DukeConfigException("Configuration has no properties at all");
        }
        double prob = 0.5;
        for (Property prop : this.properties.values()) {
            if (prop.getHighProbability() == 0.0) continue;
            prob = Utils.computeBayes(prob, prop.getHighProbability());
        }
        if (prob < this.threshold) {
            throw new DukeConfigException("Maximum possible probability is " + prob + ", which is below threshold (" + this.threshold + "), which means no duplicates will ever " + "be found");
        }
        if (this.getIdentityProperties().isEmpty()) {
            throw new DukeConfigException("No ID properties.");
        }
    }

    private void findLookupProperties() {
        ArrayList<Property> candidates = new ArrayList<Property>();
        for (Property prop : this.properties.values()) {
            if (prop.isIdProperty() || prop.isIgnoreProperty() || prop.getLookupBehaviour() == Property.Lookup.FALSE || prop.getHighProbability() == 0.0) continue;
            candidates.add(prop);
        }
        Collections.sort(candidates, new HighComparator());
        int last = -1;
        double prob = 0.5;
        for (int ix = 0; ix < candidates.size(); ++ix) {
            Property prop = (Property)candidates.get(ix);
            if (!((prob = Utils.computeBayes(prob, prop.getHighProbability())) >= this.threshold)) continue;
            last = ix;
            break;
        }
        this.lookups = last == -1 ? new ArrayList<Property>() : new ArrayList<Property>(candidates.subList(0, last + 1));
        for (Property p : this.proplist) {
            if (p.getLookupBehaviour() != Property.Lookup.TRUE && p.getLookupBehaviour() != Property.Lookup.REQUIRED || this.lookups.contains(p)) continue;
            this.lookups.add(p);
        }
    }

    @Override
    public Configuration copy() {
        ConfigurationImpl copy = new ConfigurationImpl();
        for (DataSource src : this.datasources) {
            copy.addDataSource(0, src);
        }
        for (DataSource src : this.group1) {
            copy.addDataSource(1, src);
        }
        for (DataSource src : this.group2) {
            copy.addDataSource(2, src);
        }
        copy.setThreshold(this.threshold);
        copy.setMaybeThreshold(this.thresholdMaybe);
        ArrayList<Property> newprops = new ArrayList<Property>();
        for (Property p : this.proplist) {
            newprops.add(p.copy());
        }
        copy.setProperties(newprops);
        return copy;
    }

    private static class HighComparator
    implements Comparator<Property> {
        private HighComparator() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.getHighProbability() < p2.getHighProbability()) {
                return 1;
            }
            if (p1.getHighProbability() == p2.getHighProbability()) {
                return 0;
            }
            return -1;
        }
    }
}

