/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.Arrays;

public class Bucket
implements Comparable<Bucket> {
    public int nextfree;
    public long[] records = new long[10];
    private boolean dirty;
    private static final int MAX_BUCKET_SIZE = 1000000;

    public void add(long id) {
        if (this.records == null) {
            return;
        }
        if (this.nextfree >= this.records.length) {
            if (this.nextfree >= 1000000) {
                this.records = null;
                this.dirty = false;
                return;
            }
            long[] newbuf = new long[Math.min(this.records.length * 2, 1000000)];
            System.arraycopy(this.records, 0, newbuf, 0, this.records.length);
            this.records = newbuf;
        }
        this.records[this.nextfree++] = id;
        this.dirty = true;
    }

    @Override
    public int compareTo(Bucket other) {
        return this.nextfree - other.nextfree;
    }

    public void sort() {
        if (!this.dirty) {
            return;
        }
        Arrays.sort(this.records, 0, this.nextfree);
        this.dirty = false;
    }

    public double getScore() {
        if (this.nextfree == 0) {
            return 1.0;
        }
        return 1.0 / Math.log(this.nextfree + 1);
    }

    public boolean contains(long record) {
        return Arrays.binarySearch(this.records, 0, this.nextfree, record) >= 0;
    }
}

