/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import water.clustering.api.AssistedClusteringEndpoint;
import water.clustering.api.H2OClusterStatusEndpoint;

public class AssistedClusteringRestApi
extends RouterNanoHTTPD
implements AutoCloseable {
    private static final int DEFAULT_PORT = 8080;
    public static final String ASSISTED_CLUSTERING_PORT_KEY = "H2O_ASSISTED_CLUSTERING_API_PORT";
    private final Consumer<String> flatFileConsumer;

    public AssistedClusteringRestApi(Consumer<String> flatFileConsumer) {
        super(AssistedClusteringRestApi.getPort());
        Objects.requireNonNull(flatFileConsumer);
        this.flatFileConsumer = flatFileConsumer;
        this.addMappings();
    }

    private static int getPort() {
        String customPort = System.getenv(ASSISTED_CLUSTERING_PORT_KEY);
        if (customPort == null) {
            return 8080;
        }
        try {
            return Integer.parseInt(customPort);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Unusable port for Assisted clustering REST API to bind to: '%s'", customPort);
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    @Override
    public void addMappings() {
        super.addMappings();
        this.addRoute("/clustering/flatfile", AssistedClusteringEndpoint.class, this.flatFileConsumer);
        this.addRoute("/cluster/status", H2OClusterStatusEndpoint.class, new Object[0]);
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public void start() throws IOException {
        this.start(5000, false);
    }

    @Override
    public void start(int timeout) throws IOException {
        super.start(timeout, false);
    }
}

