/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.priv.garshol.duke.Cleaner;

public class RegexpCleaner
implements Cleaner {
    private Pattern regexp;
    private int groupno = 1;
    private boolean discard;

    @Override
    public String clean(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        Matcher matcher = this.regexp.matcher(value);
        if (!this.discard) {
            if (!matcher.find()) {
                return null;
            }
            return matcher.group(this.groupno);
        }
        if (!matcher.find()) {
            return value;
        }
        return value.substring(0, matcher.start(this.groupno)) + value.substring(matcher.end(this.groupno));
    }

    public void setRegexp(String regexp) {
        this.regexp = Pattern.compile(regexp);
    }

    public void setGroup(int groupno) {
        this.groupno = groupno;
    }

    public void setDiscardGroup(boolean discard) {
        this.discard = discard;
    }
}

