/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;

public class LinkFileWriter {
    private Writer out;
    private Collection<Property> idprops;

    public LinkFileWriter(Writer out) {
        this(out, null);
    }

    public LinkFileWriter(Writer out, Configuration config) {
        this.out = out;
        if (config != null) {
            this.idprops = config.getIdentityProperties();
        }
    }

    public void write(Record r1, Record r2, boolean match, double confidence) throws IOException {
        this.write(this.getid(r1), this.getid(r2), match, confidence);
    }

    public void write(String id1, String id2, boolean match, double confidence) throws IOException {
        this.out.write("" + (match ? "+," : "-,") + id1 + ',' + id2 + ',' + confidence + "\n");
    }

    private String getid(Record r) {
        for (Property p : this.idprops) {
            String v = r.getValue(p.getName());
            if (v == null) continue;
            return v;
        }
        throw new DukeException("No identity for record " + r);
    }
}

