/*
 * Decompiled with CFR 0.152.
 */
package water.clustering;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import water.H2O;
import water.clustering.AssistedClusteringEmbeddedConfig;
import water.clustering.api.AssistedClusteringRestApi;
import water.clustering.api.GracefulAsyncRunner;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.EmbeddedConfigProvider;
import water.util.Log;

public class AssistedClusteringEmbeddedConfigProvider
implements EmbeddedConfigProvider {
    private static final Logger LOG = Logger.getLogger(AssistedClusteringEmbeddedConfigProvider.class);
    private final SynchronousQueue<String> flatFileQueue = new SynchronousQueue();
    private AssistedClusteringRestApi assistedClusteringRestApi;

    @Override
    public void init() {
        Consumer<String> flatFileCallback = s -> {
            try {
                this.flatFileQueue.put((String)s);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        this.assistedClusteringRestApi = this.startAssistedClusteringRestApi(flatFileCallback).orElseThrow(() -> new IllegalStateException("Assisted clustering Rest API unable to start."));
    }

    private Optional<AssistedClusteringRestApi> startAssistedClusteringRestApi(Consumer<String> flatFileCallback) {
        Log.info("Starting assisted clustering REST API services");
        try {
            AssistedClusteringRestApi assistedClusteringRestApi = new AssistedClusteringRestApi(flatFileCallback);
            assistedClusteringRestApi.setAsyncRunner(new GracefulAsyncRunner());
            assistedClusteringRestApi.start();
            Log.info("Assisted clustering REST API services successfully started.");
            return Optional.of(assistedClusteringRestApi);
        }
        catch (IOException e) {
            Log.err("Unable to start H2O assisted clustering REST API", e);
            H2O.exit(1);
            return Optional.empty();
        }
    }

    @Override
    public boolean isActive() {
        return Boolean.parseBoolean(System.getenv("H2O_ASSISTED_CLUSTERING_REST"));
    }

    @Override
    public AbstractEmbeddedH2OConfig getConfig() {
        try {
            String flatfile = this.flatFileQueue.take();
            return new AssistedClusteringEmbeddedConfig(flatfile);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), e);
            throw new IllegalStateException("Interruption occured during waiting for a flatfile.", e);
        }
    }

    void close() {
        AssistedClusteringRestApi api = this.assistedClusteringRestApi;
        this.assistedClusteringRestApi = null;
        if (api != null) {
            api.close();
        }
    }
}

