/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dct.DoubleDCT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDCT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDCT_1D dctSlices;
    private DoubleDCT_1D dctRows;
    private DoubleDCT_1D dctColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDCT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dctSlices = new DoubleDCT_1D(slices);
        this.dctRows = slices == rows ? this.dctSlices : new DoubleDCT_1D(rows);
        this.dctColumns = slices == columns ? this.dctSlices : (rows == columns ? this.dctRows : new DoubleDCT_1D(columns));
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx1 + r * DoubleDCT_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDCT_3D.this.dctRows.forward(temp, scale);
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDCT_3D.this.rowStride;
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(temp, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dctRows.forward(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dctSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void forward(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s = firstSlice; s < lastSlice; ++s) {
                            long idx1 = s * DoubleDCT_3D.this.sliceStridel;
                            for (long r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx1 + r * DoubleDCT_3D.this.rowStridel, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDCT_3D.this.rowsl, false);
                        for (long s = firstSlice; s < lastSlice; ++s) {
                            long idx1 = s * DoubleDCT_3D.this.sliceStridel;
                            for (long c = 0L; c < DoubleDCT_3D.this.columnsl; ++c) {
                                long idx3;
                                long r;
                                for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStridel + c;
                                    temp.setDouble(r, a.getDouble(idx3));
                                }
                                DoubleDCT_3D.this.dctRows.forward(temp, scale);
                                for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStridel + c;
                                    a.setDouble(idx3, temp.getDouble(r));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rowsl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDCT_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx1 = r * DoubleDCT_3D.this.rowStridel;
                            for (long c = 0L; c < DoubleDCT_3D.this.columnsl; ++c) {
                                long idx3;
                                long s;
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStridel + idx1 + c;
                                    temp.setDouble(s, a.getDouble(idx3));
                                }
                                DoubleDCT_3D.this.dctSlices.forward(temp, scale);
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStridel + idx1 + c;
                                    a.setDouble(idx3, temp.getDouble(s));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c;
            long idx1;
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx12 = s * this.sliceStridel;
                for (long r = 0L; r < this.rowsl; ++r) {
                    this.dctColumns.forward(a, idx12 + r * this.rowStridel, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s = 0L; s < this.slicesl; ++s) {
                idx1 = s * this.sliceStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        temp.setDouble(r, a.getDouble(idx3));
                    }
                    this.dctRows.forward(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        a.setDouble(idx3, temp.getDouble(r));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.rowStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long s;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx3 = s * this.sliceStridel + idx1 + c;
                        temp.setDouble(s, a.getDouble(idx3));
                    }
                    this.dctSlices.forward(temp, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx3 = s * this.sliceStridel + idx1 + c;
                        a.setDouble(idx3, temp.getDouble(s));
                    }
                }
            }
        }
    }

    public void forward(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                DoubleDCT_3D.this.dctRows.forward(temp, scale);
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(temp, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a[s][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dctRows.forward(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dctSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx1 + r * DoubleDCT_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDCT_3D.this.dctRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDCT_3D.this.rowStride;
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(temp, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dctRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dctSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s = firstSlice; s < lastSlice; ++s) {
                            long idx1 = s * DoubleDCT_3D.this.sliceStridel;
                            for (long r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx1 + r * DoubleDCT_3D.this.rowStridel, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDCT_3D.this.rowsl, false);
                        for (long s = firstSlice; s < lastSlice; ++s) {
                            long idx1 = s * DoubleDCT_3D.this.sliceStridel;
                            for (long c = 0L; c < DoubleDCT_3D.this.columnsl; ++c) {
                                long idx3;
                                long r;
                                for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStridel + c;
                                    temp.setDouble(r, a.getDouble(idx3));
                                }
                                DoubleDCT_3D.this.dctRows.inverse(temp, scale);
                                for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStridel + c;
                                    a.setDouble(idx3, temp.getDouble(r));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rowsl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(DoubleDCT_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx1 = r * DoubleDCT_3D.this.rowStridel;
                            for (long c = 0L; c < DoubleDCT_3D.this.columnsl; ++c) {
                                long idx3;
                                long s;
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStridel + idx1 + c;
                                    temp.setDouble(s, a.getDouble(idx3));
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(temp, scale);
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStridel + idx1 + c;
                                    a.setDouble(idx3, temp.getDouble(s));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx3;
            long c;
            long idx1;
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx12 = s * this.sliceStridel;
                for (long r = 0L; r < this.rowsl; ++r) {
                    this.dctColumns.inverse(a, idx12 + r * this.rowStridel, scale);
                }
            }
            DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
            for (long s = 0L; s < this.slicesl; ++s) {
                idx1 = s * this.sliceStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        temp.setDouble(r, a.getDouble(idx3));
                    }
                    this.dctRows.inverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx3 = idx1 + r * this.rowStridel + c;
                        a.setDouble(idx3, temp.getDouble(r));
                    }
                }
            }
            temp = new DoubleLargeArray(this.slicesl, false);
            for (long r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.rowStridel;
                for (c = 0L; c < this.columnsl; ++c) {
                    long s;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx3 = s * this.sliceStridel + idx1 + c;
                        temp.setDouble(s, a.getDouble(idx3));
                    }
                    this.dctSlices.inverse(temp, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx3 = s * this.sliceStridel + idx1 + c;
                        a.setDouble(idx3, temp.getDouble(s));
                    }
                }
            }
        }
    }

    public void inverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                DoubleDCT_3D.this.dctRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDCT_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(temp, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a[s][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dctRows.inverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dctSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t = new double[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            t[r2] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.rows] = a[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dctRows.forward(t, 0, scale);
                        this.dctRows.forward(t, this.rows, scale);
                        this.dctRows.forward(t, 2 * this.rows, scale);
                        this.dctRows.forward(t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = t[r2];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.rows];
                            a[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a[idx1];
                    t[this.rows + r] = a[idx1 + 1];
                }
                this.dctRows.forward(t, 0, scale);
                this.dctRows.forward(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t[r];
                    a[idx1 + 1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            t[r3] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.rows] = a[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dctRows.inverse(t, 0, scale);
                        this.dctRows.inverse(t, this.rows, scale);
                        this.dctRows.inverse(t, 2 * this.rows, scale);
                        this.dctRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = t[r3];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.rows];
                            a[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a[idx1];
                    t[this.rows + r] = a[idx1 + 1];
                }
                this.dctRows.inverse(t, 0, scale);
                this.dctRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t[r];
                    a[idx1 + 1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, DoubleLargeArray a, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        DoubleLargeArray t = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dctColumns.forward(a, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            t.setDouble(r2, a.getDouble(idx1));
                            t.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dctRows.forward(t, 0L, scale);
                        this.dctRows.forward(t, this.rowsl, scale);
                        this.dctRows.forward(t, 2L * this.rowsl, scale);
                        this.dctRows.forward(t, 3L * this.rowsl, scale);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            a.setDouble(idx1, t.getDouble(r2));
                            a.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setDouble(r, a.getDouble(idx1));
                    t.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dctRows.forward(t, 0L, scale);
                this.dctRows.forward(t, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t.getDouble(r));
                    a.setDouble(idx1 + 1L, t.getDouble(this.rowsl + r));
                }
            }
        } else {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dctColumns.inverse(a, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            t.setDouble(r3, a.getDouble(idx1));
                            t.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.rowsl, a.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx1 + 3L));
                        }
                        this.dctRows.inverse(t, 0L, scale);
                        this.dctRows.inverse(t, this.rowsl, scale);
                        this.dctRows.inverse(t, 2L * this.rowsl, scale);
                        this.dctRows.inverse(t, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            a.setDouble(idx1, t.getDouble(r3));
                            a.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setDouble(r, a.getDouble(idx1));
                    t.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
                }
                this.dctRows.inverse(t, 0L, scale);
                this.dctRows.inverse(t, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setDouble(idx1, t.getDouble(r));
                    a.setDouble(idx1 + 1L, t.getDouble(this.rowsl + r));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t = new double[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t[r2] = a[s][r2][c];
                            t[idx2] = a[s][r2][c + 1];
                            t[idx2 + this.rows] = a[s][r2][c + 2];
                            t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                        }
                        this.dctRows.forward(t, 0, scale);
                        this.dctRows.forward(t, this.rows, scale);
                        this.dctRows.forward(t, 2 * this.rows, scale);
                        this.dctRows.forward(t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = t[r2];
                            a[s][r2][c + 1] = t[idx2];
                            a[s][r2][c + 2] = t[idx2 + this.rows];
                            a[s][r2][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a[s][r][0];
                    t[this.rows + r] = a[s][r][1];
                }
                this.dctRows.forward(t, 0, scale);
                this.dctRows.forward(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = t[r];
                    a[s][r][1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t[r3] = a[s][r3][c];
                            t[idx2] = a[s][r3][c + 1];
                            t[idx2 + this.rows] = a[s][r3][c + 2];
                            t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                        }
                        this.dctRows.inverse(t, 0, scale);
                        this.dctRows.inverse(t, this.rows, scale);
                        this.dctRows.inverse(t, 2 * this.rows, scale);
                        this.dctRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = t[r3];
                            a[s][r3][c + 1] = t[idx2];
                            a[s][r3][c + 2] = t[idx2 + this.rows];
                            a[s][r3][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a[s][r][0];
                    t[this.rows + r] = a[s][r][1];
                }
                this.dctRows.inverse(t, 0, scale);
                this.dctRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = t[r];
                    a[s][r][1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a, boolean scale) {
        block20: {
            double[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                t[s] = a[idx1];
                                t[idx2] = a[idx1 + 1];
                                t[idx2 + this.slices] = a[idx1 + 2];
                                t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dctSlices.forward(t, 0, scale);
                            this.dctSlices.forward(t, this.slices, scale);
                            this.dctSlices.forward(t, 2 * this.slices, scale);
                            this.dctSlices.forward(t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = t[s];
                                a[idx1 + 1] = t[idx2];
                                a[idx1 + 2] = t[idx2 + this.slices];
                                a[idx1 + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a[idx1];
                        t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dctSlices.forward(t, 0, scale);
                    this.dctSlices.forward(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = t[s];
                        a[idx1 + 1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            t[s] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.slices] = a[idx1 + 2];
                            t[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dctSlices.inverse(t, 0, scale);
                        this.dctSlices.inverse(t, this.slices, scale);
                        this.dctSlices.inverse(t, 2 * this.slices, scale);
                        this.dctSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = t[s];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.slices];
                            a[idx1 + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a[idx1];
                        t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dctSlices.inverse(t, 0, scale);
                    this.dctSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = t[s];
                        a[idx1 + 1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, DoubleLargeArray a, boolean scale) {
        block20: {
            DoubleLargeArray t;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t = new DoubleLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx0 = r * this.rowStridel;
                        for (long c = 0L; c < this.columnsl; c += 4L) {
                            long idx2;
                            long idx1;
                            long s;
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s;
                                t.setDouble(s, a.getDouble(idx1));
                                t.setDouble(idx2, a.getDouble(idx1 + 1L));
                                t.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                                t.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                            }
                            this.dctSlices.forward(t, 0L, scale);
                            this.dctSlices.forward(t, this.slicesl, scale);
                            this.dctSlices.forward(t, 2L * this.slicesl, scale);
                            this.dctSlices.forward(t, 3L * this.slicesl, scale);
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s;
                                a.setDouble(idx1, t.getDouble(s));
                                a.setDouble(idx1 + 1L, t.getDouble(idx2));
                                a.setDouble(idx1 + 2L, t.getDouble(idx2 + this.slicesl));
                                a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setDouble(s, a.getDouble(idx1));
                        t.setDouble(this.slicesl + s, a.getDouble(idx1 + 1L));
                    }
                    this.dctSlices.forward(t, 0L, scale);
                    this.dctSlices.forward(t, this.slicesl, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a.setDouble(idx1, t.getDouble(s));
                        a.setDouble(idx1 + 1L, t.getDouble(this.slicesl + s));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx1;
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s;
                            t.setDouble(s, a.getDouble(idx1));
                            t.setDouble(idx2, a.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.slicesl, a.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.slicesl, a.getDouble(idx1 + 3L));
                        }
                        this.dctSlices.inverse(t, 0L, scale);
                        this.dctSlices.inverse(t, this.slicesl, scale);
                        this.dctSlices.inverse(t, 2L * this.slicesl, scale);
                        this.dctSlices.inverse(t, 3L * this.slicesl, scale);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s;
                            a.setDouble(idx1, t.getDouble(s));
                            a.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a.setDouble(idx1 + 2L, t.getDouble(idx2 + this.slicesl));
                            a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setDouble(s, a.getDouble(idx1));
                        t.setDouble(this.slicesl + s, a.getDouble(idx1 + 1L));
                    }
                    this.dctSlices.inverse(t, 0L, scale);
                    this.dctSlices.inverse(t, this.slicesl, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a.setDouble(idx1, t.getDouble(s));
                        a.setDouble(idx1 + 1L, t.getDouble(this.slicesl + s));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a, boolean scale) {
        block20: {
            double[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                t[s] = a[s][r][c];
                                t[idx2] = a[s][r][c + 1];
                                t[idx2 + this.slices] = a[s][r][c + 2];
                                t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            }
                            this.dctSlices.forward(t, 0, scale);
                            this.dctSlices.forward(t, this.slices, scale);
                            this.dctSlices.forward(t, 2 * this.slices, scale);
                            this.dctSlices.forward(t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a[s][r][c] = t[s];
                                a[s][r][c + 1] = t[idx2];
                                a[s][r][c + 2] = t[idx2 + this.slices];
                                a[s][r][c + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a[s][r][0];
                        t[this.slices + s] = a[s][r][1];
                    }
                    this.dctSlices.forward(t, 0, scale);
                    this.dctSlices.forward(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = t[s];
                        a[s][r][1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            t[s] = a[s][r][c];
                            t[idx2] = a[s][r][c + 1];
                            t[idx2 + this.slices] = a[s][r][c + 2];
                            t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                        }
                        this.dctSlices.inverse(t, 0, scale);
                        this.dctSlices.inverse(t, this.slices, scale);
                        this.dctSlices.inverse(t, 2 * this.slices, scale);
                        this.dctSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a[s][r][c] = t[s];
                            a[s][r][c + 1] = t[idx2];
                            a[s][r][c + 2] = t[idx2 + this.slices];
                            a[s][r][c + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a[s][r][0];
                        t[this.slices + s] = a[s][r][1];
                    }
                    this.dctSlices.inverse(t, 0, scale);
                    this.dctSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = t[s];
                        a[s][r][1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final int ntf = nt;
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t = new double[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDCT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDCT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx0 + r * DoubleDCT_3D.this.rowStride, scale);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDCT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = DoubleDCT_3D.this.rows + r2;
                                        t[r2] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(t, 0, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 3 * DoubleDCT_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDCT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = DoubleDCT_3D.this.rows + r2;
                                        a[idx1] = t[r2];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + DoubleDCT_3D.this.rows];
                                        a[idx1 + 3] = t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                t[r] = a[idx1];
                                t[((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDCT_3D.this.dctRows.forward(t, 0, scale);
                            DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                a[idx1] = t[r];
                                a[idx1 + 1] = t[DoubleDCT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDCT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDCT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx0 + r * DoubleDCT_3D.this.rowStride, scale);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int j;
                                    for (j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = DoubleDCT_3D.this.rows + j;
                                        t[j] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(t, 0, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 3 * DoubleDCT_3D.this.rows, scale);
                                    for (j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = DoubleDCT_3D.this.rows + j;
                                        a[idx1] = t[j];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + DoubleDCT_3D.this.rows];
                                        a[idx1 + 3] = t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                t[r] = a[idx1];
                                t[((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDCT_3D.this.dctRows.inverse(t, 0, scale);
                            DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                a[idx1] = t[r];
                                a[idx1 + 1] = t[DoubleDCT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final long ntf = nt;
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s = n0; s < DoubleDCT_3D.this.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * DoubleDCT_3D.this.sliceStridel;
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx0 + r * DoubleDCT_3D.this.rowStridel, scale);
                            }
                            if (DoubleDCT_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDCT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleDCT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStridel + c;
                                        idx2 = DoubleDCT_3D.this.rowsl + r2;
                                        t.setDouble(r2, a.getDouble(idx1));
                                        t.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDCT_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDCT_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(t, 0L, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rowsl, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 2L * DoubleDCT_3D.this.rowsl, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 3L * DoubleDCT_3D.this.rowsl, scale);
                                    for (r2 = 0L; r2 < DoubleDCT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStridel + c;
                                        idx2 = DoubleDCT_3D.this.rowsl + r2;
                                        a.setDouble(idx1, t.getDouble(r2));
                                        a.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDCT_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStridel;
                                t.setDouble(r, a.getDouble(idx1));
                                t.setDouble(DoubleDCT_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDCT_3D.this.dctRows.forward(t, 0L, scale);
                            DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStridel;
                                a.setDouble(idx1, t.getDouble(r));
                                a.setDouble(idx1 + 1L, t.getDouble(DoubleDCT_3D.this.rowsl + r));
                            }
                        }
                    } else {
                        for (long s = n0; s < DoubleDCT_3D.this.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * DoubleDCT_3D.this.sliceStridel;
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx0 + r * DoubleDCT_3D.this.rowStridel, scale);
                            }
                            if (DoubleDCT_3D.this.columnsl > 2L) {
                                for (long c = 0L; c < DoubleDCT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long j;
                                    for (j = 0L; j < DoubleDCT_3D.this.rowsl; ++j) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStridel + c;
                                        idx2 = DoubleDCT_3D.this.rowsl + j;
                                        t.setDouble(j, a.getDouble(idx1));
                                        t.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDCT_3D.this.rowsl, a.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDCT_3D.this.rowsl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(t, 0L, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rowsl, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 2L * DoubleDCT_3D.this.rowsl, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 3L * DoubleDCT_3D.this.rowsl, scale);
                                    for (j = 0L; j < DoubleDCT_3D.this.rowsl; ++j) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStridel + c;
                                        idx2 = DoubleDCT_3D.this.rowsl + j;
                                        a.setDouble(idx1, t.getDouble(j));
                                        a.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDCT_3D.this.rowsl));
                                        a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStridel;
                                t.setDouble(r, a.getDouble(idx1));
                                t.setDouble(DoubleDCT_3D.this.rowsl + r, a.getDouble(idx1 + 1L));
                            }
                            DoubleDCT_3D.this.dctRows.inverse(t, 0L, scale);
                            DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDCT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleDCT_3D.this.rowStridel;
                                a.setDouble(idx1, t.getDouble(r));
                                a.setDouble(idx1 + 1L, t.getDouble(DoubleDCT_3D.this.rowsl + r));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t = new double[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDCT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.forward(a[s][r], scale);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDCT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDCT_3D.this.rows + r2;
                                        t[r2] = a[s][r2][c];
                                        t[idx2] = a[s][r2][c + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r2][c + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r2][c + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(t, 0, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(t, 3 * DoubleDCT_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDCT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDCT_3D.this.rows + r2;
                                        a[s][r2][c] = t[r2];
                                        a[s][r2][c + 1] = t[idx2];
                                        a[s][r2][c + 2] = t[idx2 + DoubleDCT_3D.this.rows];
                                        a[s][r2][c + 3] = t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                t[r] = a[s][r][0];
                                t[((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[s][r][1];
                            }
                            DoubleDCT_3D.this.dctRows.forward(t, 0, scale);
                            DoubleDCT_3D.this.dctRows.forward(t, DoubleDCT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                a[s][r][0] = t[r];
                                a[s][r][1] = t[DoubleDCT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDCT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                DoubleDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDCT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDCT_3D.this.rows + r3;
                                        t[r3] = a[s][r3][c];
                                        t[idx2] = a[s][r3][c + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r3][c + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r3][c + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(t, 0, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(t, 3 * DoubleDCT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDCT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDCT_3D.this.rows + r3;
                                        a[s][r3][c] = t[r3];
                                        a[s][r3][c + 1] = t[idx2];
                                        a[s][r3][c + 2] = t[idx2 + DoubleDCT_3D.this.rows];
                                        a[s][r3][c + 3] = t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                t[r] = a[s][r][0];
                                t[((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[s][r][1];
                            }
                            DoubleDCT_3D.this.dctRows.inverse(t, 0, scale);
                            DoubleDCT_3D.this.dctRows.inverse(t, DoubleDCT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDCT_3D.this.rows; ++r) {
                                a[s][r][0] = t[r];
                                a[s][r][1] = t[DoubleDCT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t;
                        block17: {
                            block18: {
                                t = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                    int idx0 = r * DoubleDCT_3D.this.rowStride;
                                    for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDCT_3D.this.slices + s;
                                            t[s] = a[idx1];
                                            t[idx2] = a[idx1 + 1];
                                            t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 2];
                                            t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 3];
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(t, 0, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 2 * DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 3 * DoubleDCT_3D.this.slices, scale);
                                        for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = DoubleDCT_3D.this.slices + s;
                                            a[idx1] = t[s];
                                            a[idx1 + 1] = t[idx2];
                                            a[idx1 + 2] = t[idx2 + DoubleDCT_3D.this.slices];
                                            a[idx1 + 3] = t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    t[s] = a[idx1];
                                    t[((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(t, 0, scale);
                                DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = t[s];
                                    a[idx1 + 1] = t[DoubleDCT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDCT_3D.this.slices + s;
                                        t[s] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 3];
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 0, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 2 * DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 3 * DoubleDCT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = DoubleDCT_3D.this.slices + s;
                                        a[idx1] = t[s];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + DoubleDCT_3D.this.slices];
                                        a[idx1 + 3] = t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    t[s] = a[idx1];
                                    t[((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(t, 0, scale);
                                DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = t[s];
                                    a[idx1 + 1] = t[DoubleDCT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray t;
                        block17: {
                            block18: {
                                t = new DoubleLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (DoubleDCT_3D.this.columnsl <= 2L) break block18;
                                for (long r = n0; r < DoubleDCT_3D.this.rowsl; r += (long)nthreads) {
                                    long idx0 = r * DoubleDCT_3D.this.rowStridel;
                                    for (long c = 0L; c < DoubleDCT_3D.this.columnsl; c += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s;
                                        for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDCT_3D.this.slicesl + s;
                                            t.setDouble(s, a.getDouble(idx1));
                                            t.setDouble(idx2, a.getDouble(idx1 + 1L));
                                            t.setDouble(idx2 + DoubleDCT_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                            t.setDouble(idx2 + 2L * DoubleDCT_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(t, 0L, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slicesl, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 2L * DoubleDCT_3D.this.slicesl, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 3L * DoubleDCT_3D.this.slicesl, scale);
                                        for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0 + c;
                                            idx2 = DoubleDCT_3D.this.slicesl + s;
                                            a.setDouble(idx1, t.getDouble(s));
                                            a.setDouble(idx1 + 1L, t.getDouble(idx2));
                                            a.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDCT_3D.this.slicesl));
                                            a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDCT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) break block19;
                            for (long r = n0; r < DoubleDCT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * DoubleDCT_3D.this.rowStridel;
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0;
                                    t.setDouble(s, a.getDouble(idx1));
                                    t.setDouble(DoubleDCT_3D.this.slicesl + s, a.getDouble(idx1 + 1L));
                                }
                                DoubleDCT_3D.this.dctSlices.forward(t, 0L, scale);
                                DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slicesl, scale);
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t.getDouble(s));
                                    a.setDouble(idx1 + 1L, t.getDouble(DoubleDCT_3D.this.slicesl + s));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columnsl > 2L) {
                            for (long r = n0; r < DoubleDCT_3D.this.rowsl; r += (long)nthreads) {
                                long idx0 = r * DoubleDCT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleDCT_3D.this.columnsl; c += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s;
                                    for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDCT_3D.this.slicesl + s;
                                        t.setDouble(s, a.getDouble(idx1));
                                        t.setDouble(idx2, a.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDCT_3D.this.slicesl, a.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDCT_3D.this.slicesl, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 0L, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slicesl, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 2L * DoubleDCT_3D.this.slicesl, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 3L * DoubleDCT_3D.this.slicesl, scale);
                                    for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = DoubleDCT_3D.this.slicesl + s;
                                        a.setDouble(idx1, t.getDouble(s));
                                        a.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDCT_3D.this.slicesl));
                                        a.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDCT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columnsl == 2L) {
                            for (long r = n0; r < DoubleDCT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * DoubleDCT_3D.this.rowStridel;
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0;
                                    t.setDouble(s, a.getDouble(idx1));
                                    t.setDouble(DoubleDCT_3D.this.slicesl + s, a.getDouble(idx1 + 1L));
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(t, 0L, scale);
                                DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slicesl, scale);
                                for (s = 0L; s < DoubleDCT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStridel + idx0;
                                    a.setDouble(idx1, t.getDouble(s));
                                    a.setDouble(idx1 + 1L, t.getDouble(DoubleDCT_3D.this.slicesl + s));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t;
                        block17: {
                            block18: {
                                t = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                            idx2 = DoubleDCT_3D.this.slices + s;
                                            t[s] = a[s][r][c];
                                            t[idx2] = a[s][r][c + 1];
                                            t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 2];
                                            t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 3];
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(t, 0, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 2 * DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(t, 3 * DoubleDCT_3D.this.slices, scale);
                                        for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                            idx2 = DoubleDCT_3D.this.slices + s;
                                            a[s][r][c] = t[s];
                                            a[s][r][c + 1] = t[idx2];
                                            a[s][r][c + 2] = t[idx2 + DoubleDCT_3D.this.slices];
                                            a[s][r][c + 3] = t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    t[s] = a[s][r][0];
                                    t[((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[s][r][1];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(t, 0, scale);
                                DoubleDCT_3D.this.dctSlices.forward(t, DoubleDCT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    a[s][r][0] = t[s];
                                    a[s][r][1] = t[DoubleDCT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                        idx2 = DoubleDCT_3D.this.slices + s;
                                        t[s] = a[s][r][c];
                                        t[idx2] = a[s][r][c + 1];
                                        t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 2];
                                        t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 3];
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 0, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 2 * DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(t, 3 * DoubleDCT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                        idx2 = DoubleDCT_3D.this.slices + s;
                                        a[s][r][c] = t[s];
                                        a[s][r][c + 1] = t[idx2];
                                        a[s][r][c + 2] = t[idx2 + DoubleDCT_3D.this.slices];
                                        a[s][r][c + 3] = t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDCT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    t[s] = a[s][r][0];
                                    t[((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[s][r][1];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(t, 0, scale);
                                DoubleDCT_3D.this.dctSlices.inverse(t, DoubleDCT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDCT_3D.this.slices; ++s) {
                                    a[s][r][0] = t[s];
                                    a[s][r][1] = t[DoubleDCT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDCT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

