/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstRStrip
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "set"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rstrip";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String set = asts[2].exec(env).getStr();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("trim() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.rstripCategoricalCol(v, set) : this.rstripStringCol(v, set);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec rstripCategoricalCol(Vec vec, String set) {
        String[] doms = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> strippedToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < doms.length; ++i) {
            String stripped;
            doms[i] = stripped = StringUtils.stripEnd(doms[i], set);
            if (!strippedToOldDomainIndices.containsKey(stripped)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i);
                strippedToOldDomainIndices.put(stripped, val);
                continue;
            }
            strippedToOldDomainIndices.get(stripped).add(i);
        }
        if (strippedToOldDomainIndices.size() < doms.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, strippedToOldDomainIndices);
        }
        return vec.makeCopy(doms);
    }

    private Vec rstripStringCol(Vec vec, String set) {
        final String charSet = set;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else if (((CStrChunk)chk)._isAllASCII && StringUtils.isAsciiPrintable(charSet)) {
                    ((CStrChunk)chk).asciiRStrip(newChk, charSet);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk.len(); ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addStr(StringUtils.stripEnd(chk.atStr(tmpStr, i).toString(), charSet));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

