/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DistributionFactory;
import hex.LinkFunction;
import hex.genmodel.utils.LinkFunctionType;

class LogitFunction
extends LinkFunction {
    public LogitFunction() {
        this.linkFunctionType = LinkFunctionType.logit;
    }

    @Override
    public double link(double f) {
        return DistributionFactory.LogExpUtil.log(f / (1.0 - f));
    }

    @Override
    public double linkInv(double f) {
        return 1.0 / (1.0 + DistributionFactory.LogExpUtil.exp(-f));
    }

    @Override
    public String linkInvString(String f) {
        return "1./(1. + " + LogitFunction.expString("-(" + f + ")") + ")";
    }

    @Override
    public String linkInvStringFloat(String f) {
        return "1f/(1f + (float)" + LogitFunction.expString("-(" + f + ")") + ")";
    }
}

