/*
 * Decompiled with CFR 0.152.
 */
package hex.faulttolerance;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hex.Model;
import hex.ModelExportOption;
import hex.faulttolerance.Recoverable;
import hex.grid.Grid;
import hex.grid.GridSearch;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.api.GridSearchHandler;
import water.fvec.Frame;
import water.fvec.persist.FramePersist;
import water.fvec.persist.PersistUtils;
import water.util.FileUtils;
import water.util.IcedHashMap;

public class Recovery<T extends Keyed> {
    private static final Logger LOG = Logger.getLogger(Recovery.class);
    public static final String REFERENCES_META_FILE_SUFFIX = "_references";
    public static final String RECOVERY_META_FILE = "recovery.json";
    public static final String INFO_CLASS = "class";
    public static final String INFO_RESULT_KEY = "resultKey";
    public static final String INFO_JOB_KEY = "jobKey";
    private final String storagePath;
    private final List<String> writtenFiles = new ArrayList<String>();

    public static void autoRecover(Optional<String> autoRecoveryDirOpt) {
        if (!autoRecoveryDirOpt.isPresent() || autoRecoveryDirOpt.get().length() == 0) {
            LOG.debug("Auto recovery dir not configured.");
        } else {
            final String autoRecoveryDir = autoRecoveryDirOpt.get();
            LOG.info("Initializing auto recovery from " + autoRecoveryDir);
            H2O.submitTask(new H2O.H2OCountedCompleter(0){

                @Override
                public void compute2() {
                    new Recovery(autoRecoveryDir).autoRecover();
                    this.tryComplete();
                }
            });
        }
    }

    public Recovery(String storagePath) {
        this.storagePath = storagePath;
    }

    private String recoveryFile(String f) {
        return this.storagePath + "/" + f;
    }

    private String recoveryFile(Key key) {
        return this.recoveryFile(key.toString());
    }

    public String referencesMetaFile(Recoverable<T> r) {
        return this.recoveryFile(r.getKey().toString() + REFERENCES_META_FILE_SUFFIX);
    }

    public String recoveryMetaFile() {
        return this.recoveryFile(RECOVERY_META_FILE);
    }

    public void onStart(Recoverable<T> r, Job job) {
        this.writtenFiles.addAll(r.exportBinary(this.storagePath, true, new ModelExportOption[0]));
        this.exportReferences(r);
        this.writeRecoveryInfo(r, job.getKey());
    }

    public void onModel(Recoverable<T> r, Key<Model> modelKey) {
        try {
            String modelFile = this.recoveryFile(modelKey);
            modelKey.get().exportBinaryModel(modelFile, true, new ModelExportOption[0]);
            this.writtenFiles.add(modelFile);
            r.exportBinary(this.storagePath, false, new ModelExportOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store model for fault tolerance.", e);
        }
    }

    public void onDone(Recoverable<T> r) {
        URI storageUri = FileUtils.getURI(this.storagePath);
        for (String path : this.writtenFiles) {
            URI pathUri = FileUtils.getURI(path);
            H2O.getPM().getPersistForURI(storageUri).delete(pathUri.toString());
        }
    }

    public void exportReferences(Recoverable<T> r) {
        Set<Key<?>> keys = r.getDependentKeys();
        IcedHashMap<String, String> referenceKeyTypeMap = new IcedHashMap<String, String>();
        for (Key<?> k : keys) {
            this.persistObj((Keyed<?>)k.get(), (Map<String, String>)referenceKeyTypeMap);
        }
        URI referencesUri = FileUtils.getURI(this.referencesMetaFile(r));
        this.writtenFiles.add(referencesUri.toString());
        PersistUtils.write(referencesUri, ab -> ab.put(referenceKeyTypeMap));
    }

    private void writeRecoveryInfo(Recoverable<T> r, Key<Job> jobKey) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(INFO_CLASS, r.getClass().getName());
        info.put(INFO_JOB_KEY, jobKey.toString());
        info.put(INFO_RESULT_KEY, r.getKey().toString());
        URI infoUri = FileUtils.getURI(this.recoveryMetaFile());
        this.writtenFiles.add(infoUri.toString());
        PersistUtils.writeStream(infoUri, w -> w.write(new Gson().toJson(info)));
    }

    private void persistObj(Keyed<?> o, Map<String, String> referenceKeyTypeMap) {
        if (o instanceof Frame) {
            referenceKeyTypeMap.put(o._key.toString(), ReferenceType.FRAME.toString());
            String[] writtenFrameFiles = new FramePersist((Frame)o).saveToAndWait(this.storagePath, true);
            this.writtenFiles.addAll(Arrays.asList(writtenFrameFiles));
        } else if (o != null) {
            referenceKeyTypeMap.put(o._key.toString(), ReferenceType.KEYED.toString());
            String destFile = this.storagePath + "/" + o._key;
            URI dest = FileUtils.getURI(destFile);
            PersistUtils.write(dest, ab -> ab.putKey(o._key));
            this.writtenFiles.add(destFile);
        }
    }

    public void loadReferences(Recoverable<T> r) {
        URI referencesUri = FileUtils.getURI(this.storagePath + "/" + r.getKey() + REFERENCES_META_FILE_SUFFIX);
        Map referencesMap = PersistUtils.read(referencesUri, AutoBuffer::get);
        Futures fs = new Futures();
        referencesMap.forEach((key, type) -> {
            switch (ReferenceType.valueOf(type)) {
                case FRAME: {
                    FramePersist.loadFrom(Key.make(key), this.storagePath).get();
                    break;
                }
                case KEYED: {
                    PersistUtils.read(URI.create(this.storagePath + "/" + key), ab -> ab.getKey(Key.make(key), fs));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown reference type " + type);
                }
            }
        });
        fs.blockForPending();
    }

    void autoRecover() {
        URI recoveryMetaUri = FileUtils.getURI(this.recoveryMetaFile());
        if (!PersistUtils.exists(recoveryMetaUri)) {
            LOG.info("No auto-recovery information found.");
            return;
        }
        Map recoveryInfo = PersistUtils.readStream(recoveryMetaUri, r -> (Map)new Gson().fromJson((Reader)r, new TypeToken<Map<String, String>>(){}.getType()));
        String className = (String)recoveryInfo.get(INFO_CLASS);
        Key<Job> jobKey = Key.make((String)recoveryInfo.get(INFO_JOB_KEY));
        Key resultKey = Key.make((String)recoveryInfo.get(INFO_RESULT_KEY));
        if (Grid.class.getName().equals(className)) {
            LOG.info("Auto-recovering previously interrupted grid search.");
            Grid grid = Grid.importBinary(this.recoveryFile(resultKey), true);
            GridSearch.resumeGridSearch(jobKey, grid, new GridSearchHandler.DefaultModelParametersBuilderFactory(), this);
        } else {
            LOG.error("Unable to recover object of class " + className);
        }
    }

    public static enum ReferenceType {
        FRAME,
        KEYED;

    }
}

