/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.GenModel;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import java.io.Serializable;

public class GlmMojoModel
extends GlmMojoModelBase {
    String _link;
    double _tweedieLinkPower;
    private Function1 _linkFn;
    private boolean _binomial;

    GlmMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this._linkFn = this.createLinkFunction();
        this._binomial = "binomial".equals(this._family) || "fractionalbinomial".equals(this._family) || "quasibinomial".equals(this._family);
    }

    @Override
    public final double[] score0(double[] data, double offset, double[] preds) {
        if (this._meanImputation) {
            super.imputeMissingWithMeans(data);
        }
        return this.glmScore0(data, offset, preds);
    }

    double[] glmScore0(double[] data, double offset, double[] preds) {
        int ival;
        int i;
        double eta = 0.0;
        if (!this._useAllFactorLevels) {
            for (i = 0; i < this._catOffsets.length - 1; ++i) {
                if (data[i] == 0.0) continue;
                ival = (int)data[i] - 1;
                if ((double)ival != data[i] - 1.0) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                eta += this._beta[ival];
            }
        } else {
            for (i = 0; i < this._catOffsets.length - 1; ++i) {
                ival = (int)data[i];
                if ((double)ival != data[i]) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                eta += this._beta[ival];
            }
        }
        int noff = this._catOffsets[this._cats] - this._cats;
        for (int i2 = this._cats; i2 < this._beta.length - 1 - noff; ++i2) {
            eta += this._beta[noff + i2] * data[i2];
        }
        eta += this._beta[this._beta.length - 1];
        double mu = this._linkFn.eval(eta += offset);
        if (this._binomial) {
            preds[0] = mu >= this._defaultThreshold ? 1.0 : 0.0;
            preds[1] = 1.0 - mu;
            preds[2] = mu;
        } else {
            preds[0] = mu;
        }
        return preds;
    }

    public double[] applyCoefficients(double[] data, double[] output, int destPos) {
        int offset = this._useAllFactorLevels ? 0 : -1;
        for (int i = 0; i < this._catOffsets.length - 1; ++i) {
            int ival = (int)data[i] - offset;
            if (ival < 0 || (ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
            output[i + destPos] = this._beta[ival];
        }
        int p = destPos + this._catOffsets.length - 1;
        int noff = this._catOffsets[this._cats] - this._cats;
        for (int i = this._cats; i < this._beta.length - 1 - noff; ++i) {
            output[p++] = this._beta[noff + i] * data[i];
        }
        return output;
    }

    public double getIntercept() {
        return this._beta[this._beta.length - 1];
    }

    private Function1 createLinkFunction() {
        if ("identity".equals(this._link)) {
            return new GLM_identityInv();
        }
        if ("logit".equals(this._link)) {
            return new GLM_logitInv();
        }
        if ("log".equals(this._link)) {
            return new GLM_logInv();
        }
        if ("inverse".equals(this._link)) {
            return new GLM_inverseInv();
        }
        if ("tweedie".equals(this._link)) {
            return new GLM_tweedieInv(this._tweedieLinkPower);
        }
        throw new UnsupportedOperationException("Unexpected link function " + this._link);
    }

    private static class GLM_tweedieInv
    implements Function1 {
        private final double _tweedie_link_power;

        GLM_tweedieInv(double tweedie_link_power) {
            this._tweedie_link_power = tweedie_link_power;
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_tweedieInv(x, this._tweedie_link_power);
        }
    }

    private static class GLM_ologitInv
    implements Function1 {
        private GLM_ologitInv() {
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_ologitInv(x);
        }
    }

    private static class GLM_inverseInv
    implements Function1 {
        private GLM_inverseInv() {
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_inverseInv(x);
        }
    }

    private static class GLM_logInv
    implements Function1 {
        private GLM_logInv() {
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_logInv(x);
        }
    }

    private static class GLM_logitInv
    implements Function1 {
        private GLM_logitInv() {
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_logitInv(x);
        }
    }

    private static class GLM_identityInv
    implements Function1 {
        private GLM_identityInv() {
        }

        @Override
        public double eval(double x) {
            return GenModel.GLM_identityInv(x);
        }
    }

    private static interface Function1
    extends Serializable {
        public double eval(double var1);
    }
}

