/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public class MathUtils {
    public static final double EULER_MASCHERONI_CONSTANT = 0.5772156649;

    public static boolean equalsWithinRecSumErr(double actual, double expected, int n, double absum) {
        return Math.abs(actual - expected) <= (double)(n - 1) * Math.ulp(actual) * absum;
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static int log2(long n) {
        return 63 - Long.numberOfLeadingZeros(n);
    }

    public static int combinatorial(int top, int bottom) {
        int denom = 1;
        int numer = 1;
        for (int index = 1; index <= bottom; ++index) {
            numer *= top - index + 1;
            denom *= index;
        }
        return numer / denom;
    }

    public static double harmonicNumberEstimation(long value) {
        if (value <= 0L) {
            return 0.0;
        }
        return Math.log(value) + 0.5772156649;
    }
}

