/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelExportOption;
import hex.ModelParametersBuilderFactory;
import hex.ParallelModelBuilder;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.faulttolerance.Recovery;
import hex.grid.Grid;
import hex.grid.HyperSpaceSearchCriteria;
import hex.grid.HyperSpaceWalker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Keyed;
import water.Value;
import water.exceptions.H2OConcurrentModificationException;
import water.exceptions.H2OGridException;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.Log;
import water.util.PojoUtils;

public final class GridSearch<MP extends Model.Parameters> {
    private Job<Grid> _job;
    private Recovery<Grid> _recovery;
    private int _parallelism = 1;
    private int _maxConsecutiveFailures = Integer.MAX_VALUE;
    private final Key<Grid> _result;
    private final transient HyperSpaceWalker<MP, ?> _hyperSpaceWalker;
    static final Set<String> IGNORED_FIELDS_PARAM_HASH = new HashSet<String>(Arrays.asList("_export_checkpoints_dir", "_max_runtime_secs"));
    public static final int ADAPTIVE_PARALLELISM_LEVEL = 0;
    public static final int SEQUENTIAL_MODEL_BUILDING = 1;

    public static <MP extends Model.Parameters> Builder<MP> create(Key<Grid> destKey, HyperSpaceWalker<MP, ?> walker) {
        assert (walker != null);
        return new Builder(destKey, walker);
    }

    public static <MP extends Model.Parameters> Builder<MP> create(Key<Grid> destKey, MP params, Map<String, Object[]> hyperParams) {
        assert (params != null);
        assert (hyperParams != null);
        HyperSpaceWalker<MP, HyperSpaceSearchCriteria> walker = HyperSpaceWalker.BaseWalker.WalkerFactory.create(params, hyperParams, new SimpleParametersBuilderFactory(), new HyperSpaceSearchCriteria.CartesianSearchCriteria());
        return GridSearch.create(destKey, walker);
    }

    private GridSearch(Key<Grid> gridKey, HyperSpaceWalker<MP, ?> hyperSpaceWalker) {
        assert (hyperSpaceWalker != null) : "Grid search needs to know how to walk around hyper space!";
        this._hyperSpaceWalker = hyperSpaceWalker;
        this._result = gridKey;
    }

    Job<Grid> start() {
        long gridSize = this._hyperSpaceWalker.getMaxHyperSpaceSize();
        Log.info("Starting gridsearch: estimated size of search space = " + gridSize);
        final Grid grid = this.getOrCreateGrid();
        long gridWork = this._hyperSpaceWalker.estimateGridWork(this.maxModels());
        return this._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                block5: {
                    try {
                        GridSearch.this.beforeGridStart(grid);
                        if (GridSearch.this._parallelism == 1) {
                            GridSearch.this.gridSearch(grid);
                            break block5;
                        }
                        if (GridSearch.this._parallelism > 1) {
                            GridSearch.this.parallelGridSearch(grid);
                            break block5;
                        }
                        throw new IllegalArgumentException(String.format("Grid search parallelism level must be >= 1. Give value is '%d'.", GridSearch.this._parallelism));
                    }
                    finally {
                        grid.unlock(GridSearch.this._job);
                    }
                }
                GridSearch.this.afterGridCompleted(grid);
                this.tryComplete();
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                Log.warn("GridSearch job " + ((GridSearch)GridSearch.this)._job._description + " completed with exception: " + ex);
                try {
                    if (Grid.isJobCanceled(ex) && !GridSearch.this._job.isCrashing()) {
                        Log.info("Keeping incomplete grid " + ((GridSearch)GridSearch.this)._job._result + " after cancellation of job " + ((GridSearch)GridSearch.this)._job._description);
                    } else {
                        Keyed.remove(((GridSearch)GridSearch.this)._job._result);
                    }
                }
                catch (Exception logged) {
                    Log.warn("Exception thrown when removing result from job " + ((GridSearch)GridSearch.this)._job._description, logged);
                }
                return true;
            }
        }, gridWork, this.maxRuntimeSecs());
    }

    private Grid getOrCreateGrid() {
        Grid grid = this.loadFromDKV();
        if (grid == null) {
            grid = this.createNewGrid();
        }
        return grid;
    }

    private Grid loadFromDKV() {
        Keyed keyed = (Keyed)DKV.getGet(this._result);
        if (keyed == null) {
            return null;
        }
        if (!(keyed instanceof Grid)) {
            throw new H2OIllegalArgumentException("Name conflict: tried to create a Grid using the ID of a non-Grid object that's already in H2O: " + this._job._result + "; it is a: " + keyed.getClass());
        }
        Grid grid = (Grid)keyed;
        grid.clearNonRelatedFailures();
        Frame specTrainFrame = ((Model.Parameters)this._hyperSpaceWalker.getParams()).train();
        Frame oldTrainFrame = grid.getTrainingFrame();
        if (oldTrainFrame != null && !specTrainFrame._key.equals(oldTrainFrame._key) || oldTrainFrame != null && specTrainFrame.checksum() != oldTrainFrame.checksum()) {
            throw new H2OIllegalArgumentException("training_frame", "grid", "Cannot append new models to a grid with different training input");
        }
        grid.write_lock(this._job);
        return grid;
    }

    private Grid createNewGrid() {
        Grid<MP> grid = new Grid<MP>(this._result, this._hyperSpaceWalker, this._parallelism);
        grid.delete_and_lock(this._job);
        return grid;
    }

    public long getModelCount() {
        return this._hyperSpaceWalker.getMaxHyperSpaceSize();
    }

    private long maxModels() {
        return ((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria() == null ? 0L : (long)((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria().getMaxModels();
    }

    private double maxRuntimeSecs() {
        return ((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria() == null ? 0.0 : ((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria().getMaxRuntimeSecs();
    }

    private double remainingTimeSecs() {
        return this._job != null && this._job._max_runtime_msecs > 0L ? (double)(this._job.start_time() + this._job._max_runtime_msecs - System.currentTimeMillis()) / 1000.0 : Double.MAX_VALUE;
    }

    private ScoreKeeper.StoppingMetric sortingMetric() {
        return ((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria() == null ? ScoreKeeper.StoppingMetric.AUTO : ((HyperSpaceSearchCriteria)this._hyperSpaceWalker.search_criteria()).stoppingCriteria().getStoppingMetric();
    }

    private void parallelGridSearch(Grid<MP> grid) {
        HyperSpaceWalker.HyperSpaceIterator<MP> iterator = this._hyperSpaceWalker.iterator();
        ModelFeeder modelFeeder = new ModelFeeder(iterator, grid);
        ParallelModelBuilder parallelModelBuilder = new ParallelModelBuilder(modelFeeder);
        ArrayList<ModelBuilder> startModels = new ArrayList<ModelBuilder>();
        while (startModels.size() < this._parallelism && iterator.hasNext()) {
            MP nextModelParameters = iterator.nextModelParameters();
            long checksum = ((Model.Parameters)nextModelParameters).checksum(IGNORED_FIELDS_PARAM_HASH);
            if (grid.getModelKey(checksum) != null) continue;
            startModels.add((ModelBuilder)ModelBuilder.make(nextModelParameters));
        }
        if (!startModels.isEmpty()) {
            parallelModelBuilder.run(startModels);
            parallelModelBuilder.join();
        }
        grid.update(this._job);
        this.attemptGridSave(grid);
        if (this._job.stop_requested()) {
            throw new Job.JobCancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gridSearch(Grid<MP> grid) {
        String protoModelKey = grid._key + "_model_";
        HyperSpaceWalker.HyperSpaceIterator<MP> it = this._hyperSpaceWalker.iterator();
        int counter = grid.getModelCount();
        while (it.hasNext()) {
            Model model = null;
            if (this._job.stop_requested()) {
                throw new Job.JobCancelledException();
            }
            try {
                MP params = it.nextModelParameters();
                this.reconcileMaxRuntime(grid._key, (Model.Parameters)params);
                try {
                    ScoringInfo scoringInfo = new ScoringInfo();
                    scoringInfo.time_stamp_ms = System.currentTimeMillis();
                    model = this.buildModel(params, grid, ++counter, protoModelKey);
                    if (model != null) {
                        model.fillScoringInfo(scoringInfo);
                        grid.setScoringInfos(ScoringInfo.prependScoringInfo(scoringInfo, grid.getScoringInfos()));
                        ScoringInfo.sort(grid.getScoringInfos(), this.sortingMetric());
                    }
                }
                catch (RuntimeException e) {
                    grid.appendFailedModelParameters((Key<Model>)(model != null ? model._key : null), params, (Throwable)e);
                    if (Job.isCancelledException(e)) {
                        assert (model == null);
                        long checksum = ((Model.Parameters)params).checksum(IGNORED_FIELDS_PARAM_HASH);
                        Object[] modelKeys = GridSearch.findModelsByChecksum(checksum);
                        if (modelKeys.length == 1) {
                            Keyed.removeQuietly(modelKeys[0]);
                        } else if (modelKeys.length > 1) {
                            Log.warn("Checksum " + checksum + " identified more than one model to clean-up, keeping all: " + Arrays.toString(modelKeys) + ". This could lead to a memory leak.");
                        } else {
                            Log.debug("Model with param checksum " + checksum + " was cancelled before it was installed in DKV.");
                        }
                    } else {
                        Log.warn("Grid search: model builder for parameters " + params + " failed! Exception: ", e);
                        if (grid.countTotalFailures() > this._maxConsecutiveFailures && grid.getModelCount() == 0) {
                            this._job.fail(new H2OGridException("Aborting Grid search after too many consecutive model failures.", e));
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Log.warn("Grid search: construction of model parameters failed! Exception: ", e);
                Key failedModelKey = model != null ? model._key : null;
                it.onModelFailure(model, failedHyperParams -> grid.appendFailedModelParameters((Key<Model>)failedModelKey, (Object[])failedHyperParams, e));
            }
            finally {
                this._job.update(1L);
                grid.update(this._job);
                this.attemptGridSave(grid);
            }
            if (model == null || grid.getScoringInfos() == null || !this._hyperSpaceWalker.stopEarly(model, grid.getScoringInfos())) continue;
            Log.info("Convergence detected based on simple moving average of the loss function. Grid building completed.");
            break;
        }
        Log.info("For grid: " + grid._key + " built: " + grid.getModelCount() + " models.");
    }

    private void reconcileMaxRuntime(Key<Grid<MP>> gridKey, Model.Parameters params) {
        double grid_max_runtime_secs = (double)this._job._max_runtime_msecs / 1000.0;
        double time_remaining_secs = this.remainingTimeSecs();
        if (grid_max_runtime_secs > 0.0) {
            Log.info("Grid time is limited to: " + grid_max_runtime_secs + " for grid: " + gridKey + ". Remaining time is: " + time_remaining_secs);
            if (time_remaining_secs < 0.0) {
                Log.info("Grid max_runtime_secs of " + grid_max_runtime_secs + " secs has expired; stopping early.");
                throw new Job.JobCancelledException();
            }
        }
        if (params._max_runtime_secs > 0.0) {
            double was = params._max_runtime_secs;
            params._max_runtime_secs = Math.min(params._max_runtime_secs, time_remaining_secs);
            Log.info("Due to the grid time limit, changing model max runtime from: " + was + " secs to: " + params._max_runtime_secs + " secs.");
        } else {
            params._max_runtime_secs = time_remaining_secs == Double.MAX_VALUE ? 0.0 : time_remaining_secs;
            Log.info("Due to the grid time limit, changing model max runtime to: " + params._max_runtime_secs + " secs.");
        }
    }

    private void beforeGridStart(Grid grid) {
        if (this._recovery != null) {
            this._recovery.onStart(grid, this._job);
        }
    }

    private void afterGridCompleted(Grid grid) {
        if (this._recovery != null) {
            this._recovery.onDone(grid);
        }
    }

    private void onModel(Grid grid, long checksum, Key<Model> modelKey) {
        grid.putModel(checksum, modelKey);
        if (this._recovery != null) {
            this._recovery.onModel(grid, modelKey);
        }
    }

    private void attemptGridSave(Grid grid) {
        String checkpointsDir = ((Model.Parameters)this._hyperSpaceWalker.getParams())._export_checkpoints_dir;
        if (checkpointsDir == null) {
            return;
        }
        grid.exportBinary(checkpointsDir, false, new ModelExportOption[0]);
    }

    private Model buildModel(MP params, Grid<MP> grid, int paramsIdx, String protoModelKey) {
        Key<Model>[] modelKeys;
        long checksum = ((Model.Parameters)params).checksum(IGNORED_FIELDS_PARAM_HASH);
        Key<Model> key = grid.getModelKey(checksum);
        if (key != null) {
            if (DKV.get(key) == null) {
                Log.info("GridSearch.buildModel(): model with these parameters was built but removed, rebuilding; checksum: " + checksum);
            } else {
                Log.info("GridSearch.buildModel(): model with these parameters already exists, skipping; checksum: " + checksum);
                return key.get();
            }
        }
        if ((modelKeys = GridSearch.findModelsByChecksum(checksum)).length > 0) {
            this.onModel(grid, checksum, modelKeys[0]);
            return modelKeys[0].get();
        }
        Key<Model> result = Key.make(protoModelKey + paramsIdx);
        assert (grid.getModel(params) == null);
        Model m = ModelBuilder.trainModelNested(this._job, result, params, null);
        assert (checksum == ((Model.Parameters)m._input_parms).checksum(IGNORED_FIELDS_PARAM_HASH)) : "Model checksum different from original params";
        this.onModel(grid, checksum, result);
        return m;
    }

    static Key<Model>[] findModelsByChecksum(final long checksum) {
        return KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

            @Override
            public boolean filter(KeySnapshot.KeyInfo k) {
                if (!Value.isSubclassOf(k._type, Model.class)) {
                    return false;
                }
                Model m = (Model)k._key.get();
                if (m == null || m._parms == null) {
                    return false;
                }
                try {
                    return ((Model.Parameters)m._parms).checksum(IGNORED_FIELDS_PARAM_HASH) == checksum;
                }
                catch (H2OConcurrentModificationException e) {
                    Log.warn("GridSearch encountered concurrent modification while searching DKV", e);
                    return false;
                }
                catch (RuntimeException e) {
                    Throwable ex = e;
                    boolean concurrentModification = false;
                    while (ex.getCause() != null) {
                        if (!((ex = ex.getCause()) instanceof H2OConcurrentModificationException)) continue;
                        concurrentModification = true;
                        break;
                    }
                    if (!concurrentModification) {
                        throw e;
                    }
                    Log.warn("GridSearch encountered concurrent modification while searching DKV", e);
                    return false;
                }
            }
        }).keys();
    }

    protected static Key<Grid> gridKeyName(String modelName, Frame fr) {
        if (fr == null || fr._key == null) {
            throw new IllegalArgumentException("The frame being grid-searched over must have a Key");
        }
        return Key.make("Grid_" + modelName + "_" + fr._key.toString() + H2O.calcNextUniqueModelId(""));
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Grid> destKey, MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria searchCriteria, int parallelism) {
        return GridSearch.startGridSearch(null, destKey, params, hyperParams, paramsBuilderFactory, searchCriteria, null, parallelism);
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Job> jobKey, Key<Grid> destKey, MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria searchCriteria, Recovery<Grid> recovery, int parallelism) {
        return GridSearch.startGridSearch(jobKey, destKey, HyperSpaceWalker.BaseWalker.WalkerFactory.create(params, hyperParams, paramsBuilderFactory, searchCriteria), recovery, parallelism);
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Grid> destKey, MP params, Map<String, Object[]> hyperParams) {
        return GridSearch.create(destKey, params, hyperParams).start();
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Grid> destKey, MP params, Map<String, Object[]> hyperParams, int parallelism) {
        return GridSearch.create(destKey, params, hyperParams).withParallelism(parallelism).start();
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Grid> destKey, HyperSpaceWalker<MP, ?> hyperSpaceWalker, int parallelism) {
        return GridSearch.create(destKey, hyperSpaceWalker).withParallelism(parallelism).start();
    }

    @Deprecated
    public static <MP extends Model.Parameters> Job<Grid> startGridSearch(Key<Job> jobKey, Key<Grid> destKey, HyperSpaceWalker<MP, ?> hyperSpaceWalker, Recovery<Grid> recovery, int parallelism) {
        return GridSearch.create(destKey, hyperSpaceWalker).withParallelism(parallelism).withRecoverableJob(jobKey, recovery).start();
    }

    public static <MP extends Model.Parameters> Job<Grid> resumeGridSearch(Key<Job> jobKey, Grid<MP> grid, ModelParametersBuilderFactory<MP> paramsBuilderFactory, Recovery<Grid> recovery) {
        return GridSearch.startGridSearch(jobKey, grid._key, grid.getParams(), grid.getHyperParams(), paramsBuilderFactory, grid.getSearchCriteria(), recovery, grid.getParallelism());
    }

    public static int getParallelismLevel(int parallelism) {
        if (parallelism < 0) {
            throw new IllegalArgumentException(String.format("Grid search parallelism level must be >= 0. Give value is '%d'.", parallelism));
        }
        if (parallelism == 0) {
            return GridSearch.getAdaptiveParallelism();
        }
        return parallelism;
    }

    public static int getAdaptiveParallelism() {
        return 2 * H2O.NUMCPUS;
    }

    public static class SimpleParametersBuilderFactory<MP extends Model.Parameters>
    implements ModelParametersBuilderFactory<MP> {
        @Override
        public ModelParametersBuilderFactory.ModelParametersBuilder<MP> get(MP initialParams) {
            return new SimpleParamsBuilder<MP>(initialParams);
        }

        @Override
        public PojoUtils.FieldNaming getFieldNamingStrategy() {
            return PojoUtils.FieldNaming.CONSISTENT;
        }

        public static class SimpleParamsBuilder<MP extends Model.Parameters>
        implements ModelParametersBuilderFactory.ModelParametersBuilder<MP> {
            private final MP params;

            public SimpleParamsBuilder(MP initialParams) {
                this.params = initialParams;
            }

            @Override
            public ModelParametersBuilderFactory.ModelParametersBuilder<MP> set(String name, Object value) {
                PojoUtils.setField(this.params, name, value, PojoUtils.FieldNaming.CONSISTENT);
                return this;
            }

            @Override
            public MP build() {
                return this.params;
            }
        }
    }

    private class ModelFeeder
    extends ParallelModelBuilder.ParallelModelBuilderCallback<ModelFeeder> {
        private final HyperSpaceWalker.HyperSpaceIterator<MP> hyperspaceIterator;
        private final Grid grid;
        private final Lock parallelSearchGridLock = new ReentrantLock();

        public ModelFeeder(HyperSpaceWalker.HyperSpaceIterator<MP> hyperspaceIterator, Grid grid) {
            this.hyperspaceIterator = hyperspaceIterator;
            this.grid = grid;
        }

        @Override
        public void onBuildSuccess(Model finishedModel, ParallelModelBuilder parallelModelBuilder) {
            try {
                this.parallelSearchGridLock.lock();
                this.constructScoringInfo(finishedModel);
                GridSearch.this.onModel(this.grid, ((Model.Parameters)finishedModel._input_parms).checksum(IGNORED_FIELDS_PARAM_HASH), finishedModel._key);
                GridSearch.this._job.update(1L);
                this.grid.update(GridSearch.this._job);
                GridSearch.this.attemptGridSave(this.grid);
            }
            finally {
                this.parallelSearchGridLock.unlock();
            }
            this.attemptBuildNextModel(parallelModelBuilder, finishedModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBuildFailure(ParallelModelBuilder.ModelBuildFailure modelBuildFailure, ParallelModelBuilder parallelModelBuilder) {
            this.parallelSearchGridLock.lock();
            Throwable ex = modelBuildFailure.getThrowable();
            try {
                this.grid.appendFailedModelParameters(null, modelBuildFailure.getParameters(), ex);
            }
            finally {
                this.parallelSearchGridLock.unlock();
            }
            if (this.grid.countTotalFailures() > GridSearch.this._maxConsecutiveFailures && this.grid.getModelCount() == 0 && !Grid.isJobCanceled(ex)) {
                GridSearch.this._job.fail(new H2OGridException("Aborting Grid search after too many consecutive model failures.", ex));
            } else {
                this.attemptBuildNextModel(parallelModelBuilder, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attemptBuildNextModel(ParallelModelBuilder parallelModelBuilder, Model previousModel) {
            try {
                this.parallelSearchGridLock.lock();
                Object nextModelParams = this.getNextModelParams(this.hyperspaceIterator, previousModel, this.grid);
                if (nextModelParams != null && this.isThereEnoughTime() && !GridSearch.this._job.stop_requested() && !GridSearch.this._hyperSpaceWalker.stopEarly(previousModel, this.grid.getScoringInfos())) {
                    GridSearch.this.reconcileMaxRuntime(this.grid._key, nextModelParams);
                    parallelModelBuilder.run(Collections.singletonList(ModelBuilder.make(nextModelParams)));
                }
            }
            finally {
                this.parallelSearchGridLock.unlock();
            }
        }

        private void constructScoringInfo(Model model) {
            ScoringInfo scoringInfo = new ScoringInfo();
            scoringInfo.time_stamp_ms = System.currentTimeMillis();
            model.fillScoringInfo(scoringInfo);
            this.grid.setScoringInfos(ScoringInfo.prependScoringInfo(scoringInfo, this.grid.getScoringInfos()));
            ScoringInfo.sort(this.grid.getScoringInfos(), GridSearch.this.sortingMetric());
        }

        private boolean isThereEnoughTime() {
            boolean enoughTime;
            boolean bl = enoughTime = GridSearch.this.remainingTimeSecs() > 0.0;
            if (!enoughTime) {
                Log.info("Grid max_runtime_secs of " + GridSearch.this.maxRuntimeSecs() + " secs has expired; stopping early.");
            }
            return enoughTime;
        }

        private MP getNextModelParams(HyperSpaceWalker.HyperSpaceIterator<MP> hyperSpaceIterator, Model model, Grid grid) {
            Model.Parameters params = null;
            while (params == null && hyperSpaceIterator.hasNext()) {
                params = (Model.Parameters)hyperSpaceIterator.nextModelParameters();
                Key<Model> modelKey = grid.getModelKey(params.checksum(IGNORED_FIELDS_PARAM_HASH));
                if (modelKey == null) continue;
                params = null;
            }
            return params;
        }
    }

    public static class Builder<MP extends Model.Parameters> {
        private final GridSearch<MP> _gridSearch;

        private Builder(Key<Grid> destKey, HyperSpaceWalker<MP, ?> hyperSpaceWalker) {
            assert (hyperSpaceWalker != null);
            if (destKey == null) {
                MP params = hyperSpaceWalker.getParams();
                destKey = GridSearch.gridKeyName(((Model.Parameters)params).algoName(), ((Model.Parameters)params).train());
            }
            this._gridSearch = new GridSearch(destKey, hyperSpaceWalker);
        }

        public Builder<MP> withParallelism(int parallelism) {
            ((GridSearch)this._gridSearch)._parallelism = parallelism;
            return this;
        }

        public Builder<MP> withMaxConsecutiveFailures(int maxConsecutiveFailures) {
            ((GridSearch)this._gridSearch)._maxConsecutiveFailures = maxConsecutiveFailures;
            return this;
        }

        public Builder<MP> withJob(Key<Job> jobKey) {
            return this.withRecoverableJob(jobKey, null);
        }

        public Builder<MP> withRecoverableJob(Key<Job> jobKey, Recovery recovery) {
            assert (((GridSearch)this._gridSearch)._job == null);
            String algoName = ((Model.Parameters)((GridSearch)this._gridSearch)._hyperSpaceWalker.getParams()).algoName();
            boolean recoverable = recovery != null && H2O.ARGS.auto_recovery_dir != null;
            ((GridSearch)this._gridSearch)._recovery = recovery;
            ((GridSearch)this._gridSearch)._job = new Job(jobKey, ((GridSearch)this._gridSearch)._result, Grid.class.getName(), algoName + " Grid Search", recoverable);
            return this;
        }

        public Job<Grid> start() {
            if (((GridSearch)this._gridSearch)._job == null) {
                this.withJob(null);
            }
            return this._gridSearch.start();
        }
    }
}

