/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.Frame;
import water.fvec.OneChunkVec;
import water.fvec.Vec;
import water.util.fp.Function;

public class SplitToChunksApplyCombine {
    public static Frame concatFrames(List<Frame> frms, Key<Frame> destinationKey) {
        Frame result = new Frame(destinationKey);
        long nRows = frms.stream().mapToLong(frame -> frame.numRows()).sum();
        for (int i = 0; i < frms.get(0).numCols(); ++i) {
            Vec v = Vec.makeZero(nRows);
            try (Vec.Writer vw = v.open();){
                long cnt = 0L;
                for (Frame fr : frms) {
                    Vec.Reader vr = new Vec.Reader(fr.vec(i));
                    int k = 0;
                    while ((long)k < fr.numRows()) {
                        vw.set(cnt++, vr.at(k));
                        ++k;
                    }
                }
            }
            result.add(frms.get((int)0)._names[i], v);
        }
        DKV.put(result);
        return result;
    }

    public static Frame createSubFrame(Frame fr, int cidx, String destinationKeyPrefix) {
        assert (cidx >= 0 && fr.anyVec().nChunks() > cidx);
        Futures fs = new Futures();
        Vec[] vecs = (Vec[])Arrays.stream(fr.vecs()).map(v -> OneChunkVec.make(v, cidx, fs)).toArray(Vec[]::new);
        fs.blockForPending();
        return new Frame(Key.make(destinationKeyPrefix + "_oneChunkFrame_" + cidx), fr.names(), vecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splitApplyCombine(Frame frameToSplit, Function<Frame, Frame> fun, Key<Frame> destinationKey) {
        LinkedList<Frame> resultSubFrames = new LinkedList<Frame>();
        Frame result = null;
        try {
            int nChunks = frameToSplit.anyVec().nChunks();
            for (int cidx = 0; cidx < nChunks; ++cidx) {
                Frame subFrame;
                block14: {
                    subFrame = SplitToChunksApplyCombine.createSubFrame(frameToSplit, cidx, destinationKey.toString());
                    if (subFrame.numRows() != 0L) break block14;
                    for (Vec v : subFrame.vecs()) {
                        DKV.remove(v._key);
                    }
                    subFrame.delete();
                    continue;
                }
                try {
                    DKV.put(subFrame);
                    resultSubFrames.add(fun.apply(subFrame));
                }
                catch (Throwable throwable) {
                    for (Vec v : subFrame.vecs()) {
                        DKV.remove(v._key);
                    }
                    subFrame.delete();
                    throw throwable;
                }
                for (Vec v : subFrame.vecs()) {
                    DKV.remove(v._key);
                }
                subFrame.delete();
                continue;
            }
            Frame frame = result = SplitToChunksApplyCombine.concatFrames(resultSubFrames, destinationKey);
            return frame;
        }
        finally {
            if (null != result) {
                for (Frame fr : resultSubFrames) {
                    Frame.deleteTempFrameAndItsNonSharedVecs(fr, frameToSplit);
                }
            } else {
                for (Frame fr : resultSubFrames) {
                    fr.delete();
                }
            }
        }
    }
}

