/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import water.clustering.api.HttpResponses;

public class AssistedClusteringEndpoint
implements HttpHandler,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(AssistedClusteringEndpoint.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean flatFileReceived;
    private final ExecutorService flatFileConsumerCallbackExecutor = Executors.newSingleThreadExecutor();
    private final Consumer<String> flatFileConsumer;

    public AssistedClusteringEndpoint(Consumer<String> flatFileConsumer) {
        this.flatFileConsumer = flatFileConsumer;
        this.flatFileReceived = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String postBody;
        if (!"POST".equals(httpExchange.getRequestMethod())) {
            HttpResponses.newResponseCodeOnlyResponse(httpExchange, 405);
        }
        try (InputStreamReader isr = new InputStreamReader(httpExchange.getRequestBody(), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            postBody = br.lines().collect(Collectors.joining("\n"));
            if (postBody.isEmpty()) {
                HttpResponses.newFixedLengthResponse(httpExchange, 400, "text/plain", "Unable to parse IP addresses in body. Only one IPv4/IPv6 address per line is accepted.");
                return;
            }
        }
        catch (IOException e) {
            LOG.error("Received incorrect flatfile request.", e);
            HttpResponses.newResponseCodeOnlyResponse(httpExchange, 400);
            return;
        }
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (this.flatFileReceived.get()) {
                HttpResponses.newFixedLengthResponse(httpExchange, 400, "text/plain", "Flatfile already provided.");
                return;
            }
            this.flatFileConsumerCallbackExecutor.submit(() -> this.flatFileConsumer.accept(postBody));
            this.flatFileReceived.set(true);
        }
        finally {
            writeLock.unlock();
        }
        HttpResponses.newResponseCodeOnlyResponse(httpExchange, 200);
    }

    @Override
    public void close() {
        this.flatFileConsumerCallbackExecutor.shutdown();
    }
}

