/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Consumer;
import water.clustering.api.AssistedClusteringEndpoint;
import water.clustering.api.H2OClusterStatusEndpoint;

public class AssistedClusteringRestApi
implements AutoCloseable {
    private static final int DEFAULT_PORT = 8080;
    public static final String ASSISTED_CLUSTERING_PORT_KEY = "H2O_ASSISTED_CLUSTERING_API_PORT";
    private final AssistedClusteringEndpoint assistedClusteringEndpoint;
    private final HttpServer server;

    public AssistedClusteringRestApi(Consumer<String> flatFileConsumer) throws IOException {
        Objects.requireNonNull(flatFileConsumer);
        this.assistedClusteringEndpoint = new AssistedClusteringEndpoint(flatFileConsumer);
        int port = AssistedClusteringRestApi.getPort();
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.addMappings();
    }

    private static int getPort() {
        String customPort = System.getenv(ASSISTED_CLUSTERING_PORT_KEY);
        if (customPort == null) {
            return 8080;
        }
        try {
            return Integer.parseInt(customPort);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Unusable port for Assisted clustering REST API to bind to: '%s'", customPort);
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private void addMappings() {
        this.server.createContext("/clustering/flatfile", this.assistedClusteringEndpoint);
        this.server.createContext("/cluster/status", new H2OClusterStatusEndpoint());
    }

    @Override
    public void close() {
        this.assistedClusteringEndpoint.close();
        this.server.stop(0);
    }

    public void start() throws IOException {
        this.server.start();
    }
}

