/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import water.H2O;
import water.H2ONode;
import water.clustering.api.HttpResponses;

public class H2OClusterStatusEndpoint
implements HttpHandler {
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        boolean clustered;
        if (!"GET".equals(httpExchange.getRequestMethod())) {
            HttpResponses.newResponseCodeOnlyResponse(httpExchange, 405);
        }
        if (!H2O.isFlatfileEnabled()) {
            HttpResponses.newResponseCodeOnlyResponse(httpExchange, 204);
            return;
        }
        Set<H2ONode> flatFile = H2O.getFlatfile();
        H2ONode[] cloudMembers = H2O.CLOUD.members();
        boolean bl = clustered = flatFile != null && cloudMembers != null && cloudMembers.length == flatFile.size() && flatFile.containsAll(Arrays.asList(cloudMembers));
        if (!clustered) {
            HttpResponses.newResponseCodeOnlyResponse(httpExchange, 204);
        } else {
            HttpResponses.newFixedLengthResponse(httpExchange, 200, "application/json", this.nodesListJson());
        }
    }

    private String nodesListJson() {
        H2ONode[] cloudMembers = H2O.CLOUD.members();
        StringBuilder healthyNodesStringArray = new StringBuilder();
        StringBuilder unhealthyNodesStringArray = new StringBuilder();
        int healthyNodeCount = 0;
        int unhealthyNodeCount = 0;
        for (H2ONode node : cloudMembers) {
            if (node.isHealthy()) {
                healthyNodesStringArray.append('\"');
                healthyNodesStringArray.append(node.getIpPortString());
                healthyNodesStringArray.append("\",");
                ++healthyNodeCount;
                continue;
            }
            unhealthyNodesStringArray.append('\"');
            unhealthyNodesStringArray.append(node.getIpPortString());
            unhealthyNodesStringArray.append('\"');
            unhealthyNodesStringArray.append("\",");
            ++unhealthyNodeCount;
        }
        if (healthyNodeCount > 0) {
            healthyNodesStringArray.deleteCharAt(healthyNodesStringArray.length() - 1);
        }
        if (unhealthyNodeCount > 0) {
            unhealthyNodesStringArray.deleteCharAt(unhealthyNodesStringArray.length() - 1);
        }
        return String.format("{\n\"leader_node\": \"%s\",\n\"healthy_nodes\": [%s],\n\"unhealthy_nodes\": [%s]\n}", H2O.CLOUD.leader().getIpPortString(), healthyNodesStringArray.toString(), unhealthyNodesStringArray.toString());
    }
}

