/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.TAtomic;
import water.Value;
import water.fvec.AppendableVec;
import water.fvec.C0DChunk;
import water.fvec.C0LChunk;
import water.fvec.CStrChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.RollupStats;
import water.nbhm.NonBlockingHashMap;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;
import water.util.UnsafeUtils;
import water.util.VecUtils;

public class Vec
extends Keyed<Vec> {
    byte _type;
    public int _rowLayout;
    private transient long[] _espc;
    private String[] _domain;
    private transient Key _rollupStatsKey;
    private boolean _volatile;
    public static final byte T_BAD = 0;
    public static final byte T_UUID = 1;
    public static final byte T_STR = 2;
    public static final byte T_NUM = 3;
    public static final byte T_CAT = 4;
    public static final byte T_TIME = 5;
    public static final String[] TYPE_STR = new String[]{"BAD", "UUID", "String", "Numeric", "Enum", "Time", "Time", "Time"};
    public static final boolean DO_HISTOGRAMS = true;
    public static final double[] PERCENTILES = new double[]{0.001, 0.01, 0.1, 0.2, 0.25, 0.3, 0.3333333333333333, 0.4, 0.5, 0.6, 0.6666666666666666, 0.7, 0.75, 0.8, 0.9, 0.99, 0.999};
    public transient int[] _cids;
    public static final int KEY_PREFIX_LEN = 10;

    public String[] domain() {
        return this._domain;
    }

    public final String factor(long i) {
        return this._domain[(int)i];
    }

    public final void setDomain(String[] domain) {
        this._domain = domain;
        if (domain != null) {
            this._type = (byte)4;
        }
    }

    public final int cardinality() {
        return this.isCategorical() ? this._domain.length : -1;
    }

    public final boolean isDomainTruncated(int expectedCardinality) {
        return this.cardinality() == expectedCardinality + 1 && "other".equals(this._domain[this._domain.length - 1]);
    }

    public final boolean isCategorical() {
        assert (this._type == 4 && this._domain != null || this._type != 4 && this._domain == null || this._type == 3 && this instanceof InteractionWrappedVec && this._domain != null);
        return this._type == 4;
    }

    public final double sparseRatio() {
        return (double)this.rollupStats()._nzCnt / (double)this.length();
    }

    public final boolean isUUID() {
        return this._type == 1;
    }

    public final boolean isString() {
        return this._type == 2;
    }

    public final boolean isNumeric() {
        return this._type == 3;
    }

    public final boolean isTime() {
        return this._type == 5;
    }

    public Vec(Key<Vec> key, int rowLayout) {
        this(key, rowLayout, null, 3);
    }

    Vec(Key<Vec> key, int rowLayout, String[] domain) {
        this(key, rowLayout, domain, domain == null ? (byte)3 : 4);
    }

    public Vec(Key<Vec> key, int rowLayout, String[] domain, byte type) {
        super(key);
        assert (key._kb[0] == 4);
        assert (domain == null || type == 4);
        assert (0 <= type && type <= 5);
        this._rowLayout = rowLayout;
        this._type = type;
        this._domain = domain;
        this._espc = ESPC.espc(this);
    }

    public long[] espc() {
        if (this._espc == null) {
            this._espc = ESPC.espc(this);
        }
        return this._espc;
    }

    public long length() {
        this.espc();
        return this._espc[this._espc.length - 1];
    }

    public int nChunks() {
        return this.espc().length - 1;
    }

    public int nonEmptyChunks() {
        int nonEmptyCnt = this.nChunks();
        for (int i = 1; i < this._espc.length; ++i) {
            if (this._espc[i - 1] != this._espc[i]) continue;
            --nonEmptyCnt;
        }
        return nonEmptyCnt;
    }

    long chunk2StartElem(int cidx) {
        return this.espc()[cidx];
    }

    public int chunkLen(int cidx) {
        this.espc();
        return (int)(this._espc[cidx + 1] - this._espc[cidx]);
    }

    public boolean isCompatibleWith(Vec v) {
        return !(this.espc() != v.espc() && !Arrays.equals(this._espc, v._espc) || !VectorGroup.sameGroup(this, v) && !((double)this.length() < 1000.0));
    }

    boolean readable() {
        return true;
    }

    boolean writable() {
        return true;
    }

    public void setBad() {
        this._type = 0;
    }

    public byte get_type() {
        return this._type;
    }

    public String get_type_str() {
        return TYPE_STR[this._type];
    }

    public boolean isBinary() {
        RollupStats rs = this.rollupStats();
        return rs._isInt && rs._mins[0] >= 0.0 && rs._maxs[0] <= 1.0;
    }

    public boolean isBinary(boolean strict) {
        if (strict) {
            return (this.isBinary() || this.isBinaryOnes()) && !this.isConst();
        }
        return this.isBinary();
    }

    public boolean isBinaryOnes() {
        RollupStats rs = this.rollupStats();
        long zeroCount = rs._rows - rs._nzCnt;
        return rs._isInt && rs._mins[0] >= -1.0 && rs._maxs[0] <= 1.0 && zeroCount == 0L;
    }

    public static Vec makeZero(long len, boolean redistribute) {
        return Vec.makeCon(0.0, len, redistribute);
    }

    public static Vec makeZero(long len) {
        return Vec.makeZero(len, (byte)3);
    }

    public static Vec makeOne(long len) {
        return Vec.makeOne(len, (byte)3);
    }

    public static Vec makeOne(long len, byte typeCode) {
        return Vec.makeCon(1.0, len, true, typeCode);
    }

    public static Vec makeZero(long len, byte typeCode) {
        return Vec.makeCon(0.0, len, true, typeCode);
    }

    public static Vec makeCon(double x, long len) {
        return Vec.makeCon(x, len, true);
    }

    public static Vec makeCon(double x, long len, byte type) {
        int log_rows_per_chunk = 22;
        return Vec.makeCon(x, len, log_rows_per_chunk, true, type);
    }

    public static Vec makeCon(double x, long len, boolean redistribute) {
        return Vec.makeCon(x, len, redistribute, (byte)3);
    }

    public static Vec makeCon(double x, long len, boolean redistribute, byte typeCode) {
        int log_rows_per_chunk = 22;
        return Vec.makeCon(x, len, log_rows_per_chunk, redistribute, typeCode);
    }

    public static Vec makeCon(double x, long len, int log_rows_per_chunk) {
        return Vec.makeCon(x, len, log_rows_per_chunk, true);
    }

    public static Vec makeCon(long totSize, long len) {
        int safetyInflationFactor = 8;
        int nchunks = (int)Math.max(totSize * 8L / Integer.MAX_VALUE, 1L);
        return Vec.makeConN(len, nchunks);
    }

    public static Vec makeConN(long len, int nchunks) {
        long[] espc = new long[nchunks + 1];
        espc[0] = 0L;
        for (int i = 1; i < nchunks; ++i) {
            espc[i] = espc[i - 1] + len / (long)nchunks;
        }
        espc[nchunks] = len;
        VectorGroup vg = VectorGroup.VG_LEN1;
        return Vec.makeCon(0.0, vg, ESPC.rowLayout(vg._key, espc), (byte)3);
    }

    public static int nChunksFor(long len, int log_rows_per_chunk, boolean redistribute) {
        int chunks0 = (int)Math.max(1L, len >> log_rows_per_chunk);
        int chunks1 = (int)Math.min((long)(4 * H2O.NUMCPUS * H2O.CLOUD.size()), len);
        int nchunks = redistribute && chunks0 < chunks1 && len > (long)(10 * chunks1) ? chunks1 : chunks0;
        return nchunks;
    }

    public static Vec makeCon(double x, long len, int log_rows_per_chunk, boolean redistribute) {
        return Vec.makeCon(x, len, log_rows_per_chunk, redistribute, (byte)3);
    }

    public static Vec makeCon(double x, long len, int log_rows_per_chunk, boolean redistribute, byte type) {
        int nchunks = Vec.nChunksFor(len, log_rows_per_chunk, redistribute);
        long[] espc = new long[nchunks + 1];
        espc[0] = 0L;
        for (int i = 1; i < nchunks; ++i) {
            espc[i] = redistribute ? espc[i - 1] + len / (long)nchunks : (long)i << log_rows_per_chunk;
        }
        espc[nchunks] = len;
        VectorGroup vg = VectorGroup.VG_LEN1;
        return Vec.makeCon(x, vg, ESPC.rowLayout(vg._key, espc), type);
    }

    public Vec[] makeDoubles(int n, double[] values) {
        Key<Vec>[] keys = this.group().addVecs(n);
        Vec[] res = new Vec[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new Vec(keys[i], this._rowLayout);
        }
        Vec.fillDoubleChunks(this, res, values);
        Futures fs = new Futures();
        for (Vec v : res) {
            DKV.put(v, fs);
        }
        fs.blockForPending();
        return res;
    }

    private static void fillDoubleChunks(Vec v, final Vec[] ds, final double[] values) {
        new MRTask(){

            @Override
            public void map(Chunk c) {
                for (int i = 0; i < ds.length; ++i) {
                    DKV.put(ds[i].chunkKey(c.cidx()), new C0DChunk(values[i], c._len << 3));
                }
            }
        }.doAll(v);
    }

    public Vec makeZero() {
        return Vec.makeCon(0L, null, this.group(), this._rowLayout);
    }

    public Vec makeZero(String[] domain) {
        return Vec.makeCon(0L, domain, this.group(), this._rowLayout);
    }

    public Vec makeCopy() {
        return this.makeCopy(this.domain());
    }

    public Vec makeCopy(String[] domain) {
        byte type = this._type == 4 && domain == null ? (byte)3 : this._type;
        return this.makeCopy(domain, type);
    }

    public Vec makeCopy(String[] domain, byte type) {
        if (domain == null && type == 4) {
            throw new IllegalArgumentException("Desired Vec type is Categorical but not domain provided.");
        }
        Vec v = this.doCopy();
        v._domain = domain;
        v._type = type;
        DKV.put(v);
        return v;
    }

    public Vec doCopy() {
        final Vec v = new Vec(this.group().addVec(), this._rowLayout);
        new MRTask(){

            @Override
            public void map(Chunk c) {
                Chunk c2 = c.deepCopy();
                DKV.put(v.chunkKey(c.cidx()), c2, this._fs);
            }
        }.doAll(this);
        return v;
    }

    public static Vec makeCon(long l, String[] domain, VectorGroup group2, int rowLayout) {
        return Vec.makeCon(l, domain, group2, rowLayout, domain == null ? (byte)3 : 4);
    }

    private static Vec makeCon(final long l, String[] domain, VectorGroup group2, int rowLayout, byte type) {
        final Vec v0 = new Vec(group2.addVec(), rowLayout, domain, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i = 0; i < nchunks; ++i) {
                    Key k = v0.chunkKey(i);
                    if (!k.home()) continue;
                    DKV.put(k, new C0LChunk(l, v0.chunkLen(i)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public static Vec makeTimeVec(double[] vals, Key<Vec> vecKey) {
        if (vecKey == null) {
            vecKey = VectorGroup.VG_LEN1.addVec();
        }
        int layout = ESPC.rowLayout(vecKey, new long[]{0L, vals.length});
        Vec v = new Vec(vecKey, layout, null, 5);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (double d : vals) {
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(double[] vals, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}));
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (double d : vals) {
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(float[] vals, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}));
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (float d : vals) {
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(String[] vals, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), null, 2);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (String s : vals) {
            nc.addStr(s);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(float[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (float d : vals) {
            assert (Float.isNaN(d) || (float)((long)d) == d);
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(double[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (double d : vals) {
            assert (Double.isNaN(d) || (double)((long)d) == d);
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(long[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (long d : vals) {
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec[] makeCons(double x, long len, int n) {
        Vec[] vecs = new Vec[n];
        for (int i = 0; i < n; ++i) {
            vecs[i] = Vec.makeCon(x, len, true);
        }
        return vecs;
    }

    public Vec makeCon(double d) {
        return Vec.makeCon(d, this.group(), this._rowLayout, (byte)3);
    }

    public Vec makeCon(double d, byte type) {
        return Vec.makeCon(d, this.group(), this._rowLayout, type);
    }

    public Vec makeCon(byte type) {
        return Vec.makeCon(0L, null, this.group(), this._rowLayout, type);
    }

    private static Vec makeCon(final double d, VectorGroup group2, int rowLayout, byte type) {
        if ((double)((long)d) == d) {
            return Vec.makeCon((long)d, null, group2, rowLayout, type);
        }
        final Vec v0 = new Vec(group2.addVec(), rowLayout, null, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i = 0; i < nchunks; ++i) {
                    Key k = v0.chunkKey(i);
                    if (!k.home()) continue;
                    DKV.put(k, new C0DChunk(d, v0.chunkLen(i)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public Vec makeCon(String s) {
        return Vec.makeCon(s, this.group(), this._rowLayout, (byte)2);
    }

    private static Vec makeCon(final String s, VectorGroup group2, int rowLayout, byte type) {
        final Vec v0 = new Vec(group2.addVec(), rowLayout, null, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i = 0; i < nchunks; ++i) {
                    Key k = v0.chunkKey(i);
                    if (!k.home()) continue;
                    DKV.put(k, new CStrChunk(s, v0.chunkLen(i)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public Vec[] makeZeros(int n) {
        return this.makeZeros(n, null, null);
    }

    public Vec[] makeOnes(int n) {
        return this.makeOnes(n, null, null);
    }

    public Vec[] makeVolatileDoubles(int n) {
        Vec[] vecs;
        for (Vec v : vecs = this.makeZeros(n)) {
            v._volatile = true;
            DKV.put(v);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int len = cs[0].len();
                for (int i = 0; i < cs.length; ++i) {
                    cs[i].setVolatile(MemoryManager.malloc8d(len));
                }
            }
        }.doAll(vecs);
        return vecs;
    }

    public Vec[] makeVolatileInts(final int[] cons) {
        Vec[] vecs;
        for (Vec v : vecs = this.makeZeros(cons.length)) {
            v._volatile = true;
            DKV.put(v);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int len = cs[0].len();
                for (int i = 0; i < cs.length; ++i) {
                    int[] vals = MemoryManager.malloc4(len);
                    Arrays.fill(vals, cons[i]);
                    cs[i].setVolatile(vals);
                }
            }
        }.doAll(vecs);
        return vecs;
    }

    public Vec[] makeZeros(int n, String[][] domain, byte[] types) {
        return this.makeCons(n, 0L, domain, types);
    }

    public Vec[] makeOnes(int n, String[][] domain, byte[] types) {
        return this.makeCons(n, 1L, domain, types);
    }

    public Vec[] makeCons(int n, final long l, String[][] domains, byte[] types) {
        final int nchunks = this.nChunks();
        Key<Vec>[] keys = this.group().addVecs(n);
        final Vec[] vs = new Vec[keys.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = new Vec(keys[i], this._rowLayout, domains == null ? null : domains[i], types == null ? (byte)3 : types[i]);
        }
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (Vec v1 : vs) {
                    for (int i = 0; i < nchunks; ++i) {
                        Key k = v1.chunkKey(i);
                        if (!k.home()) continue;
                        DKV.put(k, new C0LChunk(l, Vec.this.chunkLen(i)), this._fs);
                    }
                }
                for (Vec v : vs) {
                    if (!v._key.home()) continue;
                    DKV.put(v._key, v, this._fs);
                }
            }
        }.doAllNodes();
        return vs;
    }

    public static Vec makeCon(Key<Vec> k, double ... rows) {
        k = k == null ? VectorGroup.VG_LEN1.addVec() : k;
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 3);
        NewChunk chunk = new NewChunk(avec, 0);
        for (double r : rows) {
            chunk.addNum(r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec makeSeq(long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)(r + 1) + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min, long len) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)r + min + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min, long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)r + min + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeRepSeq(long len, final long repeat) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, ((long)r + c._start) % repeat);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public Vec makeRand(final long seed) {
        Vec randVec = this.makeZero();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                RandomUtils.PCGRNG rng = new RandomUtils.PCGRNG(c._start, 1L);
                for (int i = 0; i < c._len; ++i) {
                    ((Random)rng).setSeed(seed + c._start + (long)i);
                    c.set(i, rng.nextFloat());
                }
            }
        }.doAll(randVec);
        return randVec;
    }

    public double min() {
        return this.mins()[0];
    }

    public double[] mins() {
        return this.rollupStats()._mins;
    }

    public double max() {
        return this.maxs()[0];
    }

    public double[] maxs() {
        return this.rollupStats()._maxs;
    }

    public final boolean isConst() {
        return this.min() == this.max();
    }

    public final boolean isConst(boolean includeNAs) {
        if (!this.isConst()) {
            return false;
        }
        return !includeNAs || this.naCnt() == 0L;
    }

    public final boolean isBad() {
        return this.naCnt() == this.length();
    }

    public double mean() {
        return this.rollupStats()._mean;
    }

    public double sigma() {
        return this.rollupStats()._sigma;
    }

    public int mode() {
        if (!this.isCategorical()) {
            throw H2O.unimpl();
        }
        long[] bins = this.bins();
        return ArrayUtils.maxIndex(bins);
    }

    public long naCnt() {
        return this.rollupStats()._naCnt;
    }

    public long nzCnt() {
        return this.rollupStats()._nzCnt;
    }

    public long pinfs() {
        return this.rollupStats()._pinfs;
    }

    public long ninfs() {
        return this.rollupStats()._ninfs;
    }

    public boolean isInt() {
        return this.rollupStats()._isInt;
    }

    public long byteSize() {
        return this.rollupStats()._size;
    }

    public long[] bins() {
        return RollupStats.get((Vec)this, (boolean)true)._bins;
    }

    public long[] lazy_bins() {
        return this.rollupStats()._bins;
    }

    public double base() {
        return RollupStats.get(this, true).h_base();
    }

    public double stride() {
        return RollupStats.get(this, true).h_stride();
    }

    public double[] pctiles() {
        return RollupStats.get((Vec)this, (boolean)true)._pctiles;
    }

    private RollupStats rollupStats() {
        return RollupStats.get(this);
    }

    public void startRollupStats(Futures fs) {
        this.startRollupStats(fs, false);
    }

    public void startRollupStats(Futures fs, boolean doHisto) {
        RollupStats.start(this, fs, doHisto);
    }

    @Override
    protected long checksum_impl() {
        return this.rollupStats()._checksum;
    }

    public boolean isVolatile() {
        return this._volatile;
    }

    public void preWriting() {
        if (!this.writable()) {
            throw new IllegalArgumentException("Vector not writable");
        }
        Vec.setMutating(this.rollupStatsKey());
    }

    private static void setMutating(Key rskey) {
        RollupStats rs;
        Value val = DKV.get(rskey);
        if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
            return;
        }
        new SetMutating().invoke(rskey);
    }

    public Futures postWrite(Futures fs) {
        if (this.writable()) {
            RollupStats rs;
            Key rskey = this.rollupStatsKey();
            Value val = DKV.get(this.rollupStatsKey());
            if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
                DKV.remove(rskey, fs);
            }
        }
        return fs;
    }

    public int elem2ChunkIdx(long i) {
        if (0L > i || i >= this.length()) {
            throw new ArrayIndexOutOfBoundsException("0 <= " + i + " < " + this.length());
        }
        long[] espc = this.espc();
        int lo = 0;
        int hi = this.nChunks();
        while (lo < hi - 1) {
            int mid = hi + lo >>> 1;
            if (i < espc[mid]) {
                hi = mid;
                continue;
            }
            lo = mid;
        }
        while (espc[lo + 1] == i) {
            ++lo;
        }
        return lo;
    }

    public static Key getVecKey(Key chk_key) {
        assert (chk_key._kb[0] == 5);
        byte[] bits = (byte[])chk_key._kb.clone();
        bits[0] = 4;
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public Key chunkKey(int cidx) {
        return Vec.chunkKey(this._key, cidx);
    }

    public static Key chunkKey(Key veckey, int cidx) {
        byte[] bits = (byte[])veckey._kb.clone();
        bits[0] = 5;
        UnsafeUtils.set4(bits, 6, cidx);
        return Key.make(bits);
    }

    public Key rollupStatsKey() {
        if (this._rollupStatsKey == null) {
            this._rollupStatsKey = this.chunkKey(-2);
        }
        return this._rollupStatsKey;
    }

    Value chunkIdx(int cidx) {
        Value val = DKV.get(this.chunkKey(cidx));
        if (val == null) {
            boolean vecExists = DKV.get(this._key) != null;
            String vecInfo = (vecExists ? "is in DKV" : "is not in DKV") + "; home=" + this._key.home_node() + "; self=" + H2O.SELF;
            throw new IllegalStateException("Missing chunk " + cidx + " for vector " + this._key + "; Vec info: " + vecInfo);
        }
        return val;
    }

    Chunk nextChunk(Chunk prior) {
        int cidx = this.elem2ChunkIdx(prior._start) + 1;
        return cidx < this.nChunks() ? this.chunkForChunkIdx(cidx) : null;
    }

    public static Key<Vec> newKey() {
        return Vec.newKey(Key.make());
    }

    static Key<Vec> newKey(Key k) {
        byte[] kb = k._kb;
        byte[] bits = MemoryManager.malloc1(kb.length + 10);
        bits[0] = 4;
        bits[1] = -1;
        UnsafeUtils.set4(bits, 2, 0);
        UnsafeUtils.set4(bits, 6, -1);
        System.arraycopy(kb, 0, bits, 10, kb.length);
        return Key.make(bits);
    }

    private static Key espcKey(Key key) {
        byte[] bits = (byte[])key._kb.clone();
        bits[0] = 6;
        UnsafeUtils.set4(bits, 2, -1);
        UnsafeUtils.set4(bits, 6, -2);
        return Key.make(bits);
    }

    private Key groupKey() {
        byte[] bits = (byte[])this._key._kb.clone();
        bits[0] = 6;
        UnsafeUtils.set4(bits, 2, -1);
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public final VectorGroup group() {
        Key gKey = this.groupKey();
        Value v = DKV.get(gKey);
        return v == null ? new VectorGroup(gKey, 1) : (VectorGroup)v.get();
    }

    public Chunk chunkForChunkIdx(int cidx) {
        long start = this.chunk2StartElem(cidx);
        Value dvec = this.chunkIdx(cidx);
        Chunk c = (Chunk)dvec.get();
        long cstart = c._start;
        Vec v = c._vec;
        int tcidx = c._cidx;
        if (cstart == start && v == this && tcidx == cidx) {
            return c;
        }
        c._vec = this;
        c._start = start;
        c._cidx = cidx;
        return c;
    }

    public final Chunk chunkForRow(long i) {
        return this.chunkForChunkIdx(this.elem2ChunkIdx(i));
    }

    public final long at8(long i) {
        return this.chunkForRow(i).at8_abs(i);
    }

    public final double at(long i) {
        return this.chunkForRow(i).at_abs(i);
    }

    public final boolean isNA(long row) {
        return this.chunkForRow(row).isNA_abs(row);
    }

    public final long at16l(long i) {
        return this.chunkForRow(i).at16l_abs(i);
    }

    public final long at16h(long i) {
        return this.chunkForRow(i).at16h_abs(i);
    }

    public final BufferedString atStr(BufferedString bStr, long i) {
        if (this.isCategorical()) {
            if (this.isNA(i)) {
                return null;
            }
            return bStr.set(this._domain[(int)this.at8(i)]);
        }
        return this.chunkForRow(i).atStr_abs(bStr, i);
    }

    public String stringAt(long i) {
        return String.valueOf(this.atStr(new BufferedString(), i));
    }

    public final void set(long i, long l) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, l);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, double d) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, d);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, float f) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, f);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void setNA(long i) {
        Chunk ck = this.chunkForRow(i);
        ck.setNA_abs(i);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, String str) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, str);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, UUID uuid) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, uuid);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final Writer open() {
        return new Writer();
    }

    private Futures closeLocal(Futures fs) {
        int nc = this.nChunks();
        for (int i = 0; i < nc; ++i) {
            if (!H2O.containsKey(this.chunkKey(i))) continue;
            this.chunkForChunkIdx(i).close(i, fs);
        }
        return fs;
    }

    public String toString() {
        RollupStats rs = RollupStats.getOrNull(this, this.rollupStatsKey());
        String s = "[" + this.length() + (rs == null ? ", {" : "," + rs._mins[0] + "/" + rs._mean + "/" + rs._maxs[0] + ", " + PrettyPrint.bytes(rs._size) + ", {");
        int nc = this.nChunks();
        for (int i = 0; i < nc; ++i) {
            s = s + this.chunkKey(i).home_node() + ":" + this.chunk2StartElem(i) + ":";
        }
        return s + "}]";
    }

    public TwoDimTable toTwoDimTable(int off, int len) {
        return new Frame(this).toTwoDimTable(off, len);
    }

    public TwoDimTable toTwoDimTable() {
        int len = (int)Math.min(Integer.MAX_VALUE, this.length());
        return new Frame(this).toTwoDimTable(0L, len);
    }

    public Vec toCategoricalVec() {
        return VecUtils.toCategoricalVec(this);
    }

    public Vec toIntegerVec() {
        return VecUtils.toIntegerVec(this);
    }

    public void asDouble() {
        assert (this._type == 3);
        this.rollupStats()._isInt = false;
    }

    public Vec toStringVec() {
        return VecUtils.toStringVec(this);
    }

    public Vec toNumericVec() {
        return VecUtils.toNumericVec(this);
    }

    public boolean equals(Object o) {
        return o instanceof Vec && ((Vec)o)._key.equals(this._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    @Override
    public Futures remove_impl(Futures fs, boolean cascade) {
        Vec.bulk_remove(new Key[]{this._key}, this.nChunks());
        return fs;
    }

    @Override
    protected Futures remove_self_key_impl(Futures fs) {
        return fs;
    }

    static void bulk_remove(final Key[] keys, final int ncs) {
        Futures fs = new Futures();
        for (Key key : keys) {
            fs.add(new SetMutating().fork(Vec.chunkKey(key, -2)));
        }
        fs.blockForPending();
        new MRTask(){

            @Override
            public void setupLocal() {
                for (Key k : keys) {
                    if (k == null) continue;
                    Vec.bulk_remove_vec(k, ncs);
                }
            }
        }.doAllNodes();
        new MRTask(){

            @Override
            public void setupLocal() {
                for (Key k : keys) {
                    if (k == null) continue;
                    H2O.raw_remove(Vec.chunkKey(k, -2));
                }
            }
        }.doAllNodes();
    }

    private static void bulk_remove_vec(Key vkey, int ncs) {
        for (int i = 0; i < ncs; ++i) {
            Key kc = Vec.chunkKey(vkey, i);
            H2O.raw_remove(kc);
        }
        H2O.raw_remove(vkey);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        int ncs = this.nChunks();
        for (int i = 0; i < ncs; ++i) {
            Key ck = this.chunkKey(i);
            ab.put((Freezable)DKV.getGet(ck));
            if (ck.home()) continue;
            H2O.raw_remove(ck);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        int ncs = this.nChunks();
        for (int i = 0; i < ncs; ++i) {
            DKV.put(this.chunkKey(i), ab.get(Chunk.class), fs, true);
        }
        return super.readAll_impl(ab, fs);
    }

    public Vec align(Vec vec) {
        return new Frame(this).makeCompatible(new Frame(vec), true)[0];
    }

    public Vec adaptTo(String[] domain) {
        if (!this.isBad() && this.isNumeric() && !ArrayUtils.isInt(domain)) {
            int oldDomainLen = domain.length;
            int nan_cnt = 0;
            int j = 0;
            double[] double_domain = MemoryManager.malloc8d(domain.length);
            for (int i = 0; i < double_domain.length; ++i) {
                try {
                    double_domain[j] = Double.parseDouble(domain[i]);
                    ++j;
                    continue;
                }
                catch (NumberFormatException ex) {
                    ++nan_cnt;
                }
            }
            if (j == double_domain.length) {
                double[] new_double_domain;
                if (j < double_domain.length) {
                    double_domain = Arrays.copyOf(double_domain, j);
                }
                if ((new_double_domain = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(double_domain, 100000).doAll(this)).domain()).length > 0) {
                    int n = domain.length;
                    domain = Arrays.copyOf(domain, domain.length + new_double_domain.length);
                    for (int i = 0; i < new_double_domain.length; ++i) {
                        domain[n + i] = String.valueOf(new_double_domain[i]);
                    }
                }
                Vec res = this.makeZero(domain);
                double_domain = MemoryManager.malloc8d(domain.length - nan_cnt);
                j = 0;
                int[] indeces = MemoryManager.malloc4(domain.length - nan_cnt);
                int[] order_indeces = ArrayUtils.seq(0, indeces.length);
                for (int i = 0; i < domain.length; ++i) {
                    try {
                        double_domain[j] = Double.parseDouble(domain[i]);
                        indeces[j] = i;
                        ++j;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!ArrayUtils.isSorted(double_domain)) {
                    ArrayUtils.sort(order_indeces, double_domain);
                }
                final double[] sorted_domain_vals = ArrayUtils.select(double_domain, order_indeces);
                final int[] sorted_indeces = ArrayUtils.select(indeces, order_indeces);
                new MRTask(){

                    @Override
                    public void map(Chunk c0, Chunk c1) {
                        for (int i = 0; i < c0._len; ++i) {
                            double d = c0.atd(i);
                            if (Double.isNaN(d)) {
                                c1.setNA(i);
                                continue;
                            }
                            c1.set(i, sorted_indeces[Arrays.binarySearch(sorted_domain_vals, d)]);
                        }
                    }
                }.doAll(this, res);
                return res;
            }
        }
        return new CategoricalWrappedVec((Key)this.group().addVec(), this._rowLayout, domain, this._key);
    }

    public static Key setChunkIdx(Key k, int cidx) {
        UnsafeUtils.set4(k._kb, 6, cidx);
        return k;
    }

    public boolean isHomedLocally(int cidx) {
        return this.chunkKey(cidx).home();
    }

    public static class ESPC
    extends Keyed<ESPC> {
        private static NonBlockingHashMap<Key, ESPC> ESPCS = new NonBlockingHashMap();
        public final long[][] _espcs;

        private ESPC(Key key, long[][] espcs) {
            super(key);
            this._espcs = espcs;
        }

        private static ESPC getLocal(Key kespc) {
            ESPC local = ESPCS.get(kespc);
            if (local != null) {
                return local;
            }
            ESPCS.putIfAbsent(kespc, new ESPC(kespc, new long[0][]));
            return ESPCS.get(kespc);
        }

        private static ESPC getRemote(ESPC local, Key kespc) {
            ESPC remote = (ESPC)DKV.getGet(kespc);
            if (remote == null || remote == local) {
                return local;
            }
            long[][] local_espcs = local._espcs;
            long[][] remote_espcs = remote._espcs;
            while (true) {
                if (local_espcs.length >= remote_espcs.length) {
                    return local;
                }
                System.arraycopy(local._espcs, 0, remote._espcs, 0, local._espcs.length);
                ESPC res = ESPCS.putIfMatch(kespc, remote, local);
                if (res == local) {
                    return remote;
                }
                local = res;
                local_espcs = res._espcs;
                assert (remote_espcs == remote._espcs);
            }
        }

        public static long[] espc(Vec v) {
            int r = v._rowLayout;
            if (r == -1) {
                return null;
            }
            Key kespc = Vec.espcKey(v._key);
            ESPC local = ESPC.getLocal(kespc);
            if (r < local._espcs.length) {
                return local._espcs[r];
            }
            ESPC remote = ESPC.getRemote(local, kespc);
            if (r < remote._espcs.length) {
                return remote._espcs[r];
            }
            throw H2O.fail("Vec " + v._key + " asked for layout " + r + ", but only " + remote._espcs.length + " layouts defined");
        }

        private static int find_espc(long[] espc, long[][] espcs) {
            int i;
            for (i = 0; i < espcs.length; ++i) {
                if (espc != espcs[i]) continue;
                return i;
            }
            for (i = 0; i < espcs.length; ++i) {
                if (espc.length != espcs[i].length || !Arrays.equals(espc, espcs[i])) continue;
                return i;
            }
            return -1;
        }

        public static int rowLayout(Key key, final long[] espc) {
            Key kespc = Vec.espcKey(key);
            ESPC local = ESPC.getLocal(kespc);
            int idx = ESPC.find_espc(espc, local._espcs);
            if (idx != -1) {
                return idx;
            }
            if (!H2O.containsKey(kespc)) {
                local = ESPC.getRemote(local, kespc);
                idx = ESPC.find_espc(espc, local._espcs);
                if (idx != -1) {
                    return idx;
                }
            }
            new TAtomic<ESPC>(){

                @Override
                public ESPC atomic(ESPC old) {
                    if (old == null) {
                        return new ESPC(this._key, new long[][]{espc});
                    }
                    long[][] espcs = old._espcs;
                    int idx = ESPC.find_espc(espc, espcs);
                    if (idx != -1) {
                        return null;
                    }
                    int len = espcs.length;
                    espcs = (long[][])Arrays.copyOf(espcs, len + 1);
                    espcs[len] = espc;
                    return new ESPC(this._key, espcs);
                }
            }.invoke(kespc);
            ESPC reloaded = ESPC.getRemote(local, kespc);
            idx = ESPC.find_espc(espc, reloaded._espcs);
            assert (idx != -1);
            return idx;
        }

        public static void clear() {
            ESPCS.clear();
        }

        @Override
        protected long checksum_impl() {
            throw H2O.fail();
        }
    }

    public static class VectorGroup
    extends Keyed<VectorGroup> {
        public static final VectorGroup VG_LEN1 = new VectorGroup();
        final int _len;

        public VectorGroup() {
            super(VectorGroup.init_key());
            this._len = 0;
        }

        private static Key init_key() {
            byte[] bits = new byte[26];
            bits[0] = 6;
            bits[1] = -1;
            UnsafeUtils.set4(bits, 2, -1);
            UnsafeUtils.set4(bits, 6, -1);
            UUID uu = UUID.randomUUID();
            UnsafeUtils.set8(bits, 10, uu.getLeastSignificantBits());
            UnsafeUtils.set8(bits, 18, uu.getMostSignificantBits());
            return Key.make(bits);
        }

        private VectorGroup(Key key, int newlen) {
            super(key);
            this._len = newlen;
        }

        public Key<Vec> vecKey(int vecId) {
            byte[] bits = (byte[])this._key._kb.clone();
            bits[0] = 4;
            UnsafeUtils.set4(bits, 2, vecId);
            return Key.make(bits);
        }

        public int reserveKeys(int n) {
            AddVecs2GroupTsk tsk = new AddVecs2GroupTsk(this._key, n);
            tsk.invoke(this._key);
            return tsk._offset;
        }

        public Key<Vec>[] addVecs(int n) {
            int nn = this.reserveKeys(n);
            Key[] res = new Key[n];
            for (int i = 0; i < n; ++i) {
                res[i] = this.vecKey(i + nn);
            }
            return res;
        }

        public Key<Vec> addVec() {
            return this.addVecs(1)[0];
        }

        static boolean sameGroup(Vec v1, Vec v2) {
            byte[] bits1 = v1._key._kb;
            byte[] bits2 = v2._key._kb;
            if (bits1.length != bits2.length) {
                return false;
            }
            int res = 0;
            for (int i = 10; i < bits1.length; ++i) {
                res |= bits1[i] ^ bits2[i];
            }
            return res == 0;
        }

        public String toString() {
            return "VecGrp " + this._key.toString() + ", next free=" + this._len;
        }

        public int len() {
            return this._len;
        }

        public boolean equals(Object o) {
            return o instanceof VectorGroup && ((VectorGroup)o)._key.equals(this._key);
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        @Override
        protected long checksum_impl() {
            throw H2O.fail();
        }

        @Override
        protected Futures remove_impl(Futures fs, boolean cascade) {
            throw H2O.fail();
        }

        @Override
        protected AutoBuffer writeAll_impl(AutoBuffer ab) {
            throw H2O.fail();
        }

        @Override
        protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
            throw H2O.unimpl();
        }

        private static final class AddVecs2GroupTsk
        extends TAtomic<VectorGroup> {
            final Key _key;
            final int _n;
            int _offset;

            private AddVecs2GroupTsk(Key key, int n) {
                this._key = key;
                this._n = n;
            }

            @Override
            protected VectorGroup atomic(VectorGroup old) {
                this._offset = old == null ? 1 : old._len;
                return new VectorGroup(this._key, this._offset + this._n);
            }
        }
    }

    public final class Writer
    implements Closeable {
        private Chunk _cache;

        private Chunk chk(long i) {
            Chunk c = this._cache;
            return c != null && c.chk2() == null && c._start <= i && i < c._start + (long)c._len ? c : (this._cache = Vec.this.chunkForRow(i));
        }

        private Writer() {
            Vec.this.preWriting();
        }

        public final void set(long i, long l) {
            this.chk(i).set_abs(i, l);
        }

        public final void set(long i, double d) {
            this.chk(i).set_abs(i, d);
        }

        public final void set(long i, float f) {
            this.chk(i).set_abs(i, f);
        }

        public final void setNA(long i) {
            this.chk(i).setNA_abs(i);
        }

        public final void set(long i, String str) {
            this.chk(i).set_abs(i, str);
        }

        public Futures close(Futures fs) {
            return Vec.this.postWrite(Vec.this.closeLocal(fs));
        }

        @Override
        public void close() {
            this.close(new Futures()).blockForPending();
        }
    }

    public final class Reader {
        private Chunk _cache;

        private Chunk chk(long i) {
            Chunk c = this._cache;
            return c != null && c.chk2() == null && c._start <= i && i < c._start + (long)c._len ? c : (this._cache = Vec.this.chunkForRow(i));
        }

        public final long at8(long i) {
            return this.chk(i).at8_abs(i);
        }

        public final double at(long i) {
            return this.chk(i).at_abs(i);
        }

        public final boolean isNA(long i) {
            return this.chk(i).isNA_abs(i);
        }

        public final BufferedString atStr(BufferedString sb, long i) {
            return this.chk(i).atStr_abs(sb, i);
        }

        public final long length() {
            return Vec.this.length();
        }
    }

    private static class SetMutating
    extends TAtomic<RollupStats> {
        private SetMutating() {
        }

        @Override
        protected RollupStats atomic(RollupStats rs) {
            return rs != null && rs.isMutating() ? null : RollupStats.makeMutating();
        }
    }

    public static interface Holder {
        public Vec vec();
    }
}

