/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.math.NumberUtils;
import water.Key;
import water.parser.BufferedString;
import water.parser.CharSkippingBufferedString;
import water.parser.DefaultParserProviders;
import water.parser.FVecParseWriter;
import water.parser.ParseDataset;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.PreviewParseWriter;
import water.util.ArrayUtils;
import water.util.StringUtils;

public class CsvParser
extends Parser {
    private static final byte GUESS_SEP = -1;
    private static final int NO_HEADER = -1;
    private static final int GUESS_HEADER = 0;
    private static final int HAS_HEADER = 1;
    private static final byte[] NON_DATA_LINE_MARKERS_DEFAULT = new byte[]{35};
    private final byte[] _nonDataLineMarkers;
    public static final byte HIVE_SEP = 1;
    private static byte[] separators = new byte[]{1, 44, 59, 124, 9, 32};

    CsvParser(ParseSetup ps, Key jobKey) {
        this(ps, NON_DATA_LINE_MARKERS_DEFAULT, jobKey);
    }

    CsvParser(ParseSetup ps, byte[] defaultNonDataLineMarkers, Key jobKey) {
        super(ps, jobKey);
        this._nonDataLineMarkers = ps._nonDataLineMarkers != null ? ps._nonDataLineMarkers : defaultNonDataLineMarkers;
    }

    @Override
    public ParseWriter parseChunk(int cidx, ParseReader din, ParseWriter dout) {
        int state;
        CharSkippingBufferedString str = new CharSkippingBufferedString();
        byte[] bits = din.getChunkData(cidx);
        if (bits == null) {
            return dout;
        }
        int offset = din.getChunkDataStart(cidx);
        byte[] bits0 = bits;
        boolean firstChunk = true;
        byte[] bits1 = null;
        boolean isNa = false;
        boolean isAllASCII = true;
        if (offset >= 0) {
            state = 16;
        } else {
            offset = 0;
            state = this._setup._check_header == 1 || cidx > 0 ? 0 : 19;
        }
        byte quoteChar = this._setup._single_quotes ? (byte)39 : 34;
        byte quotes = 0;
        int quoteCount = 0;
        long number = 0L;
        boolean escaped = false;
        int exp = 0;
        int sgnExp = 1;
        boolean decimal = false;
        int fractionDigits = 0;
        int tokenStart = 0;
        int parsedColumnCounter = 0;
        int colIdx = 0;
        byte c = bits[offset];
        if (cidx == 0) {
            while (ArrayUtils.contains(this._nonDataLineMarkers, c) || CsvParser.isEOL(c)) {
                while (offset < bits.length && bits[offset] != 13 && bits[offset] != 10) {
                    ++offset;
                }
                if (offset + 1 < bits.length && bits[offset] == 13 && bits[offset + 1] == 10) {
                    ++offset;
                }
                if (++offset >= bits.length) {
                    return dout;
                }
                c = bits[offset];
            }
        }
        dout.newLine();
        boolean forceable = dout instanceof FVecParseWriter && ((FVecParseWriter)dout)._ctypes != null && this._setup._column_types != null;
        int colIndexNum = this._keepColumns.length - 1;
        if (this._setup._parse_columns_indices == null) {
            this._setup.setParseColumnIndices(this._setup.getNumberColumns(), this._setup.getSkippedColumns());
        }
        int parseIndexNum = this._setup._parse_columns_indices.length - 1;
        block25: while (true) {
            boolean forcedCategorical = forceable && colIdx < this._setup._column_types.length && this._setup._column_types[this._setup._parse_columns_indices[parsedColumnCounter]] == 4;
            boolean forcedString = forceable && colIdx < this._setup._column_types.length && this._setup._column_types[this._setup._parse_columns_indices[parsedColumnCounter]] == 2;
            switch (state) {
                case 0: {
                    if (!CsvParser.isEOL(c)) break;
                    state = 2;
                    continue block25;
                }
                case 1: {
                    state = 19;
                    if (c != 10) continue block25;
                    break;
                }
                case 36: {
                    if (c == quotes) {
                        quoteCount = (byte)(quoteCount - 1);
                        str.skipIndex(offset);
                        state = 13;
                        break;
                    }
                    if (quoteCount > 1) {
                        state = 17;
                        str.removeChar();
                        quoteCount = 0;
                        continue block25;
                    }
                    state = 13;
                }
                case 13: {
                    if (c == quotes && !escaped) {
                        state = 14;
                        continue block25;
                    }
                    if (!CsvParser.isEOL(c) && c != this.CHAR_SEPARATOR || quoteCount == 1) {
                        if (str.getBuffer() == null && CsvParser.isEOL(c)) {
                            str.set(bits, offset, 0);
                        }
                        boolean bl = escaped = !escaped && c == this.CHAR_ESCAPE;
                        if (escaped) {
                            str.skipIndex(offset);
                        } else {
                            str.addChar();
                        }
                        if ((c & 0x80) != 128) break;
                        isAllASCII = false;
                        break;
                    }
                }
                case 17: {
                    if (c != this.CHAR_SEPARATOR && c == 32) break;
                    if (str.isOverflown()) {
                        assert (str.getBuffer() != bits);
                        str.addBuff(bits);
                    }
                    if (!isNa && this._setup.isNA(parsedColumnCounter, str.toBufferedString())) {
                        isNa = true;
                    }
                    if (!isNa && colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                        dout.addStrCol(parsedColumnCounter, str.toBufferedString());
                        if (!isAllASCII) {
                            dout.setIsAllASCII(parsedColumnCounter, isAllASCII);
                        }
                    } else {
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                            dout.addInvalidCol(parsedColumnCounter);
                        }
                        isNa = false;
                    }
                    str.set(null, 0, 0);
                    quotes = 0;
                    isAllASCII = true;
                    if (colIdx <= colIndexNum && this._keepColumns[colIdx++] && parsedColumnCounter < parseIndexNum) {
                        ++parsedColumnCounter;
                    }
                    state = 15;
                }
                case 15: {
                    if (c == this.CHAR_SEPARATOR) {
                        state = 16;
                        break;
                    }
                    if (c == 32) break;
                }
                case 2: {
                    if (quoteCount == 1) {
                        state = 13;
                        continue block25;
                    }
                    if (quoteCount > 2) {
                        String err = "Unmatched quote char " + (char)quotes;
                        dout.invalidLine(new ParseWriter.ParseErr(err, cidx, dout.lineNum(), (long)offset + din.getGlobalByteOffset()));
                        parsedColumnCounter = 0;
                        colIdx = 0;
                        quotes = 0;
                    } else if (colIdx != 0) {
                        dout.newLine();
                        parsedColumnCounter = 0;
                        colIdx = 0;
                    }
                    int n = state = c == 13 ? 1 : 19;
                    if (firstChunk) break;
                    break block25;
                }
                case 20: {
                    if (c >= 48 && c <= 57 || c == 45 || c == 46 || c == 43) {
                        state = 3;
                        continue block25;
                    }
                    str.set(bits, offset - 1, 0);
                    str.addChar();
                    if (c == quotes) {
                        state = 14;
                        continue block25;
                    }
                    if (quotes != 0 || !CsvParser.isEOL(c) && c != this.CHAR_SEPARATOR) {
                        state = 13;
                        continue block25;
                    }
                    state = 17;
                    continue block25;
                }
                case 19: {
                    if (CsvParser.isEOL(c)) {
                        if (c != 13) break;
                        state = 1;
                        break;
                    }
                    if (ArrayUtils.contains(this._nonDataLineMarkers, c)) {
                        state = 0;
                        break;
                    }
                }
                case 16: {
                    if (c == 32 || c == 9 && 9 != this.CHAR_SEPARATOR) break;
                    if (c == this.CHAR_SEPARATOR) {
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                            dout.addInvalidCol(parsedColumnCounter);
                        }
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx++] && parsedColumnCounter < parseIndexNum) {
                            ++parsedColumnCounter;
                        }
                        state = 16;
                        break;
                    }
                    if (CsvParser.isEOL(c)) {
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                            dout.addInvalidCol(parsedColumnCounter);
                        }
                        state = 2;
                        continue block25;
                    }
                }
                case 4: {
                    state = 3;
                    if (this.CHAR_SEPARATOR != 1 && c == quoteChar) {
                        quotes = c;
                        quoteCount = (byte)(quoteCount + 1);
                        break;
                    }
                }
                case 3: {
                    if (dout.isString(parsedColumnCounter)) {
                        state = 13;
                        str.set(bits, offset, 0);
                        continue block25;
                    }
                    if (c >= 48 && c <= 57 || c == 45 || c == 46 || c == 43) {
                        state = 5;
                        number = 0L;
                        fractionDigits = 0;
                        decimal = false;
                        tokenStart = offset;
                        if (c == 45) {
                            exp = -1;
                            break;
                        }
                        if (c == 43) {
                            exp = 1;
                            break;
                        }
                        exp = 1;
                    } else {
                        if (c == 36) {
                            state = 20;
                            break;
                        }
                        state = 13;
                        str.set(bits, offset, 0);
                        continue block25;
                    }
                }
                case 5: {
                    if (c >= 48 && c <= 57) {
                        if (number >= 0xCCCCCCCCCCCCCCCL) {
                            state = 6;
                            break;
                        }
                        number = number * 10L + (long)(c - 48);
                        break;
                    }
                    if (c == 46) {
                        state = 8;
                        fractionDigits = offset;
                        decimal = true;
                        break;
                    }
                    if (c == 101 || c == 69) {
                        state = 11;
                        sgnExp = 1;
                        break;
                    }
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                }
                case 18: {
                    if (c == quotes) {
                        state = 12;
                        quotes = 0;
                        quoteCount = 0;
                        break;
                    }
                }
                case 12: {
                    if (forcedString || forcedCategorical) {
                        state = 13;
                        offset = tokenStart - 1;
                        str.set(bits, tokenStart, 0);
                        break;
                    }
                    if (c == this.CHAR_SEPARATOR && quotes == 0) {
                        exp -= fractionDigits;
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                            dout.addNumCol(parsedColumnCounter, number, exp);
                        }
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx++] && parsedColumnCounter < parseIndexNum) {
                            ++parsedColumnCounter;
                        }
                        state = 16;
                        break;
                    }
                    if (CsvParser.isEOL(c)) {
                        exp -= fractionDigits;
                        if (colIdx <= colIndexNum && this._keepColumns[colIdx]) {
                            dout.addNumCol(parsedColumnCounter, number, exp);
                        }
                        parsedColumnCounter = 0;
                        colIdx = 0;
                        dout.newLine();
                        int n = state = c == 13 ? 1 : 19;
                        if (firstChunk) break;
                        break block25;
                    }
                    if (c == 37) {
                        state = 12;
                        exp -= 2;
                        break;
                    }
                    if (c != this.CHAR_SEPARATOR && (c == 32 || c == 9)) {
                        state = 12;
                        break;
                    }
                    state = 13;
                    offset = tokenStart - 1;
                    str.set(bits, tokenStart, 0);
                    break;
                }
                case 6: {
                    if (c >= 48 && c <= 57) {
                        ++exp;
                        break;
                    }
                    if (c == 46) {
                        state = 7;
                        break;
                    }
                    if (c == 101 || c == 69) {
                        state = 11;
                        sgnExp = 1;
                        break;
                    }
                    state = 18;
                    continue block25;
                }
                case 7: {
                    if (c >= 48 && c <= 57) break;
                    if (c == 101 || c == 69) {
                        state = 11;
                        sgnExp = 1;
                        break;
                    }
                    state = 18;
                    continue block25;
                }
                case 8: {
                    if (c >= 48 && c <= 57) {
                        if (number >= 0xCCCCCCCCCCCCCCCL) {
                            if (decimal) {
                                fractionDigits = offset - 1 - fractionDigits;
                            }
                            if (exp == -1) {
                                number = -number;
                            }
                            exp = 0;
                            state = 7;
                            break;
                        }
                        number = number * 10L + (long)(c - 48);
                        break;
                    }
                    if (c == 101 || c == 69) {
                        if (decimal) {
                            fractionDigits = offset - 1 - fractionDigits;
                        }
                        state = 11;
                        sgnExp = 1;
                        break;
                    }
                    state = 18;
                    if (decimal) {
                        fractionDigits = offset - fractionDigits - 1;
                    }
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                    continue block25;
                }
                case 11: {
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                    if (c == 45) {
                        sgnExp *= -1;
                        break;
                    }
                    if (c == 43) break;
                    if (c < 48 || c > 57) {
                        state = 13;
                        offset = tokenStart - 1;
                        str.set(bits, tokenStart, 0);
                        break;
                    }
                    state = 9;
                }
                case 9: {
                    if (c >= 48 && c <= 57) {
                        exp = exp * 10 + (c - 48);
                        break;
                    }
                    exp *= sgnExp;
                    state = 18;
                    continue block25;
                }
                case 14: {
                    if (c == quotes) {
                        str.addChar();
                        quoteCount = (byte)(quoteCount + 1);
                        state = 36;
                        break;
                    }
                }
                default: {
                    assert (false) : " We have wrong state " + state;
                    break;
                }
            }
            if (++offset < 0) {
                assert (!firstChunk);
                firstChunk = true;
                bits = bits0;
                str.set(bits, offset += bits.length, 0);
            } else if (offset >= bits.length) {
                if (firstChunk && bits1 == null) {
                    bits1 = din.getChunkData(cidx + 1);
                }
                if (!firstChunk || bits1 == null) {
                    if (state == 1 || state == 19) break;
                    c = 10;
                    if (state != 13) continue;
                    quoteCount = 0;
                    state = 17;
                    continue;
                }
                firstChunk = false;
                if (state == 8) {
                    fractionDigits -= bits.length;
                }
                offset -= bits.length;
                tokenStart -= bits.length;
                bits = bits1;
                if (bits[0] == 10 && state == 1) break;
            }
            c = bits[offset];
        }
        if (colIdx == 0) {
            dout.rollbackLine();
        }
        if (offset + 1 < bits.length) {
            if (state == 1 && bits[offset + 1] == 10) {
                ++offset;
            }
            if (offset + 1 < bits.length) {
                din.setChunkDataStart(cidx + 1, offset + 1);
            }
        }
        return dout;
    }

    @Override
    protected int fileHasHeader(byte[] bits, ParseSetup ps) {
        boolean hasHdr = true;
        String[] lines = CsvParser.getFirstLines(bits, ps._single_quotes, this._nonDataLineMarkers);
        if (lines != null && lines.length > 0) {
            String[] firstLine = CsvParser.determineTokens(lines[0], this._setup._separator, this._setup._single_quotes, this._setup._escapechar);
            if (this._setup._column_names != null) {
                for (int i = 0; hasHdr && i < firstLine.length; ++i) {
                    hasHdr = this._setup._column_names[i] == firstLine[i] || this._setup._column_names[i] != null && this._setup._column_names[i].equalsIgnoreCase(firstLine[i]);
                }
            } else {
                this._setup._column_names = firstLine;
            }
        }
        return hasHdr ? 1 : -1;
    }

    private static int[] determineSeparatorCounts(String from, byte quoteChar, byte escapechar) {
        int[] result = new int[separators.length];
        byte[] bits = StringUtils.bytesOf(from);
        boolean inQuote = false;
        boolean escaping = false;
        for (int bi = 0; bi < bits.length; ++bi) {
            byte c = bits[bi];
            boolean escaped = escaping;
            boolean bl = escaping = !escaped && (c == escapechar || inQuote && c == quoteChar && bi < bits.length - 1 && bits[bi + 1] == quoteChar);
            if (c == quoteChar && !escaped && !escaping) {
                inQuote ^= true;
            }
            if (inQuote && c != 1) continue;
            for (int i = 0; i < separators.length; ++i) {
                if (c != separators[i]) continue;
                int n = i;
                result[n] = result[n] + 1;
            }
        }
        return result;
    }

    public static String[] determineTokens(String from, byte separator, boolean singleQuotes, byte escapechar) {
        byte singleQuote = singleQuotes ? (byte)39 : 34;
        return CsvParser.determineTokens(from, separator, singleQuote, escapechar);
    }

    public static String[] determineTokens(String from, byte separator, byte quoteChar, byte escapechar) {
        ArrayList<String> tokens = new ArrayList<String>();
        byte[] bits = StringUtils.bytesOf(from);
        byte quotes = 0;
        for (int offset = 0; offset < bits.length; ++offset) {
            while (offset < bits.length && bits[offset] == 32) {
                ++offset;
            }
            if (offset == bits.length) break;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte c = bits[offset];
            boolean escaping = false;
            if (c == quoteChar) {
                quotes = c;
                ++offset;
            }
            while (offset < bits.length) {
                c = bits[offset];
                boolean escaped = escaping;
                boolean bl = escaping = !escaped && (c == escapechar || quotes > 0 && c == quoteChar && offset < bits.length - 1 && bits[offset + 1] == quoteChar);
                if (c == quotes && !escaped && !escaping) {
                    if (++offset < bits.length && bits[offset] == c) {
                        byteArrayOutputStream.write(c);
                        ++offset;
                        continue;
                    }
                    quotes = 0;
                    continue;
                }
                if (quotes == 0 && (c == separator || CsvParser.isEOL(c))) break;
                byteArrayOutputStream.write(c);
                ++offset;
            }
            c = offset == bits.length ? (byte)10 : bits[offset];
            tokens.add(byteArrayOutputStream.toString());
            if (CsvParser.isEOL(c) || offset == bits.length) break;
            if (c == separator) continue;
            return new String[0];
        }
        if (bits.length > 0 && bits[bits.length - 1] == separator && bits[bits.length - 1] != 32) {
            tokens.add("");
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static byte guessSeparator(String l1, String l2, boolean singleQuotes, byte escapechar) {
        byte quoteChar = singleQuotes ? (byte)39 : 34;
        int[] s1 = CsvParser.determineSeparatorCounts(l1, quoteChar, escapechar);
        int[] s2 = CsvParser.determineSeparatorCounts(l2, quoteChar, escapechar);
        int max = 0;
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == 0) continue;
            if (s1[max] < s1[i]) {
                max = i;
            }
            if (s1[i] != s2[i] || s1[i] < s1[max] >> 1) continue;
            try {
                String[] t1 = CsvParser.determineTokens(l1, separators[i], quoteChar, escapechar);
                String[] t2 = CsvParser.determineTokens(l2, separators[i], quoteChar, escapechar);
                if (t1.length != s1[i] + 1 || t2.length != s2[i] + 1) continue;
                return separators[i];
            }
            catch (Exception t1) {
                // empty catch block
            }
        }
        if (s1[max] == 0) {
            max = separators.length - 1;
        }
        if (s1[max] != 0) {
            String[] t1 = CsvParser.determineTokens(l1, separators[max], quoteChar, escapechar);
            String[] t2 = CsvParser.determineTokens(l2, separators[max], quoteChar, escapechar);
            if (t1.length == s1[max] + 1 && t2.length == s2[max] + 1) {
                return separators[max];
            }
        }
        return -1;
    }

    public static int guessNcols(String[] columnNames, String[][] data) {
        if (columnNames != null) {
            return columnNames.length;
        }
        int longest = 0;
        for (String[] s : data) {
            if (s.length <= longest) continue;
            longest = s.length;
        }
        if (longest == data[0].length) {
            return longest;
        }
        int[] lengths = new int[longest + 1];
        for (String[] s : data) {
            int n = s.length;
            lengths[n] = lengths[n] + 1;
        }
        int maxCnt = 0;
        for (int i = 0; i <= longest; ++i) {
            if (lengths[i] <= lengths[maxCnt]) continue;
            maxCnt = i;
        }
        return maxCnt;
    }

    static ParseSetup guessSetup(byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] naStrings, byte[] nonDataLineMarkers, byte escapechar) {
        Object labels;
        String[] lines;
        int lastNewline;
        if (nonDataLineMarkers == null) {
            nonDataLineMarkers = NON_DATA_LINE_MARKERS_DEFAULT;
        }
        for (lastNewline = bits.length - 1; lastNewline > 0 && !CsvParser.isEOL(bits[lastNewline]); --lastNewline) {
        }
        if (lastNewline > 0) {
            bits = Arrays.copyOf(bits, lastNewline + 1);
        }
        if ((lines = CsvParser.getFirstLines(bits, singleQuotes, nonDataLineMarkers)).length == 0) {
            throw new ParseDataset.H2OParseException("No data!");
        }
        String[][] data = new String[lines.length][];
        if (lines.length == 1) {
            if (sep == -1) {
                if (lines[0].split(",").length > 1) {
                    sep = (byte)44;
                } else if (lines[0].split(" ").length > 1) {
                    sep = (byte)32;
                } else {
                    data[0] = new String[]{lines[0]};
                    byte[] ctypes = new byte[1];
                    String[][] domains = new String[1][];
                    if (NumberUtils.isNumber(data[0][0])) {
                        ctypes[0] = 3;
                    } else {
                        BufferedString str = new BufferedString(data[0][0]);
                        if (ParseTime.isTime(str)) {
                            ctypes[0] = 5;
                        } else if (ParseUUID.isUUID(str)) {
                            ctypes[0] = 1;
                        } else {
                            ctypes[0] = 4;
                            domains[0] = new String[]{data[0][0]};
                        }
                    }
                    return new ParseSetup(DefaultParserProviders.CSV_INFO, -1, singleQuotes, checkHeader, 1, null, ctypes, domains, naStrings, data, new ParseWriter.ParseErr[0], 0x400000, nonDataLineMarkers, escapechar);
                }
            }
            data[0] = CsvParser.determineTokens(lines[0], sep, singleQuotes, escapechar);
            int n = ncols = ncols > 0 ? ncols : data[0].length;
            if (checkHeader == 0) {
                if (ParseSetup.allStrings(data[0]) && !data[0][0].isEmpty()) {
                    labels = data[0];
                    checkHeader = 1;
                } else {
                    labels = null;
                    checkHeader = -1;
                }
            } else {
                labels = checkHeader == 1 ? data[0] : null;
            }
        } else {
            int i;
            if (sep == -1) {
                sep = CsvParser.guessSeparator(lines[0], lines[1], singleQuotes, escapechar);
                if (sep == -1 && lines.length > 2 && (sep = CsvParser.guessSeparator(lines[1], lines[2], singleQuotes, escapechar)) == -1) {
                    sep = CsvParser.guessSeparator(lines[0], lines[2], singleQuotes, escapechar);
                }
                if (sep == -1) {
                    sep = (byte)32;
                }
            }
            for (i = 0; i < lines.length; ++i) {
                data[i] = CsvParser.determineTokens(lines[i], sep, singleQuotes, escapechar);
            }
            ncols = CsvParser.guessNcols(columnNames, data);
            if (checkHeader == 1 || checkHeader == 0 && ParseSetup.hasHeader(data[0], data[1])) {
                checkHeader = 1;
                labels = data[0];
            } else {
                checkHeader = -1;
                labels = columnNames;
            }
            if (columnNames != null && labels != null) {
                if (((String[])labels).length != columnNames.length) {
                    throw new ParseDataset.H2OParseException("Already have " + columnNames.length + " column labels, but found " + ((String[])labels).length + " in this file");
                }
                for (i = 0; i < ((String[])labels).length; ++i) {
                    if (labels[i].equalsIgnoreCase(columnNames[i])) continue;
                    throw new ParseDataset.H2OParseException("Column " + (i + 1) + " label '" + labels[i] + "' does not match '" + columnNames[i] + "'");
                }
                labels = columnNames;
            }
        }
        ParseSetup resSetup = new ParseSetup(DefaultParserProviders.CSV_INFO, sep, singleQuotes, checkHeader, ncols, (String[])labels, null, (String[][])null, naStrings, data, nonDataLineMarkers, escapechar);
        if (columnTypes == null || ncols != columnTypes.length) {
            int i;
            for (i = bits.length - 1; i > 0 && bits[i] != 10; --i) {
            }
            if (i > 0) {
                bits = Arrays.copyOf(bits, i);
            }
            CsvParser p = new CsvParser(resSetup, null);
            PreviewParseWriter dout = new PreviewParseWriter(resSetup._number_columns);
            try {
                p.parseChunk(0, new Parser.ByteAryData(bits, 0L), dout);
                resSetup._column_previews = dout;
                resSetup.addErrs(dout._errs);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            for (int i = 0; i < columnTypes.length; ++i) {
                if (columnTypes[i] != 0) continue;
                columnTypes[i] = 3;
            }
            resSetup._column_types = columnTypes;
            resSetup._na_strings = null;
        }
        return resSetup;
    }

    private static String[] getFirstLines(byte[] bits, boolean singleQuotes, byte[] nonDataLineMarkers) {
        String[] lines = new String[10];
        int nlines = 0;
        int offset = 0;
        boolean comment = false;
        while (offset < bits.length && nlines < lines.length) {
            String str;
            if (bits[offset] == 35) {
                comment = true;
            }
            int lineStart = offset;
            int quoteCount = 0;
            while (offset < bits.length) {
                if (!comment && (!singleQuotes && bits[offset] == 34 || singleQuotes && bits[offset] == 39)) {
                    ++quoteCount;
                }
                if (CsvParser.isEOL(bits[offset]) && quoteCount % 2 == 0) {
                    comment = false;
                    break;
                }
                ++offset;
            }
            int lineEnd = offset++;
            if (offset < bits.length && bits[offset] == 10) {
                ++offset;
            }
            if (ArrayUtils.contains(nonDataLineMarkers, bits[lineStart]) || lineEnd <= lineStart || (str = new String(bits, lineStart, lineEnd - lineStart).trim()).isEmpty()) continue;
            lines[nlines++] = str;
        }
        return Arrays.copyOf(lines, nlines);
    }
}

