/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import java.util.HashMap;
import water.H2O;
import water.rapids.ast.AstExec;
import water.rapids.ast.params.AstStr;
import water.rapids.transforms.H2OColOp;

public class H2OBinaryOp
extends H2OColOp {
    boolean _leftIsCol;
    boolean _riteIsCol;
    String _binCol;
    private static final HashMap<String, String> binaryOps = new HashMap();

    public boolean getIsLeftColumn() {
        return this._leftIsCol;
    }

    public boolean getIsRightColumn() {
        return this._riteIsCol;
    }

    @Override
    public String[] getOldNames() {
        String[] stringArray;
        if (this._binCol == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this._oldCol;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this._oldCol;
            stringArray = stringArray3;
            stringArray3[1] = this._binCol;
        }
        return stringArray;
    }

    public H2OBinaryOp(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
    }

    @Override
    protected void setupParamsImpl(int i, String[] args) {
        if (this._ast._asts[i + 1] instanceof AstExec) {
            if (!H2OBinaryOp.isBinaryOp(this._fun)) {
                throw H2O.unimpl("unimpl: " + this.lookup(this._fun));
            }
            if (args[i].equals("leftArg") || args[i].equals("ary_x")) {
                this._leftIsCol = true;
            } else if (args[i].equals("rightArg") || args[i].equals("ary_y")) {
                this._riteIsCol = true;
            }
            this._binCol = ((AstExec)this._ast._asts[i + 1])._asts[2].str();
            this._params.put(args[i], new AstStr(((AstExec)this._ast._asts[i + 1])._asts[2].str()));
        } else {
            super.setupParamsImpl(i, args);
        }
    }

    @Override
    protected String lookup(String op) {
        return binaryOps.get(op) == null ? op : binaryOps.get(op);
    }

    @Override
    protected boolean paramIsRow() {
        return this._leftIsCol || this._riteIsCol;
    }

    @Override
    protected String addRowParam() {
        return "      _params.put(\"" + (this._riteIsCol ? "rightArg" : "leftArg") + "\", new String[]{String.valueOf(row.get(\"" + this._binCol + "\"))}); // write over the previous value\n";
    }

    private static boolean isBinaryOp(String op) {
        return binaryOps.get(op) != null;
    }

    static {
        binaryOps.put("+", "plus");
        binaryOps.put("-", "minus");
        binaryOps.put("*", "multiply");
        binaryOps.put("/", "divide");
        binaryOps.put("<", "lessThan");
        binaryOps.put("<=", "lessThanEquals");
        binaryOps.put(">", "greaterThan");
        binaryOps.put(">=", "greaterThanEquals");
        binaryOps.put("==", "equals");
        binaryOps.put("!=", "notEquals");
        binaryOps.put("^", "pow");
        binaryOps.put("%", "mod");
        binaryOps.put("%%", "mod");
        binaryOps.put("&", "and");
        binaryOps.put("&&", "and");
        binaryOps.put("|", "or");
        binaryOps.put("||", "or");
        binaryOps.put("intDiv", "intDiv");
        binaryOps.put("strDistance", "strDistance");
    }
}

