/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import water.util.comparison.string.ExactComparator;
import water.util.comparison.string.StringComparator;
import water.util.comparison.string.StringUtils;

public class JaccardIndexComparator
implements StringComparator {
    private StringComparator subcomp = new ExactComparator();

    public void setComparator(StringComparator comp) {
        this.subcomp = comp;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String s1, String s2) {
        String[] t2;
        if (s1.equals(s2)) {
            return 1.0;
        }
        String[] t1 = StringUtils.split(s1);
        if (t1.length > (t2 = StringUtils.split(s2)).length) {
            String[] tmp = t2;
            t2 = t1;
            t1 = tmp;
        }
        double intersection = 0.0;
        double union = t1.length + t2.length;
        for (int ix1 = 0; ix1 < t1.length; ++ix1) {
            double highest = 0.0;
            for (int ix2 = 0; ix2 < t2.length; ++ix2) {
                highest = Math.max(highest, this.subcomp.compare(t1[ix1], t2[ix2]));
            }
            intersection += highest;
            union -= highest;
        }
        return intersection / union;
    }
}

