/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import water.util.comparison.string.StringComparator;

public class LongestCommonSubstring
implements StringComparator {
    private int minlen = 2;
    private Formula formula = Formula.OVERLAP;

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        if (Math.min(s1.length(), s2.length()) == 0) {
            return 0.0;
        }
        return (this.compare_(s1, s2) + this.compare_(s2, s1)) / 2.0;
    }

    private double compare_(String s1, String s2) {
        int shortlen = Math.min(s1.length(), s2.length());
        int longlen = Math.max(s1.length(), s2.length());
        int removed = 0;
        while (true) {
            int longest = 0;
            int longesti = 0;
            int longestj = 0;
            int[][] matrix = new int[s1.length()][s2.length()];
            for (int i = 0; i < s1.length(); ++i) {
                for (int j = 0; j < s2.length(); ++j) {
                    if (s1.charAt(i) == s2.charAt(j)) {
                        matrix[i][j] = i == 0 || j == 0 ? 1 : matrix[i - 1][j - 1] + 1;
                        if (matrix[i][j] <= longest) continue;
                        longest = matrix[i][j];
                        longesti = i;
                        longestj = j;
                        continue;
                    }
                    matrix[i][j] = 0;
                }
            }
            ++longesti;
            ++longestj;
            if (longest < this.minlen) break;
            s1 = s1.substring(0, longesti - longest) + s1.substring(longesti);
            s2 = s2.substring(0, longestj - longest) + s2.substring(longestj);
            removed += longest;
        }
        return this.formula.compute(removed, shortlen, longlen);
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public void setMinimumLength(int minlen) {
        this.minlen = minlen;
    }

    public int getMinimumLength() {
        return this.minlen;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public static enum Formula {
        OVERLAP{

            @Override
            public double compute(int removed, int shortlen, int longlen) {
                return (double)removed / (double)shortlen;
            }
        }
        ,
        DICE{

            @Override
            public double compute(int removed, int shortlen, int longlen) {
                return (double)(2 * removed) / (double)(shortlen + longlen);
            }
        }
        ,
        JACCARD{

            @Override
            public double compute(int removed, int shortlen, int longlen) {
                return (double)removed / (double)(shortlen + longlen - removed);
            }
        };


        public double compute(int removed, int shortlen, int longlen) {
            throw new IllegalStateException("Unknown formula: " + (Object)((Object)this));
        }
    }
}

