/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.lang.reflect.Method;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.api.Handler;
import water.api.HandlerFactory;
import water.api.RequestUri;
import water.api.Schema;
import water.util.MarkdownBuilder;

public final class Route
extends Iced {
    static final int MIN_VERSION = 1;
    public String _http_method;
    public String _url;
    public String _summary;
    public String _api_name;
    public Class<? extends Handler> _handler_class;
    public Method _handler_method;
    public String[] _path_params;
    public Handler _handler;
    private RequestUri _uri;
    final HandlerFactory _handler_factory;

    public Route() {
        this._handler_factory = null;
    }

    public Route(RequestUri uri, String api_name, String summary, Class<? extends Handler> handler_class, String handler_method, HandlerFactory handler_factory) {
        assert (uri != null && handler_class != null && handler_method != null);
        assert (handler_factory != null) : "handler_factory should not be null, caller has to pass it!";
        this._uri = uri;
        this._http_method = uri.getMethod();
        this._url = uri.getUrl();
        this._summary = summary;
        this._api_name = api_name;
        this._handler_class = handler_class;
        this._handler_method = Route.resolveMethod(handler_class, handler_method);
        this._path_params = uri.getParamsList();
        this._handler_factory = handler_factory;
        try {
            this._handler = this._handler_factory.create(this._handler_class);
        }
        catch (Exception ie) {
            throw H2O.fail("failed to register handler " + handler_class.getSimpleName() + "." + handler_method, ie);
        }
    }

    public RequestUri getUri() {
        return this._uri;
    }

    public int getVersion() {
        return this._uri.getVersion();
    }

    public StringBuffer markdown(Schema sinput, Schema soutput) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1(this._http_method, this._url);
        builder.hline();
        builder.paragraph(this._summary);
        builder.heading1("Input schema: ");
        builder.append(sinput.markdown(true, false));
        builder.heading1("Output schema: ");
        builder.append(soutput.markdown(false, true));
        return builder.stringBuffer();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route route = (Route)o;
        return this._api_name.equals(route._api_name) && this._handler_class.equals(route._handler_class) && this._handler_method.equals(route._handler_method) && this._http_method.equals(route._http_method) && this._url.equals(route._url) && Arrays.equals(this._path_params, route._path_params);
    }

    public int hashCode() {
        return this._api_name.hashCode();
    }

    public String toString() {
        return "Route{_http_method='" + this._http_method + '\'' + ", _url_pattern=" + this._url + ", _summary='" + this._summary + '\'' + ", _api_name='" + this._api_name + "'" + ", _handler_class=" + this._handler_class + ", _handler_method=" + this._handler_method + ", _input_schema=" + Handler.getHandlerMethodInputSchema(this._handler_method) + ", _output_schema=" + Handler.getHandlerMethodOutputSchema(this._handler_method) + ", _path_params=" + Arrays.toString(this._path_params) + '}';
    }

    private static Method resolveMethod(Class<? extends Handler> handler_class, String handler_method) {
        for (Method method : handler_class.getMethods()) {
            Class<?>[] pt;
            if (!method.getName().equals(handler_method) || (pt = method.getParameterTypes()) == null || pt.length != 2 || pt[0] != Integer.TYPE || !Schema.class.isAssignableFrom(pt[1])) continue;
            return method;
        }
        throw H2O.fail("Failed to find handler method: " + handler_method + " in class: " + handler_class.getSimpleName());
    }
}

