/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import water.parser.ParserInfo;
import water.parser.ParserProvider;

public final class ParserService {
    public static ParserService INSTANCE = new ParserService();
    private final ServiceLoader<ParserProvider> loader = ServiceLoader.load(ParserProvider.class);
    private static Comparator<ParserProvider> PARSER_PROVIDER_COMPARATOR = new Comparator<ParserProvider>(){

        @Override
        public int compare(ParserProvider o1, ParserProvider o2) {
            int x = o1.info().prior;
            int y = o2.info().prior;
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    };

    public List<ParserProvider> getAllProviders() {
        return this.getAllProviders(true);
    }

    public synchronized List<ParserProvider> getAllProviders(boolean sort) {
        ArrayList<ParserProvider> providers = new ArrayList<ParserProvider>();
        for (ParserProvider pp : this.loader) {
            providers.add(pp);
        }
        if (sort) {
            Collections.sort(providers, PARSER_PROVIDER_COMPARATOR);
        }
        return providers;
    }

    public synchronized String[] getAllProviderNames(boolean sort) {
        List<ParserProvider> providers = this.getAllProviders(sort);
        String[] names = new String[providers.size()];
        int i = 0;
        for (ParserProvider pp : providers) {
            names[i++] = pp.info().name();
        }
        return names;
    }

    public ParserProvider getByInfo(ParserInfo info) {
        return this.getByName(info.name());
    }

    public synchronized ParserProvider getByName(String name) {
        for (ParserProvider pp : this.loader) {
            if (!pp.info().name().equals(name)) continue;
            return pp;
        }
        return null;
    }
}

