/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.io.Closeable;
import java.util.ArrayList;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstFunction;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValFun;

public class Env
extends Iced {
    public final Session _ses;
    private ArrayList<Frame> _stk = new ArrayList();
    public AstFunction _scope;

    public Env(Session ses) {
        this._ses = ses;
    }

    public int sp() {
        return this._stk.size();
    }

    private Frame peek(int x) {
        return this._stk.get(this.sp() + x);
    }

    public StackHelp stk() {
        return new StackHelp();
    }

    public <V extends Val> V returning(V val) {
        if (val instanceof ValFrame) {
            this._ses.addRefCnt(val.getFrame(), 1);
        }
        return val;
    }

    public Val lookup(String id) {
        Val val;
        Val val2 = val = this._scope == null ? null : this._scope.lookup(id);
        if (val != null) {
            return val;
        }
        if (AstRoot.CONSTS.containsKey(id)) {
            return AstRoot.CONSTS.get(id).exec(this);
        }
        Value value = DKV.get(Key.make(id));
        if (value != null) {
            if (value.isFrame()) {
                return this.addGlobals((Frame)value.get());
            }
            throw new IllegalArgumentException("DKV name lookup of " + id + " yielded an instance of type " + value.className() + ", but only Frame is supported");
        }
        AstPrimitive ast = AstRoot.PRIMS.get(id);
        if (ast != null) {
            return new ValFun(ast);
        }
        throw new IllegalArgumentException("Name lookup of '" + id + "' failed");
    }

    ValFrame addGlobals(Frame fr) {
        this._ses.addGlobals(fr);
        return new ValFrame(new Frame((String[])fr._names.clone(), (Vec[])fr.vecs().clone()));
    }

    public String toString() {
        String s = "{";
        int sp = this.sp();
        for (int i = 0; i < sp; ++i) {
            s = s + this.peek(-sp + i).toString() + ",";
        }
        return s + "}";
    }

    public AutoBuffer write_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public Env read_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public class StackHelp
    implements Closeable {
        final int _sp;

        public StackHelp() {
            this._sp = Env.this.sp();
        }

        public Val track(Val v) {
            if (v instanceof ValFrame) {
                this.track(v.getFrame());
            }
            return v;
        }

        public Frame track(Frame fr) {
            Env.this._stk.add(Env.this.sp(), new Frame(fr._names, (Vec[])fr.vecs().clone()));
            return fr;
        }

        @Override
        public void close() {
            Futures fs = null;
            int sp = Env.this.sp();
            while (sp > this._sp) {
                Frame fr = (Frame)Env.this._stk.remove(--sp);
                fs = Env.this._ses.downRefCnt(fr, fs);
            }
            if (fs != null) {
                fs.blockForPending();
            }
        }

        public Val untrack(Val vfr) {
            if (!vfr.isFrame()) {
                return vfr;
            }
            Frame fr = vfr.getFrame();
            Env.this._ses.addRefCnt(fr, -1);
            return vfr;
        }
    }
}

