/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstFunction;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;

public class Rapids {
    private final String _str;
    private int _x;

    public static AstRoot parse(String rapids) {
        return new Rapids(rapids).parse();
    }

    public static Val exec(String rapids) {
        Session session = new Session();
        try {
            AstRoot ast = Rapids.parse(rapids);
            Val val = session.exec(ast, null);
            return session.end(val);
        }
        catch (Throwable ex) {
            throw session.endQuietly(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Val exec(String rapids, Session session) {
        AstRoot ast = Rapids.parse(rapids);
        Session session2 = session;
        synchronized (session2) {
            Val val = session.exec(ast, null);
            if (val.isFrame()) {
                Frame frame = val.getFrame();
                assert (frame._key != null);
                session.addRefCnt(frame, -1);
            }
            return val;
        }
    }

    public AstRoot parse() {
        switch (this.skipWS()) {
            case '(': {
                return new AstExec(this);
            }
            case '{': {
                return new AstFunction(this);
            }
            case '#': {
                ++this._x;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return new AstNum(this);
            }
            case '\"': {
                return new AstStr(this, '\"');
            }
            case '\'': {
                return new AstStr(this, '\'');
            }
            case '[': {
                return Rapids.isQuote(this.xpeek('[').skipWS()) ? new AstStrList(this) : new AstNumList(this);
            }
            case ' ': {
                throw new IllegalASTException("Expected an expression but ran out of text");
            }
            case '-': {
                return this.peek(1) >= '0' && this.peek(1) <= '9' ? new AstNum(this) : new AstId(this);
            }
        }
        return new AstId(this);
    }

    protected Rapids(String rapidsStr) {
        this._str = rapidsStr;
        this._x = 0;
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int offset) {
        return this._x + offset < this._str.length() ? this._str.charAt(this._x + offset) : (char)' ';
    }

    public Rapids xpeek(char c) {
        if (this.peek() != c) {
            throw new IllegalASTException("Expected '" + c + "'. Got: '" + this.peek() + "'.  unparsed: " + this.unparsed() + " ; _x = " + this._x);
        }
        ++this._x;
        return this;
    }

    public char skipWS() {
        char c = ' ';
        while (this._x < this._str.length() && Rapids.isWS(c = this.peek())) {
            ++this._x;
        }
        return c;
    }

    public String token() {
        char c;
        int start = this._x;
        while (!Rapids.isWS(c = this.peek()) && c != ')' && c != '}') {
            ++this._x;
        }
        if (start == this._x) {
            throw new IllegalArgumentException("Missing token");
        }
        return this._str.substring(start, this._x);
    }

    public double number() {
        char c;
        int start = this._x;
        while (!Rapids.isWS(c = this.peek()) && c != ')' && c != ']' && c != ',' && c != ':') {
            ++this._x;
        }
        return Double.valueOf(this._str.substring(start, this._x));
    }

    public String match(char c) {
        int start = ++this._x;
        while (this.peek() != c) {
            ++this._x;
        }
        ++this._x;
        return this._str.substring(start, this._x - 1);
    }

    String unparsed() {
        return this._str.substring(this._x, this._str.length());
    }

    static boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    public AstRoot throwErr(String msg) {
        int i;
        int idx = this._str.length() - 1;
        int lo = this._x;
        int hi = idx;
        if (idx < lo) {
            hi = lo = idx;
        }
        String s = msg + '\n' + this._str + '\n';
        for (i = 0; i < lo; ++i) {
            s = s + ' ';
        }
        s = s + '^';
        ++i;
        while (i < hi) {
            s = s + '-';
            ++i;
        }
        if (i <= hi) {
            s = s + '^';
        }
        s = s + '\n';
        throw new IllegalASTException(s);
    }

    public static class IllegalASTException
    extends IllegalArgumentException {
        public IllegalASTException(String s) {
            super(s);
        }
    }
}

