/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;

public class AstIsNa
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public String str() {
        return "is.na";
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val val = stk.track(asts[1].exec(env));
        switch (val.type()) {
            case 1: {
                return new ValNum(this.op(val.getNum()));
            }
            case 5: {
                Frame fr = val.getFrame();
                return new ValFrame(((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] cs, NewChunk[] ncs) {
                        for (int col = 0; col < cs.length; ++col) {
                            Chunk c = cs[col];
                            NewChunk nc = ncs[col];
                            for (int i = 0; i < c._len; ++i) {
                                nc.addNum(c.isNA(i) ? 1.0 : 0.0);
                            }
                        }
                    }
                }.doAll(fr.numCols(), (byte)3, fr)).outputFrame());
            }
            case 3: {
                return new ValNum(val.getStr() == null ? 1.0 : 0.0);
            }
        }
        throw H2O.unimpl("is.na unimpl: " + val.getClass());
    }

    double op(double d) {
        return Double.isNaN(d) ? 1.0 : 0.0;
    }
}

