/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.time;

import org.joda.time.MutableDateTime;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;

public class AstMktime
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"yr", "mo", "dy", "hr", "mi", "se", "ms"};
    }

    @Override
    public int nargs() {
        return 8;
    }

    @Override
    public String str() {
        return "mktime";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame[] fs = new Frame[this.nargs() - 1];
        int[] is = new int[this.nargs() - 1];
        Frame x = null;
        for (int i = 1; i < this.nargs(); ++i) {
            if (asts[i] instanceof AstId || asts[i] instanceof AstExec) {
                fs[i - 1] = x = stk.track(asts[i].exec(env)).getFrame();
                continue;
            }
            is[i - 1] = (int)asts[i].exec(env).getNum();
        }
        if (x == null) {
            long msec = new MutableDateTime(is[0], is[1] + 1, is[2] + 1, is[3], is[4], is[5], is[6]).getMillis();
            return new ValNum(msec);
        }
        Vec[] vecs = new Vec[7];
        for (int i = 0; i < 7; ++i) {
            if (fs[i] == null) {
                vecs[i] = x.anyVec().makeCon(is[i]);
                continue;
            }
            if (fs[i].numCols() != 1) {
                throw new IllegalArgumentException("Expect single column");
            }
            vecs[i] = fs[i].anyVec();
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                MutableDateTime dt = new MutableDateTime(0L);
                NewChunk n = nchks[0];
                int rlen = chks[0]._len;
                for (int r = 0; r < rlen; ++r) {
                    dt.setDateTime((int)chks[0].at8(r), (int)chks[1].at8(r) + 1, (int)chks[2].at8(r) + 1, (int)chks[3].at8(r), (int)chks[4].at8(r), (int)chks[5].at8(r), (int)chks[6].at8(r));
                    n.addNum(dt.getMillis());
                }
            }
        }.doAll(new byte[]{3}, vecs)).outputFrame(new String[]{"msec"}, null);
        for (int i = 0; i < this.nargs() - 1; ++i) {
            if (fs[i] != null) continue;
            vecs[i].remove();
        }
        return new ValFrame(fr2);
    }
}

