/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import java.util.HashMap;
import water.H2O;
import water.fvec.Frame;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstRoot;
import water.rapids.transforms.H2OColOp;

public class H2OBinaryOp
extends H2OColOp {
    boolean _leftIsCol;
    boolean _riteIsCol;
    String _binCol;
    private static final HashMap<String, String> binaryOps = new HashMap();

    public H2OBinaryOp(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
    }

    @Override
    protected void setupParamsImpl(int i, String[] args) {
        if (this._ast._asts[i + 1] instanceof AstExec) {
            if (!H2OBinaryOp.isBinaryOp(this._fun)) {
                throw H2O.unimpl("unimpl: " + this.lookup(this._fun));
            }
            this._leftIsCol = args[i].equals("leftArg");
            this._riteIsCol = !this._leftIsCol;
            this._binCol = ((AstExec)this._ast._asts[i + 1])._asts[2].str();
            this._params.put(args[i], AstRoot.newAstStr(((AstExec)this._ast._asts[i + 1])._asts[2].str()));
        } else {
            super.setupParamsImpl(i, args);
        }
    }

    @Override
    protected Frame transformImpl(Frame f) {
        if (this.paramIsRow()) {
            ((AstExec)this._ast._asts[2])._asts[1] = AstRoot.newAstFrame(f);
        }
        return super.transformImpl(f);
    }

    @Override
    protected String lookup(String op) {
        return binaryOps.get(op) == null ? op : binaryOps.get(op);
    }

    @Override
    protected boolean paramIsRow() {
        return this._leftIsCol || this._riteIsCol;
    }

    @Override
    protected String addRowParam() {
        return "      _params.put(\"" + (this._leftIsCol ? "leftArg" : "rightArg") + "\", " + "new String[]{String.valueOf(row.get(\"" + this._binCol + "\"))}); // write over the previous value\n";
    }

    private static boolean isBinaryOp(String op) {
        return binaryOps.get(op) != null;
    }

    static {
        binaryOps.put("+", "plus");
        binaryOps.put("-", "minus");
        binaryOps.put("*", "multiply");
        binaryOps.put("/", "divide");
        binaryOps.put("<", "lessThan");
        binaryOps.put("<=", "lessThanEquals");
        binaryOps.put(">", "greaterThan");
        binaryOps.put(">=", "greaterThanEquals");
        binaryOps.put("==", "equals");
        binaryOps.put("!=", "notEquals");
    }
}

