/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.nbhm.NonBlockingHashMap;

public class IcedHashMapGeneric<K, V>
extends Iced
implements Map<K, V>,
Cloneable,
Serializable {
    private volatile transient boolean _write_lock;
    transient NonBlockingHashMap<K, V> _map;

    public boolean isSupportedKeyType(Object K) {
        return K instanceof Freezable[] || K instanceof Freezable || K instanceof String;
    }

    public boolean isSupportedValType(Object V) {
        return V instanceof Freezable[] || V instanceof Freezable || V instanceof String || V instanceof Integer;
    }

    public IcedHashMapGeneric() {
        this.init();
    }

    protected Map<K, V> map() {
        return this._map;
    }

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map().get(key);
    }

    @Override
    public V put(K key, V val) {
        assert (!this._write_lock);
        if (!this.isSupportedKeyType(key)) {
            throw new IllegalArgumentException("given key type is not supported: " + key.getClass().getName());
        }
        if (!this.isSupportedValType(val)) {
            throw new IllegalArgumentException("given val type is not supported: " + val.getClass().getName());
        }
        return this.map().put(key, val);
    }

    @Override
    public V remove(Object key) {
        assert (!this._write_lock);
        return this.map().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        assert (!this._write_lock);
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        assert (!this._write_lock);
        this.map().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    private boolean isStringKey(int mode) {
        return mode % 2 == 1;
    }

    private boolean isStringVal(int mode) {
        return mode == 1 || mode == 2;
    }

    private boolean isFreezeVal(int mode) {
        return mode == 3 || mode == 4;
    }

    private boolean isFArrayVal(int mode) {
        return mode == 5 || mode == 6;
    }

    private boolean isIntegrVal(int mode) {
        return mode == 7 || mode == 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final AutoBuffer write_impl(AutoBuffer ab) {
        this._write_lock = true;
        try {
            for (Map.Entry<K, V> e : this.map().entrySet()) {
                K key = e.getKey();
                assert (key != null);
                V val = e.getValue();
                assert (val != null);
                int mode = 0;
                if (key instanceof String) {
                    if (val instanceof String) {
                        mode = 1;
                    } else if (val instanceof Freezable) {
                        mode = 3;
                    } else if (val instanceof Freezable[]) {
                        mode = 5;
                    } else {
                        if (!(val instanceof Integer)) throw new IllegalArgumentException("unsupported value class " + val.getClass().getName());
                        mode = 7;
                    }
                } else {
                    if (!(key instanceof Iced)) {
                        throw new IllegalArgumentException("key must be String or Freezable, got " + key.getClass().getName());
                    }
                    if (val instanceof String) {
                        mode = 2;
                    } else if (val instanceof Freezable) {
                        mode = 4;
                    } else if (val instanceof Freezable[]) {
                        mode = 6;
                    } else {
                        if (!(val instanceof Integer)) throw new IllegalArgumentException("unsupported value class " + val.getClass().getName());
                        mode = 8;
                    }
                }
                ab.put1(mode);
                if (this.isStringKey(mode)) {
                    ab.putStr((String)key);
                } else {
                    ab.put((Freezable)key);
                }
                if (this.isStringVal(mode)) {
                    ab.putStr((String)val);
                    continue;
                }
                if (this.isFreezeVal(mode)) {
                    ab.put((Freezable)val);
                    continue;
                }
                if (this.isFArrayVal(mode)) {
                    ab.put4(((Freezable[])val).length);
                    for (Freezable v : (Freezable[])val) {
                        ab.put(v);
                    }
                    continue;
                }
                if (!this.isIntegrVal(mode)) throw H2O.fail();
                ab.put4((Integer)val);
            }
            ab.put1(-1);
            return ab;
        }
        catch (Throwable t) {
            System.err.println("Iced hash map serialization failed! " + t.toString() + ", msg = " + t.getMessage());
            t.printStackTrace();
            throw H2O.fail("Iced hash map serialization failed!" + t.toString() + ", msg = " + t.getMessage());
        }
        finally {
            this._write_lock = false;
        }
    }

    protected Map<K, V> init() {
        this._map = new NonBlockingHashMap();
        return this._map;
    }

    public final IcedHashMapGeneric read_impl(AutoBuffer ab) {
        try {
            byte mode;
            assert (this.map() == null || this.map().isEmpty());
            Map<String, String> map = this.init();
            while ((mode = ab.get1()) != -1) {
                Freezable[] val;
                String key;
                String string = key = this.isStringKey(mode) ? ab.getStr() : ab.get();
                if (this.isStringVal(mode)) {
                    val = ab.getStr();
                } else if (this.isFreezeVal(mode)) {
                    val = ab.get();
                } else if (this.isFArrayVal(mode)) {
                    Freezable[] vals = new Freezable[ab.get4()];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = ab.get();
                    }
                    val = vals;
                } else if (this.isIntegrVal(mode)) {
                    val = new Integer(ab.get4());
                } else {
                    throw H2O.fail();
                }
                map.put(key, (String)val);
            }
            return this;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (null == t.getCause()) {
                throw H2O.fail("IcedHashMap deserialization failed! + " + t.toString() + ", msg = " + t.getMessage() + ", cause: null");
            }
            throw H2O.fail("IcedHashMap deserialization failed! + " + t.toString() + ", msg = " + t.getMessage() + ", cause: " + t.getCause().toString() + ", cause msg: " + t.getCause().getMessage() + ", cause stacktrace: " + Arrays.toString(t.getCause().getStackTrace()));
        }
    }

    public final IcedHashMapGeneric readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Map.Entry<K, V> entry : this.map().entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            assert (entry.getKey() instanceof String);
            assert (value instanceof String || value instanceof String[] || value instanceof Integer || value instanceof Freezable || value instanceof Freezable[]);
            if (first) {
                first = false;
            } else {
                ab.put1(44).put1(32);
            }
            ab.putJSONName((String)key);
            ab.put1(58);
            if (value instanceof String) {
                ab.putJSONName((String)value);
                continue;
            }
            if (value instanceof String[]) {
                ab.putJSONAStr((String[])value);
                continue;
            }
            if (value instanceof Integer) {
                ab.putJSON4((Integer)value);
                continue;
            }
            if (value instanceof Freezable) {
                ab.putJSON((Freezable)value);
                continue;
            }
            if (!(value instanceof Freezable[])) continue;
            ab.putJSONA((Freezable[])value);
        }
        return ab;
    }

    public static class IcedHashMapStringObject
    extends IcedHashMapGeneric<String, Object> {
    }

    public static class IcedHashMapStringString
    extends IcedHashMapGeneric<String, String> {
    }
}

