/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import water.util.Log;

public abstract class RIStream
extends InputStream {
    InputStream _is;
    ProgressMonitor _pmon;
    public final int _retries = 5;
    String[] _bk;
    private long _off;
    boolean _knownSize;
    long _expectedSz;

    protected RIStream(long off, ProgressMonitor pmon) {
        this._off = off;
    }

    public final long off() {
        return this._off;
    }

    public final long expectedSz() {
        return this._knownSize ? this._expectedSz : -1L;
    }

    public void setExpectedSz(long sz) {
        this._knownSize = true;
        this._expectedSz = sz;
    }

    public final void open() {
        assert (this._is == null);
        try {
            this._is = this.open(this._off);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract InputStream open(long var1) throws IOException;

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void try2Recover(int attempt, IOException e) {
        if (attempt == 5) {
            Throwables.propagate((Throwable)e);
        }
        Log.warn("[H2OS3InputStream] Attempt(" + attempt + ") to recover from " + e.getMessage() + "), off = " + this._off);
        try {
            this._is.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this._is = null;
        if (attempt > 0) {
            try {
                Thread.sleep(256 << attempt);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.open();
    }

    private void updateOffset(int off) {
        if (this._knownSize) assert ((long)off + this._off <= this._expectedSz);
        this._off += (long)off;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    private void checkEof() throws IOException {
        if (this._knownSize && this._off < this._expectedSz) {
            throw new IOException("premature end of file reported, expected " + this._expectedSz + " bytes, but got eof after " + this._off + " bytes");
        }
    }

    @Override
    public final int available() throws IOException {
        int attempts = 0;
        while (true) {
            try {
                int res = this._is.available();
                if (res == 0) {
                    this.checkEof();
                }
                return this._is.available();
            }
            catch (IOException e) {
                this.try2Recover(attempts++, e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            try {
                int res = this._is.read();
                if (res == -1) {
                    this.checkEof();
                }
                if (res != -1) {
                    this.updateOffset(1);
                    if (this._pmon != null) {
                        this._pmon.update(1L);
                    }
                }
                return res;
            }
            catch (IOException e) {
                this.try2Recover(attempts++, e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                int res = this._is.read(b);
                if (res == -1) {
                    this.checkEof();
                }
                if (res > 0) {
                    this.updateOffset(res);
                    if (this._pmon != null) {
                        this._pmon.update(res);
                    }
                }
                return res;
            }
            catch (IOException e) {
                this.try2Recover(attempts++, e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                int res = this._is.read(b, off, len);
                if (res == -1) {
                    this.checkEof();
                }
                if (res > 0) {
                    this.updateOffset(res);
                    if (this._pmon != null) {
                        this._pmon.update(res);
                    }
                }
                return res;
            }
            catch (IOException e) {
                this.try2Recover(attempts++, e);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() throws IOException {
        if (this._is != null) {
            this._is.close();
            this._is = null;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                long res = this._is.skip(n);
                if (res > 0L) {
                    this.updateOffset((int)res);
                    if (this._pmon != null) {
                        this._pmon.update(res);
                    }
                }
                return res;
            }
            catch (IOException e) {
                this.try2Recover(attempts++, e);
                continue;
            }
            break;
        }
    }

    public static interface ProgressMonitor {
        public void update(long var1);
    }
}

