/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import water.H2O;
import water.Iced;
import water.api.Schema;
import water.api.SchemaMetadata;
import water.exceptions.H2ONotFoundArgumentException;
import water.util.Log;
import water.util.Pair;
import water.util.ReflectionUtils;

public class SchemaServer {
    private static final int HIGHEST_SUPPORTED_VERSION = 4;
    private static final int EXPERIMENTAL_VERSION = 99;
    private static int LATEST_VERSION = -1;
    private static boolean schemas_registered = false;
    private static Map<String, Class<? extends Schema>> schemas = new HashMap<String, Class<? extends Schema>>();
    private static Map<String, Class<? extends Iced>> schema_to_iced = new HashMap<String, Class<? extends Iced>>();
    private static Map<Pair<String, Integer>, Class<? extends Schema>> iced_to_schema = new HashMap<Pair<String, Integer>, Class<? extends Schema>>();

    public static int getLatestVersion() {
        return LATEST_VERSION;
    }

    public static int getHighestSupportedVersion() {
        return 4;
    }

    public static int getLatestOrHighestSupportedVersion() {
        return LATEST_VERSION == -1 ? 4 : LATEST_VERSION;
    }

    public static int getExperimentalVersion() {
        return 99;
    }

    public static void checkIfRegistered(Schema schema) {
        if (schemas_registered && !schema_to_iced.containsKey(schema.getSchemaName())) {
            throw H2O.fail("Schema " + schema.getSchemaName() + " was instantiated before it was registered...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void register(Class<? extends Schema> clz) {
        Class<? extends Schema> clazz = clz;
        // MONITORENTER : clazz
        String clzname = clz.getSimpleName();
        Class<? extends Schema> existing = schemas.get(clzname);
        if (existing != null) {
            if (clz != existing) {
                throw H2O.fail("Two schema classes have the same simpleName: " + clz + " and " + existing + ".");
            }
            // MONITOREXIT : clazz
            return;
        }
        if (!(clz.getGenericSuperclass() instanceof ParameterizedType)) throw H2O.fail("Found a Schema that does not have a parametrized superclass.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz);
        Type[] schema_type_parms = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        if (schema_type_parms.length < 2) {
            throw H2O.fail("Found a Schema that does not pass at least two type parameters.  Each Schema needs to be parametrized on the backing class (if any, or Iced if not) and itself: " + clz);
        }
        Class<Object> parm0 = ReflectionUtils.findActualClassParameter(clz, 0);
        Class parm1 = ReflectionUtils.findActualClassParameter(clz, 1);
        String clzstr = clzname + "<" + parm0.getSimpleName() + "," + parm1.getSimpleName() + ">";
        if (!Iced.class.isAssignableFrom(parm0)) {
            throw H2O.fail("Schema " + clzstr + " has bad type parameters: first arg should be a subclass of Iced");
        }
        if (Schema.class.isAssignableFrom(parm0)) {
            throw H2O.fail("Schema " + clzstr + " has bad type parameters: first arg cannot be a Schema");
        }
        if (!Schema.class.isAssignableFrom(parm1)) {
            throw H2O.fail("Schema " + clzstr + " has bad type parameters: second arg should be a subclass of Schema");
        }
        if (!parm1.getSimpleName().equals(clzname)) {
            throw H2O.fail("Schema " + clzstr + " has bad type parameters: second arg should refer to the schema itself");
        }
        int version = Schema.extractVersionFromSchemaName(clzname);
        if (version > 4 && version != 99) {
            throw H2O.fail("Found a schema with a version higher than the highest supported version; you probably want  to bump the highest supported version: " + clz);
        }
        if (version > LATEST_VERSION && version != 99) {
            parm0 = Schema.class;
            // MONITORENTER : water.api.Schema.class
            if (version > LATEST_VERSION) {
                LATEST_VERSION = version;
            }
            // MONITOREXIT : parm0
        }
        Class impl_class = ReflectionUtils.findActualClassParameter(clz, 0);
        Log.debug(String.format("Registering schema: %-40s  (v = %2d, impled by %s)", clz.getCanonicalName(), version, impl_class.getCanonicalName()));
        schemas.put(clzname, clz);
        schema_to_iced.put(clzname, impl_class);
        try {
            Schema s = clz.newInstance();
            SchemaMetadata meta = new SchemaMetadata(s);
            for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                String name = field_meta.name;
                if (name.equals("__meta") || name.equals("__http_status") || name.equals("_exclude_fields") || name.equals("__schema") || name.equals("_fields") || name.equals("Gini") || name.endsWith("AUC") || "f0point5".equals(name) || "f0point5_for_criteria".equals(name) || "f1_for_criteria".equals(name) || "f2_for_criteria".equals(name)) continue;
                if (name.startsWith("_")) {
                    Log.warn("Found schema field which violates the naming convention; name starts with underscore: " + meta.name + "." + name);
                }
                if (name.equals(name.toLowerCase()) || name.equals(name.toUpperCase()) || clzname.equals("Word2VecParametersV3")) continue;
                Log.warn("Found schema field which violates the naming convention; name has mixed lowercase and uppercase characters: " + meta.name + "." + name);
            }
        }
        catch (Exception e) {
            throw H2O.fail("Failed to instantiate schema class " + clzname + " because: " + e);
        }
        if (impl_class != Iced.class) {
            Pair<String, Integer> versioned = new Pair<String, Integer>(impl_class.getSimpleName(), version);
            iced_to_schema.put(versioned, clz);
        }
        // MONITOREXIT : clazz
    }

    public static synchronized void registerAllSchemasIfNecessary() {
        if (schemas_registered) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Reflections[] reflList = new Reflections[]{new Reflections("water", new Scanner[0]), new Reflections("hex", new Scanner[0])};
        SchemaServer.registerSchemasOfClass(Schema.class, reflList);
        Log.info("Registered: " + SchemaServer.schemas().size() + " schemas in " + (System.currentTimeMillis() - startTime) + "ms");
        schemas_registered = true;
    }

    private static void registerSchemasOfClass(Class<? extends Schema> clz, Reflections[] reflList) {
        if (!Modifier.isAbstract(clz.getModifiers())) {
            SchemaServer.register(clz);
        }
        for (Reflections refl : reflList) {
            for (Class schema_class : refl.getSubTypesOf(clz)) {
                SchemaServer.registerSchemasOfClass(schema_class, reflList);
            }
        }
    }

    public static Map<String, Class<? extends Schema>> schemas() {
        return Collections.unmodifiableMap(new HashMap<String, Class<? extends Schema>>(schemas));
    }

    public static Class<? extends Schema> getSchema(String name) {
        Class<? extends Schema> clz = schemas.get(name);
        if (clz == null) {
            throw new H2ONotFoundArgumentException("Failed to find schema for schema_name: " + name, "Failed to find schema for schema_name: " + name);
        }
        return clz;
    }

    public static Class<? extends Schema> schemaClass(int version, String type) {
        if (version < 1) {
            return null;
        }
        Class<? extends Schema> clz = iced_to_schema.get(new Pair<String, Integer>(type, version));
        if (clz != null) {
            return clz;
        }
        clz = SchemaServer.schemaClass(version == 99 ? 4 : version - 1, type);
        if (clz != null) {
            iced_to_schema.put(new Pair<String, Integer>(type, version), clz);
        }
        return clz;
    }

    public static Schema schema(int version, Iced impl) {
        if (version == -1) {
            version = SchemaServer.getLatestVersion();
        }
        return SchemaServer.schema(version, impl.getClass().getSimpleName());
    }

    public static Schema schema(int version, Class<? extends Iced> impl_class) {
        if (version == -1) {
            version = SchemaServer.getLatestVersion();
        }
        return SchemaServer.schema(version, impl_class.getSimpleName());
    }

    private static Schema schema(int version, String type) {
        Class<? extends Schema> clz = SchemaServer.schemaClass(version, type);
        if (clz == null) {
            clz = SchemaServer.schemaClass(99, type);
        }
        if (clz == null) {
            throw new H2ONotFoundArgumentException("Failed to find schema for version: " + version + " and type: " + type, "Failed to find schema for version: " + version + " and type: " + type);
        }
        return Schema.newInstance(clz);
    }
}

