/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import water.Key;
import water.api.API;
import water.api.ModelsHandler;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelSchemaBaseV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.ModelSynopsisV3;
import water.api.schemas3.SchemaV3;

public class ModelsV3
extends SchemaV3<ModelsHandler.Models, ModelsV3> {
    @API(help="Name of Model of interest", json=false)
    public KeyV3.ModelKeyV3 model_id;
    @API(help="Return potentially abridged model suitable for viewing in a browser", json=false, required=false, direction=API.Direction.INPUT)
    public boolean preview = false;
    @API(help="Find and return compatible frames?", json=false, direction=API.Direction.INPUT)
    public boolean find_compatible_frames = false;
    @API(help="Models", direction=API.Direction.OUTPUT)
    public ModelSchemaBaseV3[] models;
    @API(help="Compatible frames", direction=API.Direction.OUTPUT)
    public FrameV3[] compatible_frames;

    @Override
    public ModelsHandler.Models fillImpl(ModelsHandler.Models m) {
        super.fillImpl(m);
        if (null != this.models) {
            m.models = new Model[this.models.length];
            int i = 0;
            for (ModelSchemaBaseV3 model : this.models) {
                m.models[i++] = (Model)model.createImpl();
            }
        }
        return m;
    }

    @Override
    public ModelsV3 fillFromImpl(ModelsHandler.Models m) {
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)m.model_id);
        this.find_compatible_frames = m.find_compatible_frames;
        if (null != m.models) {
            this.models = new ModelSchemaBaseV3[m.models.length];
            int i = 0;
            for (Model model : m.models) {
                this.models[i++] = (ModelSchemaV3)SchemaServer.schema(this.getSchemaVersion(), model).fillFromImpl(model);
            }
        }
        return this;
    }

    public ModelsV3 fillFromImplWithSynopsis(ModelsHandler.Models m) {
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)m.model_id);
        if (null != m.models) {
            this.models = new ModelSchemaBaseV3[m.models.length];
            int i = 0;
            for (Model model : m.models) {
                this.models[i++] = new ModelSynopsisV3(model);
            }
        }
        return this;
    }
}

