/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.File;
import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.FileVec;
import water.fvec.Vec;
import water.persist.PersistNFS;

public class NFSFileVec
extends FileVec {
    public static NFSFileVec make(File f) {
        Futures fs = new Futures();
        NFSFileVec nfs = NFSFileVec.make(f, fs);
        fs.blockForPending();
        return nfs;
    }

    public static NFSFileVec make(File f, Futures fs) {
        if (!f.exists()) {
            throw new IllegalArgumentException("File not found: " + f.toString());
        }
        long size = f.length();
        Key<Vec> k = Vec.newKey(PersistNFS.decodeFile(f));
        NFSFileVec nfs = new NFSFileVec(k, size);
        DKV.put(k, nfs, fs);
        return nfs;
    }

    private NFSFileVec(Key key, long len) {
        super(key, len, (byte)4);
    }
}

