/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.rapids.Env;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstRoot;

public class TransformWrappedVec
extends WrappedVec {
    private final Key<Vec>[] _masterVecKeys;
    private transient Vec[] _masterVecs;
    private final AstRoot _fun;

    public TransformWrappedVec(Key key, int rowLayout, AstRoot fun, Key<Vec> ... masterVecKeys) {
        super(key, rowLayout, (Key)null);
        this._fun = fun;
        this._masterVecKeys = masterVecKeys;
        DKV.put(this);
    }

    public TransformWrappedVec(Vec v, AstRoot fun) {
        this(v.group().addVec(), v._rowLayout, fun, v._key);
    }

    public Vec makeVec() {
        Vec v = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(c.atd(i));
                }
            }
        }.doAll((byte)3, this)).outputFrame().anyVec();
        this.remove();
        return v;
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        Chunk[] cs = new Chunk[this._masterVecKeys.length];
        if (this._masterVecs == null) {
            this._masterVecs = new Vec[this._masterVecKeys.length];
        }
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = (this._masterVecs[i] != null ? this._masterVecs[i] : this._masterVecKeys[i].get()).chunkForChunkIdx(cidx);
        }
        return new TransformWrappedChunk(this._fun, this, cs);
    }

    @Override
    public Vec doCopy() {
        TransformWrappedVec v = new TransformWrappedVec(this.group().addVec(), this._rowLayout, this._fun, this._masterVecKeys);
        v.setDomain(this.domain() == null ? null : (String[])this.domain().clone());
        return v;
    }

    public static class TransformWrappedChunk
    extends Chunk {
        public final AstRoot _fun;
        public final transient Chunk[] _c;
        private final AstRoot[] _asts;
        private final Env _env;

        TransformWrappedChunk(AstRoot fun, Vec transformWrappedVec, Chunk ... c) {
            this._c = c;
            this.set_len(this._c[0]._len);
            this._start = this._c[0]._start;
            this._vec = transformWrappedVec;
            this._cidx = this._c[0]._cidx;
            this._fun = fun;
            this._asts = new AstRoot[1 + this._c.length];
            this._asts[0] = this._fun;
            for (int i = 1; i < this._asts.length; ++i) {
                this._asts[i] = AstParameter.makeNum(0.0);
            }
            this._env = new Env(null);
        }

        @Override
        public double atd_impl(int idx) {
            if (null == this._fun) {
                return this._c[0].atd(idx);
            }
            for (int i = 1; i < this._asts.length; ++i) {
                ((AstParameter)this._asts[i]).setNum(this._c[i - 1].atd(idx));
            }
            return this._fun.apply(this._env, this._env.stk(), this._asts).getNum();
        }

        @Override
        public long at8_impl(int idx) {
            throw H2O.unimpl();
        }

        @Override
        public boolean isNA_impl(int idx) {
            return Double.isNaN(this.atd_impl(idx));
        }

        @Override
        public boolean set_impl(int idx, long l) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, double d) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, float f) {
            return false;
        }

        @Override
        public boolean setNA_impl(int idx) {
            return false;
        }

        @Override
        public NewChunk inflate_impl(NewChunk nc) {
            nc.set_sparseLen(nc.set_len(0));
            for (int i = 0; i < this._len; ++i) {
                if (this.isNA(i)) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(this.atd(i));
            }
            return nc;
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }
    }
}

