/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.JettyHTTPD;
import water.Paxos;
import water.init.AbstractEmbeddedH2OConfig;
import water.util.Log;
import water.util.NetworkUtils;
import water.util.OSUtils;

public class NetworkInit {
    public static DatagramChannel _udpSocket;
    public static ServerSocketChannel _tcpSocket;
    public static DatagramChannel CLOUD_DGRAM;

    public static InetAddress findInetAddressForSelf() throws Error {
        ArrayList<CIDRBlock> networkList;
        if (H2O.SELF_ADDRESS != null) {
            return H2O.SELF_ADDRESS;
        }
        if (H2O.ARGS.ip != null && H2O.ARGS.network != null) {
            Log.err("ip and network options must not be used together");
            H2O.exit(-1);
        }
        if ((networkList = NetworkInit.calcArrayList(H2O.ARGS.network)) == null) {
            Log.err("No network found! Exiting.");
            H2O.exit(-1);
        }
        ArrayList<InetAddress> ips = NetworkInit.calcPrioritizedInetAddressList();
        InetAddress local = null;
        if (H2O.ARGS.ip != null) {
            local = NetworkInit.getInetAddress(H2O.ARGS.ip, ips);
        } else if (networkList.size() > 0) {
            Log.info("Network list was specified by the user.  Searching for a match...");
            for (InetAddress ip : ips) {
                Log.info("    Considering " + ip.getHostAddress() + " ...");
                for (CIDRBlock n : networkList) {
                    if (!n.isInetAddressOnNetwork(ip)) continue;
                    Log.info("    Matched " + ip.getHostAddress());
                    return ip;
                }
            }
            Log.err("No interface matches the network list from the -network option.  Exiting.");
            H2O.exit(-1);
        } else {
            ArrayList<InetAddress> globalIps = new ArrayList<InetAddress>();
            ArrayList<InetAddress> siteLocalIps = new ArrayList<InetAddress>();
            ArrayList<InetAddress> linkLocalIps = new ArrayList<InetAddress>();
            boolean isIPv6Preferred = NetworkUtils.isIPv6Preferred();
            boolean isIPv4Preferred = NetworkUtils.isIPv4Preferred();
            for (InetAddress ip : ips) {
                if (ip.isLoopbackAddress() || ip.isAnyLocalAddress() || isIPv6Preferred && !isIPv4Preferred && ip instanceof Inet4Address || isIPv4Preferred && ip instanceof Inet6Address) continue;
                if (ip.isSiteLocalAddress()) {
                    siteLocalIps.add(ip);
                }
                if (ip.isLinkLocalAddress()) {
                    linkLocalIps.add(ip);
                }
                globalIps.add(ip);
            }
            local = globalIps.size() == 1 ? (InetAddress)globalIps.get(0) : (siteLocalIps.size() == 1 ? (InetAddress)siteLocalIps.get(0) : (linkLocalIps.size() > 0 ? (InetAddress)linkLocalIps.get(0) : NetworkInit.guessInetAddress(siteLocalIps)));
        }
        if (local == null) {
            try {
                Log.warn("Failed to determine IP, falling back to localhost.");
                local = NetworkUtils.isIPv6Preferred() && !NetworkUtils.isIPv4Preferred() ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException e) {
                Log.throwErr(e);
            }
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static InetAddress guessInetAddress(List<InetAddress> ips) {
        InetAddress ip2222222222;
        String m = "Multiple local IPs detected:\n";
        for (InetAddress ip2222222222 : ips) {
            m = m + "  " + ip2222222222;
        }
        m = m + "\nAttempting to determine correct address...\n";
        Socket s = null;
        try {
            s = NetworkUtils.isIPv6Preferred() && !NetworkUtils.isIPv4Preferred() ? new Socket(InetAddress.getByAddress(NetworkUtils.GOOGLE_DNS_IPV6), 53) : new Socket(InetAddress.getByAddress(NetworkUtils.GOOGLE_DNS_IPV4), 53);
            m = m + "Using " + s.getLocalAddress() + "\n";
            ip2222222222 = s.getLocalAddress();
        }
        catch (SocketException se) {
            InetAddress inetAddress = null;
            Log.warn(m);
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            return inetAddress;
        }
        catch (Throwable t) {
            Log.err(t);
            InetAddress inetAddress = null;
            {
                catch (Throwable throwable) {
                    Log.warn(m);
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException ie) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            Log.warn(m);
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            return inetAddress;
        }
        Log.warn(m);
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        return ip2222222222;
    }

    private static InetAddress getInetAddress(String ip, List<InetAddress> allowedIps) {
        InetAddress addr = null;
        if (ip != null) {
            try {
                addr = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                Log.err(e);
                H2O.exit(-1);
            }
            if (allowedIps != null && !allowedIps.contains(addr)) {
                Log.warn("IP address not found on this machine");
                H2O.exit(-1);
            }
        }
        return addr;
    }

    private static ArrayList<NetworkInterface> calcPrioritizedInterfaceList() {
        ArrayList<NetworkInterface> networkInterfaceList = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> tmpList = Collections.list(nis);
            Comparator<NetworkInterface> c = new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface lhs, NetworkInterface rhs) {
                    if (lhs == null && rhs == null) {
                        return 0;
                    }
                    if (lhs == null) {
                        return 1;
                    }
                    if (rhs == null) {
                        return -1;
                    }
                    if (lhs.getName().equals(rhs.getName())) {
                        return 0;
                    }
                    if (lhs.getName().startsWith("bond") && rhs.getName().startsWith("bond")) {
                        Integer ri;
                        Integer li = lhs.getName().length();
                        if (li.compareTo(ri = Integer.valueOf(rhs.getName().length())) != 0) {
                            return li.compareTo(ri);
                        }
                        return lhs.getName().compareTo(rhs.getName());
                    }
                    if (lhs.getName().startsWith("bond")) {
                        return -1;
                    }
                    if (rhs.getName().startsWith("bond")) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(tmpList, c);
            networkInterfaceList = tmpList;
        }
        catch (SocketException e) {
            Log.err(e);
        }
        return networkInterfaceList;
    }

    static ArrayList<InetAddress> calcPrioritizedInetAddressList() {
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
        ArrayList<NetworkInterface> networkInterfaceList = NetworkInit.calcPrioritizedInterfaceList();
        boolean isWindows = OSUtils.isWindows();
        int localIpTimeout = NetworkUtils.getLocalIpPingTimeout();
        for (NetworkInterface nIface : networkInterfaceList) {
            Enumeration<InetAddress> ias = nIface.getInetAddresses();
            if (NetworkUtils.isUp(nIface)) {
                while (ias.hasMoreElements()) {
                    InetAddress ia = ias.nextElement();
                    if (isWindows || NetworkUtils.isReachable(null, ia, localIpTimeout)) {
                        ips.add(ia);
                        Log.info("Possible IP Address: ", nIface.getName(), " (", nIface.getDisplayName(), "), ", ia.getHostAddress());
                        continue;
                    }
                    Log.info("Network address/interface is not reachable in 150ms: ", ia, "/", nIface);
                }
                continue;
            }
            Log.info("Network interface is down: ", nIface);
        }
        return ips;
    }

    static ArrayList<CIDRBlock> calcArrayList(String networkOpt) {
        ArrayList<CIDRBlock> networkList = new ArrayList<CIDRBlock>();
        if (networkOpt == null) {
            return networkList;
        }
        String[] networks = networkOpt.contains(",") ? networkOpt.split(",") : new String[]{networkOpt};
        for (String n : networks) {
            CIDRBlock usn = CIDRBlock.parse(n);
            if (n == null || !usn.valid()) {
                Log.err("network invalid: " + n);
                return null;
            }
            networkList.add(usn);
        }
        return networkList;
    }

    public static void initializeNetworkSockets() {
        int n = H2O.API_PORT = H2O.ARGS.port == 0 ? H2O.ARGS.baseport : H2O.ARGS.port;
        if (H2O.getJetty() == null) {
            H2O.setJetty(new JettyHTTPD());
        }
        ServerSocket apiSocket = null;
        while (true) {
            H2O.H2O_PORT = H2O.API_PORT + 1;
            try {
                if (!H2O.ARGS.disable_web) {
                    apiSocket = H2O.ARGS.web_ip == null ? new ServerSocket(H2O.API_PORT) : new ServerSocket(H2O.API_PORT, -1, NetworkInit.getInetAddress(H2O.ARGS.web_ip, null));
                    apiSocket.setReuseAddress(true);
                }
                _udpSocket = DatagramChannel.open();
                _udpSocket.socket().setReuseAddress(true);
                InetSocketAddress isa = new InetSocketAddress(H2O.SELF_ADDRESS, H2O.H2O_PORT);
                _udpSocket.socket().bind(isa);
                _tcpSocket = ServerSocketChannel.open();
                _tcpSocket.socket().setReceiveBufferSize(AutoBuffer.TCP_BUF_SIZ);
                _tcpSocket.socket().bind(isa);
                if (H2O.ARGS.disable_web) break;
                apiSocket.close();
                H2O.getJetty().start(H2O.ARGS.web_ip, H2O.API_PORT);
            }
            catch (Exception e) {
                if (apiSocket != null) {
                    try {
                        apiSocket.close();
                    }
                    catch (IOException ohwell) {
                        Log.err(ohwell);
                    }
                }
                if (_udpSocket != null) {
                    try {
                        _udpSocket.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                if (_tcpSocket != null) {
                    try {
                        _tcpSocket.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                apiSocket = null;
                _udpSocket = null;
                _tcpSocket = null;
                if (H2O.ARGS.port != 0) {
                    H2O.die("On " + H2O.SELF_ADDRESS + " some of the required ports " + H2O.ARGS.port + ", " + (H2O.ARGS.port + 1) + " are not available, change -port PORT and try again.");
                }
                if ((H2O.API_PORT += 2) <= 65536) continue;
                Log.err("Cannot find free port for " + H2O.SELF_ADDRESS);
                H2O.exit(-1);
                continue;
            }
            break;
        }
        boolean isIPv6 = H2O.SELF_ADDRESS instanceof Inet6Address;
        H2O.SELF = H2ONode.self(H2O.SELF_ADDRESS);
        Log.info("Internal communication uses port: ", H2O.H2O_PORT, "\nListening for HTTP and REST traffic on " + H2O.getURL(H2O.getJetty().getScheme()) + "/");
        try {
            Log.debug("Interface MTU: ", NetworkInterface.getByInetAddress(H2O.SELF_ADDRESS).getMTU());
        }
        catch (SocketException se) {
            Log.debug("No MTU due to SocketException. " + se.toString());
        }
        String embeddedConfigFlatfile = null;
        AbstractEmbeddedH2OConfig ec = H2O.getEmbeddedH2OConfig();
        if (ec != null) {
            ec.notifyAboutEmbeddedWebServerIpPort(H2O.SELF_ADDRESS, H2O.API_PORT);
            if (ec.providesFlatfile()) {
                try {
                    embeddedConfigFlatfile = ec.fetchFlatfile();
                }
                catch (Exception e) {
                    Log.err("Failed to get embedded config flatfile");
                    Log.err(e);
                    H2O.exit(1);
                }
            }
        }
        H2O.STATIC_H2OS = embeddedConfigFlatfile != null ? NetworkInit.parseFlatFileFromString(embeddedConfigFlatfile) : NetworkInit.parseFlatFile(H2O.ARGS.flatfile);
        int hash = H2O.ARGS.name.hashCode();
        try {
            H2O.CLOUD_MULTICAST_GROUP = isIPv6 ? NetworkUtils.getIPv6MulticastGroup(hash, NetworkUtils.getIPv6Scope(H2O.SELF_ADDRESS)) : NetworkUtils.getIPv4MulticastGroup(hash);
        }
        catch (UnknownHostException e) {
            Log.err("Cannot get multicast group address for " + H2O.SELF_ADDRESS);
            Log.throwErr(e);
        }
        H2O.CLOUD_MULTICAST_PORT = NetworkUtils.getMulticastPort(hash);
    }

    public static void multicast(ByteBuffer bb, byte priority) {
        try {
            NetworkInit.multicast2(bb, priority);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multicast2(ByteBuffer bb, byte priority) {
        if (H2O.STATIC_H2OS == null) {
            byte[] buf = new byte[bb.remaining()];
            bb.get(buf);
            Class<H2O> clazz = H2O.class;
            synchronized (H2O.class) {
                block17: {
                    assert (H2O.CLOUD_MULTICAST_IF != null);
                    try {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) {
                            H2O.CLOUD_MULTICAST_SOCKET = new MulticastSocket();
                            H2O.CLOUD_MULTICAST_SOCKET.setTimeToLive(2);
                            H2O.CLOUD_MULTICAST_SOCKET.setNetworkInterface(H2O.CLOUD_MULTICAST_IF);
                        }
                        H2O.CLOUD_MULTICAST_SOCKET.send(new DatagramPacket(buf, buf.length, H2O.CLOUD_MULTICAST_GROUP, H2O.CLOUD_MULTICAST_PORT));
                    }
                    catch (Exception e) {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) break block17;
                        try {
                            H2O.CLOUD_MULTICAST_SOCKET.close();
                        }
                        catch (Exception e2) {
                            Log.err("Got", e2);
                        }
                        finally {
                            H2O.CLOUD_MULTICAST_SOCKET = null;
                        }
                    }
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        HashSet nodes = (HashSet)H2O.STATIC_H2OS.clone();
        nodes.addAll(Paxos.PROPOSED.values());
        bb.mark();
        for (H2ONode h2o : nodes) {
            try {
                bb.reset();
                if (H2O.ARGS.useUDP) {
                    CLOUD_DGRAM.send(bb, h2o._key);
                    continue;
                }
                h2o.sendMessage(bb, priority);
            }
            catch (IOException e) {
                Log.warn("Multicast Error to " + h2o, e);
            }
        }
    }

    private static HashSet<H2ONode> parseFlatFile(String fname) {
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            Log.warn("-flatfile specified but not found: " + fname);
            return null;
        }
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(f);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static HashSet<H2ONode> parseFlatFileFromString(String s) {
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(is);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static List<FlatFileEntry> parseFlatFile(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        return NetworkInit.parseFlatFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FlatFileEntry> parseFlatFile(InputStream is) {
        ArrayList<FlatFileEntry> list = new ArrayList<FlatFileEntry>();
        BufferedReader br = null;
        int port = H2O.ARGS.port;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).startsWith("#") || strLine.isEmpty()) continue;
                String ip = null;
                String portStr = null;
                int slashIdx = strLine.indexOf(47);
                int colonIdx = strLine.lastIndexOf(58);
                if (slashIdx == -1 && colonIdx == -1) {
                    ip = strLine;
                } else if (slashIdx == -1) {
                    ip = strLine.substring(0, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                } else if (colonIdx == -1) {
                    ip = strLine.substring(slashIdx + 1);
                } else if (slashIdx > colonIdx) {
                    H2O.die("Invalid format, must be [name/]ip[:port], not '" + strLine + "'");
                } else {
                    ip = strLine.substring(slashIdx + 1, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                }
                InetAddress inet = InetAddress.getByName(ip);
                if (portStr != null && !portStr.equals("")) {
                    try {
                        port = Integer.decode(portStr);
                    }
                    catch (NumberFormatException nfe) {
                        H2O.die("Invalid port #: " + portStr);
                    }
                }
                FlatFileEntry entry = new FlatFileEntry();
                entry.inet = inet;
                entry.port = port;
                list.add(entry);
            }
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ie) {}
            }
        }
        return list;
    }

    static class FlatFileEntry {
        InetAddress inet;
        int port;

        FlatFileEntry() {
        }
    }

    public static class CIDRBlock {
        private static Pattern NETWORK_IPV4_CIDR_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)/(\\d+)");
        private static Pattern NETWORK_IPV6_CIDR_PATTERN = Pattern.compile("([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+):([a-fA-F\\d]+)/(\\d+)");
        final int[] ip;
        final int bits;

        public static CIDRBlock parse(String cidrBlock) {
            boolean isIPV4 = cidrBlock.contains(".");
            Matcher m = isIPV4 ? NETWORK_IPV4_CIDR_PATTERN.matcher(cidrBlock) : NETWORK_IPV6_CIDR_PATTERN.matcher(cidrBlock);
            boolean b = m.matches();
            if (!b) {
                return null;
            }
            assert (isIPV4 && m.groupCount() == 5 || m.groupCount() == 9);
            int len = isIPV4 ? 4 : 8;
            int[] ipBytes = new int[len];
            for (int i = 0; i < len; ++i) {
                ipBytes[i] = isIPV4 ? Integer.parseInt(m.group(i + 1)) : Integer.parseInt(m.group(i + 1), 16);
            }
            int bits = Integer.parseInt(m.group(len + 1));
            CIDRBlock usn = isIPV4 ? CIDRBlock.createIPv4(ipBytes, bits) : CIDRBlock.createIPv6(ipBytes, bits);
            return usn.valid() ? usn : null;
        }

        public static CIDRBlock createIPv4(int[] ip, int bits) {
            assert (ip.length == 4);
            return new CIDRBlock(ip, bits);
        }

        public static CIDRBlock createIPv6(int[] ip, int bits) {
            assert (ip.length == 8);
            int[] ipLong = new int[16];
            for (int i = 0; i < ip.length; ++i) {
                ipLong[2 * i + 0] = ip[i] >> 8 & 0xFF;
                ipLong[2 * i + 1] = ip[i] & 0xFF;
            }
            return new CIDRBlock(ipLong, bits);
        }

        private CIDRBlock(int[] ip, int bits) {
            assert (ip.length == 4 || ip.length == 16) : "Wrong number of bytes to construct IP: " + ip.length;
            this.ip = ip;
            this.bits = bits;
        }

        private boolean validOctet(int o) {
            return 0 <= o && o <= 255;
        }

        private boolean valid() {
            for (int i = 0; i < this.ip.length; ++i) {
                if (this.validOctet(this.ip[i])) continue;
                return false;
            }
            return 0 <= this.bits && this.bits <= this.ip.length * 8;
        }

        boolean isInetAddressOnNetwork(InetAddress ia) {
            byte[] ipBytes = ia.getAddress();
            return this.isInetAddressOnNetwork(ipBytes);
        }

        boolean isInetAddressOnNetwork(byte[] ipBytes) {
            int i = 0;
            for (i = 0; i < this.bits / 8; ++i) {
                if ((ipBytes[i] & 0xFF) == this.ip[i]) continue;
                return false;
            }
            int remaining = 0;
            remaining = 8 - this.bits % 8;
            if (remaining < 8) {
                int mask = ~((1 << remaining) - 1) & 0xFF;
                return (ipBytes[i] & 0xFF & mask) == (this.ip[i] & mask);
            }
            return true;
        }
    }
}

