/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.StreamParseWriter;

public abstract class Parser
extends Iced {
    static final byte CHAR_TAB = 9;
    static final byte CHAR_CR = 13;
    static final byte CHAR_LF = 10;
    static final byte CHAR_SPACE = 32;
    static final byte CHAR_DOUBLE_QUOTE = 34;
    static final byte CHAR_SINGLE_QUOTE = 39;
    protected static final byte SKIP_LINE = 0;
    protected static final byte EXPECT_COND_LF = 1;
    protected static final byte EOL = 2;
    protected static final byte TOKEN = 3;
    protected static final byte COND_QUOTED_TOKEN = 4;
    protected static final byte NUMBER = 5;
    protected static final byte NUMBER_SKIP = 6;
    protected static final byte NUMBER_SKIP_NO_DOT = 7;
    protected static final byte NUMBER_FRACTION = 8;
    protected static final byte NUMBER_EXP = 9;
    protected static final byte NUMBER_EXP_START = 11;
    protected static final byte NUMBER_END = 12;
    protected static final byte STRING = 13;
    protected static final byte COND_QUOTE = 14;
    protected static final byte SEPARATOR_OR_EOL = 15;
    protected static final byte WHITESPACE_BEFORE_TOKEN = 16;
    protected static final byte STRING_END = 17;
    protected static final byte COND_QUOTED_NUMBER_END = 18;
    protected static final byte POSSIBLE_EMPTY_LINE = 19;
    protected static final byte POSSIBLE_CURRENCY = 20;
    protected final byte CHAR_DECIMAL_SEP = (byte)46;
    protected final byte CHAR_SEPARATOR;
    protected static final long LARGEST_DIGIT_NUMBER = 0xCCCCCCCCCCCCCCCL;
    protected final ParseSetup _setup;
    protected final Key<Job> _jobKey;

    protected static boolean isEOL(byte c) {
        return c == 10 || c == 13;
    }

    protected Parser(ParseSetup setup, Key<Job> jobKey) {
        this._setup = setup;
        this.CHAR_SEPARATOR = setup._separator;
        this._jobKey = jobKey;
    }

    protected int fileHasHeader(byte[] bits, ParseSetup ps) {
        return -1;
    }

    protected abstract ParseWriter parseChunk(int var1, ParseReader var2, ParseWriter var3);

    ParseWriter streamParse(InputStream is, ParseWriter dout) throws IOException {
        if (!this._setup._parse_type.isParallelParseSupported) {
            throw H2O.unimpl();
        }
        StreamData din = new StreamData(is);
        int cidx = 0;
        while (is.available() > 0 && (this._jobKey == null || this._jobKey.get().stop_requested())) {
            this.parseChunk(cidx++, din, dout);
        }
        this.parseChunk(cidx, din, dout);
        return dout;
    }

    ParseWriter streamParseZip(InputStream is, StreamParseWriter dout, InputStream bvs) throws IOException {
        if (!this._setup._parse_type.isParallelParseSupported) {
            throw H2O.unimpl();
        }
        StreamData din = new StreamData(is);
        int cidx = 0;
        StreamParseWriter nextChunk = dout;
        int zidx = bvs.read(null, 0, 0);
        assert (zidx == 1);
        while (is.available() > 0) {
            int xidx = bvs.read(null, 0, 0);
            if (xidx > zidx) {
                zidx = xidx;
                nextChunk.close();
                if (dout != nextChunk) {
                    dout.reduce(nextChunk);
                    if (this._jobKey != null && this._jobKey.get().stop_requested()) break;
                }
                nextChunk = nextChunk.nextChunk();
            }
            this.parseChunk(cidx++, din, nextChunk);
        }
        this.parseChunk(cidx, din, nextChunk);
        nextChunk.close();
        if (dout != nextChunk) {
            dout.reduce(nextChunk);
        }
        return dout;
    }

    static final class StreamData
    implements ParseReader {
        public static int bufSz = 65536;
        final transient InputStream _is;
        private byte[] _bits0 = new byte[bufSz];
        private byte[] _bits1 = new byte[bufSz];
        private int _cidx0 = -1;
        private int _cidx1 = -1;
        private int _coff0 = -1;
        private int _coff1 = -1;
        long _gOff;

        private StreamData(InputStream is) {
            this._is = is;
        }

        @Override
        public byte[] getChunkData(int cidx) {
            byte[] bits2;
            int off;
            if (cidx == this._cidx0) {
                return this._bits0;
            }
            this._gOff = this._bits0.length;
            if (cidx == this._cidx1) {
                return this._bits1;
            }
            assert (cidx == this._cidx0 + 1 || cidx == this._cidx1 + 1);
            byte[] bits = this._cidx0 < this._cidx1 ? this._bits0 : this._bits1;
            this._gOff += (long)bits.length;
            if (this._cidx0 < this._cidx1) {
                this._cidx0 = cidx;
                this._coff0 = -1;
            } else {
                this._cidx1 = cidx;
                this._coff1 = -1;
            }
            try {
                int len;
                for (off = 0; off < bits.length && (len = this._is.read(bits, off, bits.length - off)) != -1; off += len) {
                }
                assert (off == bits.length || this._is.available() <= 0);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            if (off == bits.length) {
                return bits;
            }
            byte[] byArray = bits2 = off == 0 ? null : Arrays.copyOf(bits, off);
            if (this._cidx0 == cidx) {
                this._bits0 = bits2;
            } else {
                this._bits1 = bits2;
            }
            return bits2;
        }

        @Override
        public int getChunkDataStart(int cidx) {
            if (this._cidx0 == cidx) {
                return this._coff0;
            }
            if (this._cidx1 == cidx) {
                return this._coff1;
            }
            return 0;
        }

        @Override
        public void setChunkDataStart(int cidx, int offset) {
            if (this._cidx0 == cidx) {
                this._coff0 = offset;
            }
            if (this._cidx1 == cidx) {
                this._coff1 = offset;
            }
        }

        @Override
        public long getGlobalByteOffset() {
            return 0L;
        }
    }
}

