/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import water.fvec.ByteVec;
import water.util.Log;
import water.util.UnsafeUtils;

abstract class ZipUtil {
    ZipUtil() {
    }

    static byte[] getFirstUnzippedBytes(ByteVec bv) {
        try {
            byte[] bits = bv.getFirstBytes();
            return ZipUtil.unzipBytes(bits, ZipUtil.guessCompressionMethod(bits), 0x400000);
        }
        catch (Exception e) {
            Log.debug("Cannot get unzipped bytes from ByteVec!", e);
            return null;
        }
    }

    static Compression guessCompressionMethod(byte[] bits) {
        if (bits.length > 30 && (long)UnsafeUtils.get4(bits, 0) == 67324752L) {
            return Compression.ZIP;
        }
        if (bits.length > 2 && (UnsafeUtils.get2(bits, 0) & 0xFFFF) == 35615) {
            return Compression.GZIP;
        }
        return Compression.NONE;
    }

    static float decompressionRatio(ByteVec bv) {
        byte[] zips = bv.getFirstBytes();
        Compression cpr = ZipUtil.guessCompressionMethod(zips);
        if (cpr == Compression.NONE) {
            return 1.0f;
        }
        byte[] bits = ZipUtil.unzipBytes(zips, cpr, 0x400000);
        return bits.length / zips.length;
    }

    static byte[] unzipBytes(byte[] bs, Compression cmp, int chkSize) {
        if (cmp == Compression.NONE) {
            return bs;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        InputStream is = null;
        try {
            if (cmp == Compression.ZIP) {
                ZipInputStream zis = new ZipInputStream(bais);
                ZipEntry ze = zis.getNextEntry();
                if (ze == null || ze.isDirectory()) {
                    byte[] byArray = bs;
                    return byArray;
                }
                is = zis;
            } else {
                assert (cmp == Compression.GZIP);
                is = new GZIPInputStream(bais);
            }
            bs = new byte[bs.length * 2];
            int off = 0;
            while (off < bs.length) {
                int len = is.read(bs, off, bs.length - off);
                if (len < 0) {
                    break;
                }
                if ((off += len) != bs.length) continue;
                if (bs.length >= chkSize) {
                    break;
                }
                bs = Arrays.copyOf(bs, bs.length * 2);
            }
        }
        catch (IOException ioe) {
            throw Log.throwErr(ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignore) {}
        }
        return bs;
    }

    public static int getFileCount(ByteVec bv) {
        int cnt = 0;
        byte[] zips = bv.getFirstBytes();
        Compression cpr = ZipUtil.guessCompressionMethod(zips);
        if (cpr == Compression.NONE || cpr == Compression.GZIP) {
            cnt = 1;
        } else {
            try {
                ZipInputStream zis = new ZipInputStream(bv.openStream(null));
                ZipEntry ze = zis.getNextEntry();
                while (ze != null && !ze.isDirectory()) {
                    ++cnt;
                    ze = zis.getNextEntry();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return cnt;
    }

    public static enum Compression {
        NONE,
        ZIP,
        GZIP;

    }
}

