/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;

class RadixCount
extends MRTask<RadixCount> {
    Long2DArray _counts;
    int _shift;
    int _col;
    long _base;
    boolean _isLeft;
    int[][] _id_maps;

    RadixCount(boolean isLeft, long base, int shift, int col, int[][] id_maps) {
        this._isLeft = isLeft;
        this._base = base;
        this._col = col;
        this._shift = shift;
        this._id_maps = id_maps;
    }

    static Key getKey(boolean isLeft, int col, H2ONode node) {
        Key ans = Key.make("__radix_order__MSBNodeCounts_col" + col + "_node" + node.index() + (isLeft ? "_LEFT" : "_RIGHT"));
        return ans;
    }

    @Override
    protected void setupLocal() {
        this._counts = new Long2DArray(this._fr.anyVec().nChunks());
    }

    @Override
    public void map(Chunk chk) {
        long[] lArray = new long[256];
        this._counts._val[chk.cidx()] = lArray;
        long[] tmp = lArray;
        if (!this._isLeft || !chk.vec().isCategorical()) {
            if (chk.vec().naCnt() == 0L) {
                for (int r = 0; r < chk._len; ++r) {
                    int n = (int)(chk.at8(r) - this._base + 1L >> this._shift);
                    tmp[n] = tmp[n] + 1L;
                }
            } else {
                for (int r = 0; r < chk._len; ++r) {
                    if (chk.isNA(r)) {
                        tmp[0] = tmp[0] + 1L;
                        continue;
                    }
                    int n = (int)(chk.at8(r) - this._base + 1L >> this._shift);
                    tmp[n] = tmp[n] + 1L;
                }
            }
        } else {
            assert (this._id_maps[0].length > 0);
            assert (this._base == 0L);
            if (chk.vec().naCnt() == 0L) {
                for (int r = 0; r < chk._len; ++r) {
                    int n = this._id_maps[0][(int)chk.at8(r)] + 1 >> this._shift;
                    tmp[n] = tmp[n] + 1L;
                }
            } else {
                for (int r = 0; r < chk._len; ++r) {
                    if (chk.isNA(r)) {
                        tmp[0] = tmp[0] + 1L;
                        continue;
                    }
                    int n = this._id_maps[0][(int)chk.at8(r)] + 1 >> this._shift;
                    tmp[n] = tmp[n] + 1L;
                }
            }
        }
    }

    @Override
    protected void closeLocal() {
        DKV.put(RadixCount.getKey(this._isLeft, this._col, H2O.SELF), this._counts, this._fs, true);
    }

    public static class Long2DArray
    extends Iced {
        long[][] _val;

        Long2DArray(int len) {
            this._val = new long[len][];
        }
    }
}

