/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.params;

import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.rapids.Env;
import water.rapids.Rapids;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.util.ArrayUtils;

public class AstStrList
extends AstParameter {
    public String[] _strs;

    public AstStrList(Rapids e) {
        char c;
        ArrayList<String> strs = new ArrayList<String>();
        while ((c = e.skipWS()) != ']') {
            if (Rapids.isQuote(c)) {
                strs.add(e.match(c));
                continue;
            }
            throw new IllegalArgumentException("Expecting the start of a string");
        }
        e.xpeek(']');
        this._strs = strs.toArray(new String[strs.size()]);
    }

    @Override
    public int nargs() {
        return -1;
    }

    @Override
    public Val exec(Env env) {
        throw H2O.fail();
    }

    @Override
    public String str() {
        return Arrays.toString(this._strs);
    }

    @Override
    public int[] columns(String[] names) {
        int[] idxs = new int[this._strs.length];
        for (int i = 0; i < this._strs.length; ++i) {
            idxs[i] = ArrayUtils.find(names, this._strs[i]);
            int idx = idxs[i];
            if (idx != -1) continue;
            throw new IllegalArgumentException("Column " + this._strs[i] + " not found");
        }
        return idxs;
    }
}

