/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import sun.misc.Unsafe;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.prims.advmath.AstVariance;
import water.rapids.ast.prims.reducers.AstMad;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstHist
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "breaks"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "hist";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        double h;
        HistTask t;
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Hist only applies to single numeric columns.");
        }
        Vec vec = f.anyVec();
        if (!vec.isNumeric()) {
            throw new IllegalArgumentException("Hist only applies to single numeric columns.");
        }
        AstRoot a = asts[2];
        String algo = null;
        int numBreaks = -1;
        double[] breaks = null;
        if (a instanceof AstStr) {
            algo = a.str().toLowerCase();
        } else if (a instanceof AstNumList) {
            breaks = ((AstNumList)a).expand();
        } else if (a instanceof AstNum) {
            numBreaks = (int)a.exec(env).getNum();
        }
        double x1 = vec.max();
        double x0 = vec.min();
        if (breaks != null) {
            t = (HistTask)new HistTask(breaks, -1.0, -1.0).doAll(vec);
        } else if (algo != null) {
            String string = algo;
            int n = -1;
            switch (string.hashCode()) {
                case -1878727209: {
                    if (!string.equals("sturges")) break;
                    n = 0;
                    break;
                }
                case 3500249: {
                    if (!string.equals("rice")) break;
                    n = 1;
                    break;
                }
                case 3538208: {
                    if (!string.equals("sqrt")) break;
                    n = 2;
                    break;
                }
                case 95755629: {
                    if (!string.equals("doane")) break;
                    n = 3;
                    break;
                }
                case 109264607: {
                    if (!string.equals("scott")) break;
                    n = 4;
                    break;
                }
                case 3262: {
                    if (!string.equals("fd")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    numBreaks = AstHist.sturges(vec);
                    h = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case 1: {
                    numBreaks = AstHist.rice(vec);
                    h = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case 2: {
                    numBreaks = AstHist.sqrt(vec);
                    h = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case 3: {
                    numBreaks = AstHist.doane(vec);
                    h = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case 4: {
                    h = AstHist.scotts_h(vec);
                    numBreaks = AstHist.scott(vec, h);
                    break;
                }
                case 5: {
                    h = AstHist.fds_h(vec);
                    numBreaks = AstHist.fd(vec, h);
                    break;
                }
                default: {
                    numBreaks = AstHist.sturges(vec);
                    h = (x1 - x0) / (double)numBreaks;
                }
            }
            t = (HistTask)new HistTask(this.computeCuts(vec, numBreaks), h, x0).doAll(vec);
        } else {
            h = (x1 - x0) / (double)numBreaks;
            t = (HistTask)new HistTask(this.computeCuts(vec, numBreaks), h, x0).doAll(vec);
        }
        final double[] brks = t._breaks;
        final long[] cnts = t._counts;
        final double[] mids_true = t._mids;
        final double[] mids = new double[t._breaks.length - 1];
        for (int i = 1; i < brks.length; ++i) {
            mids[i - 1] = 0.5 * (t._breaks[i - 1] + t._breaks[i]);
        }
        Vec layoutVec = Vec.makeZero(brks.length);
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] c, NewChunk[] nc) {
                int start = (int)c[0].start();
                for (int i = 0; i < c[0]._len; ++i) {
                    nc[0].addNum(brks[i + start]);
                    if (i == 0) {
                        nc[1].addNA();
                        nc[2].addNA();
                        nc[3].addNA();
                        continue;
                    }
                    nc[1].addNum(cnts[i - 1 + start]);
                    nc[2].addNum(mids_true[i - 1 + start]);
                    nc[3].addNum(mids[i - 1 + start]);
                }
            }
        }.doAll(4, (byte)3, new Frame(layoutVec))).outputFrame(null, new String[]{"breaks", "counts", "mids_true", "mids"}, null);
        layoutVec.remove();
        return new ValFrame(fr2);
    }

    public static int sturges(Vec v) {
        return (int)Math.ceil(1.0 + AstHist.log2(v.length()));
    }

    public static int rice(Vec v) {
        return (int)Math.ceil(2.0 * Math.pow(v.length(), 0.3333333333333333));
    }

    public static int sqrt(Vec v) {
        return (int)Math.sqrt(v.length());
    }

    public static int doane(Vec v) {
        return (int)(1.0 + AstHist.log2(v.length()) + AstHist.log2(1.0 + Math.abs(AstHist.third_moment(v)) / AstHist.sigma_g1(v)));
    }

    public static int scott(Vec v, double h) {
        return (int)Math.ceil((v.max() - v.min()) / h);
    }

    public static int fd(Vec v, double h) {
        return (int)Math.ceil((v.max() - v.min()) / h);
    }

    public static double fds_h(Vec v) {
        return 2.0 * AstMad.mad(new Frame(v), null, 1.4826) * Math.pow(v.length(), -0.3333333333333333);
    }

    public static double scotts_h(Vec v) {
        return 3.5 * Math.sqrt(AstVariance.getVar(v)) / Math.pow(v.length(), 0.3333333333333333);
    }

    public static double log2(double numerator) {
        return Math.log(numerator) / Math.log(2.0) + 1.0E-10;
    }

    public static double sigma_g1(Vec v) {
        return Math.sqrt(6L * (v.length() - 2L) / ((v.length() + 1L) * (v.length() + 3L)));
    }

    public static double third_moment(Vec v) {
        double mean = v.mean();
        ThirdMomTask t = (ThirdMomTask)new ThirdMomTask(mean).doAll(v);
        double m2 = t._ss / (double)v.length();
        double m3 = t._sc / (double)v.length();
        return m3 / Math.pow(m2, 1.5);
    }

    public double[] computeCuts(Vec v, int numBreaks) {
        if (numBreaks <= 0) {
            throw new IllegalArgumentException("breaks must be a positive number");
        }
        double min = v.min();
        double w = (v.max() - min) / (double)numBreaks;
        double[] res = new double[numBreaks];
        for (int i = 0; i < numBreaks; ++i) {
            res[i] = min + w * (double)(i + 1);
        }
        return res;
    }

    public static class HistTask
    extends MRTask<HistTask> {
        private final double _h;
        private final double _x0;
        private final double[] _min;
        private final double[] _max;
        private static final Unsafe U = UtilUnsafe.getUnsafe();
        private static final int _dB = U.arrayBaseOffset(double[].class);
        private static final int _dS = U.arrayIndexScale(double[].class);
        private static final int _8B = U.arrayBaseOffset(long[].class);
        private static final int _8S = U.arrayIndexScale(long[].class);
        private final double[] _breaks;
        private final long[] _counts;
        private final double[] _mids;

        private static long doubleRawIdx(int i) {
            return _dB + _dS * i;
        }

        private static long longRawIdx(int i) {
            return _8B + _8S * i;
        }

        HistTask(double[] cuts, double h, double x0) {
            this._breaks = cuts;
            this._min = new double[this._breaks.length - 1];
            this._max = new double[this._breaks.length - 1];
            this._counts = new long[this._breaks.length - 1];
            this._mids = new double[this._breaks.length - 1];
            this._h = h;
            this._x0 = x0;
        }

        @Override
        public void map(Chunk c) {
            for (int i = 0; i < c._len; ++i) {
                int x;
                if (c.isNA(i)) continue;
                double r = c.atd(i);
                if (this._h == -1.0) {
                    for (x = 1; x < this._counts.length && !(r <= this._breaks[x]); ++x) {
                    }
                    --x;
                } else {
                    x = Math.min(this._counts.length - 1, (int)Math.floor((r - this._x0) / this._h));
                }
                this.bumpCount(x);
                this.setMinMax(Double.doubleToRawLongBits(r), x);
            }
        }

        @Override
        public void reduce(HistTask t) {
            if (this._counts != t._counts) {
                ArrayUtils.add(this._counts, t._counts);
            }
            for (int i = 0; i < this._mids.length; ++i) {
                this._min[i] = t._min[i] < this._min[i] ? t._min[i] : this._min[i];
                this._max[i] = t._max[i] > this._max[i] ? t._max[i] : this._max[i];
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 0; i < this._mids.length; ++i) {
                this._mids[i] = 0.5 * (this._max[i] + this._min[i]);
            }
        }

        private void bumpCount(int x) {
            long o = this._counts[x];
            while (!U.compareAndSwapLong(this._counts, HistTask.longRawIdx(x), o, o + 1L)) {
                o = this._counts[x];
            }
        }

        private void setMinMax(long v, int x) {
            double o = this._min[x];
            double vv = Double.longBitsToDouble(v);
            while (vv < o && U.compareAndSwapLong(this._min, HistTask.doubleRawIdx(x), Double.doubleToRawLongBits(o), v)) {
                o = this._min[x];
            }
            this.setMax(v, x);
        }

        private void setMax(long v, int x) {
            double o = this._max[x];
            double vv = Double.longBitsToDouble(v);
            while (vv > o && U.compareAndSwapLong(this._min, HistTask.doubleRawIdx(x), Double.doubleToRawLongBits(o), v)) {
                o = this._max[x];
            }
        }
    }

    public static class ThirdMomTask
    extends MRTask<ThirdMomTask> {
        double _ss;
        double _sc;
        final double _mean;

        ThirdMomTask(double mean) {
            this._mean = mean;
        }

        @Override
        public void setupLocal() {
            this._ss = 0.0;
            this._sc = 0.0;
        }

        @Override
        public void map(Chunk c) {
            for (int i = 0; i < c._len; ++i) {
                if (c.isNA(i)) continue;
                double d = c.atd(i) - this._mean;
                double d2 = d * d;
                this._ss += d2;
                this._sc += d2 * d;
            }
        }

        @Override
        public void reduce(ThirdMomTask t) {
            this._ss += t._ss;
            this._sc += t._sc;
        }
    }
}

