/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.assign;

import water.DKV;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.prims.mungers.AstColSlice;
import water.rapids.vals.ValFrame;

public class AstRectangleAssign
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"dst", "src", "col_expr", "row_expr"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return ":=";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame dst = stk.track(asts[1].exec(env)).getFrame();
        Val vsrc = stk.track(asts[2].exec(env));
        AstNumList cols_numlist = new AstNumList(asts[3].columns(dst.names()));
        if (cols_numlist.isEmpty()) {
            cols_numlist = new AstNumList(0L, dst.numCols());
        }
        int[] cols = AstColSlice.col_select(dst.names(), cols_numlist);
        dst = new Frame(dst._names, (Vec[])dst.vecs().clone());
        if (asts[4] instanceof AstNum || asts[4] instanceof AstNumList) {
            AstNumList rows;
            AstNumList astNumList = rows = asts[4] instanceof AstNum ? new AstNumList(((AstNum)asts[4]).getNum()) : (AstNumList)asts[4];
            if (rows.isEmpty()) {
                rows = new AstNumList(0L, dst.numRows());
            }
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getStr(), env._ses);
                    break;
                }
                case 5: {
                    this.assign_frame_frame(dst, cols, rows, vsrc.getFrame(), env._ses);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        } else {
            Frame rows = stk.track(asts[4].exec(env)).getFrame();
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    throw H2O.unimpl();
                }
                case 5: {
                    throw H2O.unimpl();
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        }
        return new ValFrame(dst);
    }

    private void assign_frame_frame(Frame dst, int[] cols, AstNumList rows, Frame src, Session ses) {
        if (cols.length != src.numCols()) {
            throw new IllegalArgumentException("Source and destination frames must have the same count of columns");
        }
        long nrows = rows.cnt();
        if (src.numRows() != nrows) {
            throw new IllegalArgumentException("Requires same count of rows in the number-list (" + nrows + ") as in the source (" + src.numRows() + ")");
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            for (int i = 0; i < cols.length; ++i) {
                dst.replace(cols[i], src.vecs()[i]);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] dvecs = dst.vecs();
        Vec[] svecs = src.vecs();
        for (int col = 0; col < cols.length; ++col) {
            if (dvecs[cols[col]].get_type() == svecs[col].get_type()) continue;
            throw new IllegalArgumentException("Columns must be the same type; column " + col + ", '" + dst._names[cols[col]] + "', is of type " + dvecs[cols[col]].get_type_str() + " and the source is " + svecs[col].get_type_str());
        }
        if (nrows <= 1L || (long)cols.length * nrows <= 1000L) {
            dvecs = ses.copyOnWrite(dst, cols);
            long[] rownums = rows.expand8();
            for (int col = 0; col < svecs.length; ++col) {
                for (int ridx = 0; ridx < rownums.length; ++ridx) {
                    dvecs[cols[col]].set(rownums[ridx], svecs[col].at(ridx));
                }
            }
            return;
        }
        throw H2O.unimpl();
    }

    private void assign_frame_scalar(Frame dst, int[] cols, final AstNumList rows, final double src, Session ses) {
        long nrows = rows.cnt();
        if (nrows == 1L) {
            Vec[] vecs = ses.copyOnWrite(dst, cols);
            long drow = (long)rows._bases[0];
            for (int col : cols) {
                vecs[col].set(drow, src);
            }
            return;
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            Vec vsrc = dst.anyVec().makeCon(src);
            for (int col : cols) {
                dst.replace(col, vsrc);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                long start = cs[0].start();
                long end = start + (long)cs[0]._len;
                long min = (long)rows.min();
                long max = (long)rows.max() - 1L;
                if (max >= start && min <= end) {
                    int startOffset = (int)(min > start ? min : start);
                    for (int i = (int)((long)startOffset - start); i < cs[0]._len; ++i) {
                        if (!rows.has(start + (long)i)) continue;
                        for (Chunk chk : cs) {
                            chk.set(i, src);
                        }
                    }
                }
            }
        }.doAll(vecs2);
    }

    private void assign_frame_scalar(Frame dst, int[] cols, final AstNumList rows, final String src, Session ses) {
        Vec[] dvecs = dst.vecs();
        long nrows = rows.cnt();
        if (nrows == 1L) {
            long drow = (long)rows.expand()[0];
            for (Vec vec : dvecs) {
                vec.set(drow, src);
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                long start = cs[0].start();
                long end = start + (long)cs[0]._len;
                long min = (long)rows.min();
                long max = (long)rows.max() - 1L;
                if (max >= start && min <= end) {
                    int startOffset = (int)(min > start ? min : start);
                    for (int i = (int)((long)startOffset - start); i < cs[0]._len; ++i) {
                        if (!rows.has(start + (long)i)) continue;
                        for (Chunk chk : cs) {
                            chk.set(i, src);
                        }
                    }
                }
            }
        }.doAll(vecs2);
    }

    private void assign_frame_scalar(Frame dst, final int[] cols, Frame rows, final double src, Session ses) {
        Frame src2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk bool = cs[cs.length - 1];
                for (int i = 0; i < cs[0]._len; ++i) {
                    int nc = 0;
                    if (bool.at8(i) == 1L) {
                        for (int c : cols) {
                            ncs[nc++].addNum(src);
                        }
                        continue;
                    }
                    for (int c : cols) {
                        ncs[nc++].addNum(cs[c].atd(i));
                    }
                }
            }
        }.doAll(cols.length, (byte)3, new Frame(dst).add(rows))).outputFrame();
        this.assign_frame_frame(dst, cols, new AstNumList(0L, dst.numRows()), src2, ses);
    }
}

