/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstCountSubstringsWords
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "words"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "num_valid_substrings";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String wordsPath = asts[2].exec(env).getStr();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("num_valid_substrings() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        HashSet<String> words = null;
        try {
            words = new HashSet<String>(FileUtils.readLines((File)new File(wordsPath)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.countSubstringsWordsCategoricalCol(v, words) : this.countSubstringsWordsStringCol(v, words);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec countSubstringsWordsCategoricalCol(Vec vec, final HashSet<String> words) {
        Vec res = ((MRTask)new MRTask(){
            transient double[] catCounts;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catCounts = new double[doms.length];
                for (int i = 0; i < doms.length; ++i) {
                    this.catCounts[i] = AstCountSubstringsWords.this.calcCountSubstringsWords(doms[i], words);
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_doubles(chk._len);
                for (int i = 0; i < chk._len; ++i) {
                    if (chk.isNA(i)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catCounts[(int)chk.atd(i)]);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec countSubstringsWordsStringCol(Vec vec, final HashSet<String> words) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    newChk.addNAs(chk.len());
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        String str = chk.atStr(tmpStr, i).toString();
                        newChk.addNum(AstCountSubstringsWords.this.calcCountSubstringsWords(str, words));
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }

    private int calcCountSubstringsWords(String str, HashSet<String> words) {
        int wordCount = 0;
        int N = str.length();
        for (int i = 0; i < N - 1; ++i) {
            for (int j = i + 2; j < N + 1; ++j) {
                if (!words.contains(str.substring(i, j))) continue;
                ++wordCount;
            }
        }
        return wordCount;
    }
}

