/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstStrLength
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "strlen";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("length() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.lengthCategoricalCol(v) : this.lengthStringCol(v);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec lengthCategoricalCol(Vec vec) {
        Vec res = ((MRTask)new MRTask(){
            transient int[] catLengths;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catLengths = new int[doms.length];
                for (int i = 0; i < doms.length; ++i) {
                    this.catLengths[i] = doms[i].length();
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_nums(chk._len);
                for (int i = 0; i < chk._len; ++i) {
                    if (chk.isNA(i)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catLengths[(int)chk.atd(i)], 0);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec lengthStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk._len; ++i) {
                        newChk.addNA();
                    }
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiLength(newChk);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addNum(chk.atStr(tmpStr, i).toString().length(), 0);
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }
}

