/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.H2OPropertyConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import water.H2O;
import water.api.RequestServer;
import water.util.Timer;

public abstract class Log {
    private static Logger _logger = null;
    static String LOG_DIR = null;
    public static final byte FATAL = 0;
    public static final byte ERRR = 1;
    public static final byte WARN = 2;
    public static final byte INFO = 3;
    public static final byte DEBUG = 4;
    public static final byte TRACE = 5;
    public static final String[] LVLS = new String[]{"FATAL", "ERRR", "WARN", "INFO", "DEBUG", "TRACE"};
    static int _level = 3;
    static boolean _quiet = false;
    private static String _preHeader;
    private static ArrayList<String> INIT_MSGS;

    public static byte valueOf(String slvl) {
        if (slvl == null) {
            return -1;
        }
        if ((slvl = slvl.toLowerCase()).startsWith("fatal")) {
            return 0;
        }
        if (slvl.startsWith("err")) {
            return 1;
        }
        if (slvl.startsWith("warn")) {
            return 2;
        }
        if (slvl.startsWith("info")) {
            return 3;
        }
        if (slvl.startsWith("debug")) {
            return 4;
        }
        if (slvl.startsWith("trace")) {
            return 5;
        }
        return -1;
    }

    public static void init(String slvl, boolean quiet) {
        byte lvl = Log.valueOf(slvl);
        if (lvl != -1) {
            _level = lvl;
        }
        _quiet = quiet;
    }

    public static void trace(Object ... objs) {
        Log.log(5, objs);
    }

    public static void debug(Object ... objs) {
        Log.log(4, objs);
    }

    public static void info(Object ... objs) {
        Log.log(3, objs);
    }

    public static void warn(Object ... objs) {
        Log.log(2, objs);
    }

    public static void err(Object ... objs) {
        Log.log(1, objs);
    }

    public static void err(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        Log.err(sw.toString());
    }

    public static void fatal(Object ... objs) {
        Log.log(0, objs);
    }

    public static void log(int level, Object ... objs) {
        if (_level >= level) {
            Log.write(level, objs);
        }
    }

    public static void httpd(String msg) {
        throw H2O.fail();
    }

    public static void httpd(String method, String uri, int status, long deltaMillis) {
        Logger l = LogManager.getLogger(RequestServer.class);
        String s = String.format("  %-6s  %3d  %6d ms  %s", method, status, deltaMillis, uri);
        l.info((Object)s);
    }

    public static void info(String s, boolean stdout) {
        if (_level >= 3) {
            Log.write0(3, stdout, s);
        }
    }

    public static RuntimeException throwErr(Throwable e) {
        Log.err(e);
        throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static void write(int lvl, Object[] objs) {
        boolean writeToStdout = lvl <= _level;
        Log.write0(lvl, writeToStdout, objs);
    }

    private static void write0(int lvl, boolean stdout, Object[] objs) {
        StringBuilder sb = new StringBuilder();
        for (Object o : objs) {
            sb.append(o);
        }
        String res = sb.toString();
        if (H2O.SELF_ADDRESS == null) {
            INIT_MSGS.add(res);
            return;
        }
        if (INIT_MSGS != null) {
            String host = H2O.SELF_ADDRESS.getHostAddress();
            _preHeader = Log.fixedLength(host + ":" + H2O.API_PORT + " ", 22) + Log.fixedLength(H2O.PID + " ", 6);
            ArrayList<String> bufmsgs = INIT_MSGS;
            INIT_MSGS = null;
            if (bufmsgs != null) {
                for (String s : bufmsgs) {
                    Log.write0(3, true, s);
                }
            }
        }
        Log.write0(lvl, stdout, res);
    }

    private static void write0(int lvl, boolean stdout, String s) {
        StringBuilder sb = new StringBuilder();
        String hdr = Log.header(lvl);
        Log.write0(sb, hdr, s);
        if (stdout && !_quiet) {
            System.out.println(sb);
        }
        Logger l4j = _logger != null ? _logger : Log.createLog4j();
        switch (lvl) {
            case 0: {
                l4j.fatal((Object)sb);
                break;
            }
            case 1: {
                l4j.error((Object)sb);
                break;
            }
            case 2: {
                l4j.warn((Object)sb);
                break;
            }
            case 3: {
                l4j.info((Object)sb);
                break;
            }
            case 4: {
                l4j.debug((Object)sb);
                break;
            }
            case 5: {
                l4j.trace((Object)sb);
                break;
            }
            default: {
                l4j.error((Object)"Invalid log level requested");
                l4j.error((Object)s);
            }
        }
    }

    private static void write0(StringBuilder sb, String hdr, String s) {
        if (s.contains("\n")) {
            for (String s2 : s.split("\n")) {
                Log.write0(sb, hdr, s2);
                sb.append("\n");
            }
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(hdr).append(s);
        }
    }

    private static String header(int lvl) {
        String nowString = Timer.nowAsLogString();
        String s = nowString + " " + _preHeader + " " + Log.fixedLength(Thread.currentThread().getName() + " ", 10) + LVLS[lvl] + ": ";
        return s;
    }

    public static void flushStdout() {
        if (INIT_MSGS != null) {
            for (String s : INIT_MSGS) {
                System.out.println(s);
            }
            INIT_MSGS.clear();
        }
    }

    public static String getLogDir() throws Exception {
        if (LOG_DIR == null) {
            throw new Exception("LOG_DIR not yet defined");
        }
        return LOG_DIR;
    }

    private static String getLogFileNameStem() throws Exception {
        String ip = H2O.SELF_ADDRESS.getHostAddress();
        int port = H2O.API_PORT;
        String portString = Integer.toString(port);
        return "h2o_" + ip + "_" + portString;
    }

    public static String getLogPathFileNameStem() throws Exception {
        if (H2O.SELF_ADDRESS == null) {
            throw new Exception("H2O.SELF_ADDRESS not yet defined");
        }
        String ip = H2O.SELF_ADDRESS.getHostAddress();
        int port = H2O.API_PORT;
        String portString = Integer.toString(port);
        String logFileName = Log.getLogDir() + File.separator + Log.getLogFileNameStem();
        return logFileName;
    }

    public static String getLogFileName(String level) throws Exception {
        String f;
        String string = level;
        int n = -1;
        switch (string.hashCode()) {
            case 110620997: {
                if (!string.equals("trace")) break;
                n = 0;
                break;
            }
            case 95458899: {
                if (!string.equals("debug")) break;
                n = 1;
                break;
            }
            case 3237038: {
                if (!string.equals("info")) break;
                n = 2;
                break;
            }
            case 3641990: {
                if (!string.equals("warn")) break;
                n = 3;
                break;
            }
            case 96784904: {
                if (!string.equals("error")) break;
                n = 4;
                break;
            }
            case 97203460: {
                if (!string.equals("fatal")) break;
                n = 5;
                break;
            }
            case 99616988: {
                if (!string.equals("httpd")) break;
                n = 6;
            }
        }
        switch (n) {
            case 0: {
                f = "-1-trace.log";
                break;
            }
            case 1: {
                f = "-2-debug.log";
                break;
            }
            case 2: {
                f = "-3-info.log";
                break;
            }
            case 3: {
                f = "-4-warn.log";
                break;
            }
            case 4: {
                f = "-5-error.log";
                break;
            }
            case 5: {
                f = "-6-fatal.log";
                break;
            }
            case 6: {
                f = "-httpd.log";
                break;
            }
            default: {
                throw new Exception("Unknown level");
            }
        }
        return Log.getLogFileNameStem() + f;
    }

    private static void setLog4jProperties(String logDir, Properties p) throws Exception {
        LOG_DIR = logDir;
        String logPathFileName = Log.getLogPathFileNameStem();
        String appenders = (new String[]{"TRACE, R6", "TRACE, R5, R6", "TRACE, R4, R5, R6", "TRACE, R3, R4, R5, R6", "TRACE, R2, R3, R4, R5, R6", "TRACE, R1, R2, R3, R4, R5, R6"})[_level];
        p.setProperty("log4j.logger.water.default", appenders);
        p.setProperty("log4j.additivity.water.default", "false");
        p.setProperty("log4j.appender.R1", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R1.Threshold", "TRACE");
        p.setProperty("log4j.appender.R1.File", logPathFileName + "-1-trace.log");
        p.setProperty("log4j.appender.R1.MaxFileSize", "1MB");
        p.setProperty("log4j.appender.R1.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R1.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R1.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.appender.R2", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R2.Threshold", "DEBUG");
        p.setProperty("log4j.appender.R2.File", logPathFileName + "-2-debug.log");
        p.setProperty("log4j.appender.R2.MaxFileSize", "3MB");
        p.setProperty("log4j.appender.R2.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R2.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R2.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.appender.R3", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R3.Threshold", "INFO");
        p.setProperty("log4j.appender.R3.File", logPathFileName + "-3-info.log");
        p.setProperty("log4j.appender.R3.MaxFileSize", "2MB");
        p.setProperty("log4j.appender.R3.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R3.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R3.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.appender.R4", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R4.Threshold", "WARN");
        p.setProperty("log4j.appender.R4.File", logPathFileName + "-4-warn.log");
        p.setProperty("log4j.appender.R4.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R4.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R4.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R4.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.appender.R5", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R5.Threshold", "ERROR");
        p.setProperty("log4j.appender.R5.File", logPathFileName + "-5-error.log");
        p.setProperty("log4j.appender.R5.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R5.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R5.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R5.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.appender.R6", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R6.Threshold", "FATAL");
        p.setProperty("log4j.appender.R6.File", logPathFileName + "-6-fatal.log");
        p.setProperty("log4j.appender.R6.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R6.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R6.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R6.layout.ConversionPattern", "%m%n");
        p.setProperty("log4j.logger.water.api.RequestServer", "TRACE, HTTPD");
        p.setProperty("log4j.additivity.water.api.RequestServer", "false");
        p.setProperty("log4j.appender.HTTPD", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.HTTPD.Threshold", "TRACE");
        p.setProperty("log4j.appender.HTTPD.File", logPathFileName + "-httpd.log");
        p.setProperty("log4j.appender.HTTPD.MaxFileSize", "1MB");
        p.setProperty("log4j.appender.HTTPD.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.HTTPD.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.HTTPD.layout.ConversionPattern", "%d{ISO8601} %m%n");
        p.setProperty("log4j.logger.org.apache.http", "WARN");
        p.setProperty("log4j.logger.com.amazonaws", "WARN");
        p.setProperty("log4j.logger.org.apache.hadoop", "WARN");
        p.setProperty("log4j.logger.org.jets3t.service", "WARN");
        p.setProperty("log4j.logger.org.reflections.Reflections", "ERROR");
        p.setProperty("log4j.logger.com.brsanthu.googleanalytics", "ERROR");
    }

    private static synchronized Logger createLog4j() {
        boolean log4jConfigurationProvided;
        if (_logger != null) {
            return _logger;
        }
        boolean launchedWithHadoopJar = H2O.ARGS.launchedWithHadoopJar();
        String log4jConfiguration = System.getProperty("h2o.log4j.configuration");
        boolean bl = log4jConfigurationProvided = log4jConfiguration != null;
        if (log4jConfigurationProvided) {
            PropertyConfigurator.configure((String)log4jConfiguration);
        } else {
            Properties p = new Properties();
            try {
                File dir;
                if (H2O.ARGS.log_dir != null) {
                    dir = new File(H2O.ARGS.log_dir);
                } else {
                    boolean windowsPath = H2O.ICE_ROOT.toString().matches("^[a-zA-Z]:.*");
                    dir = windowsPath ? new File(H2O.ICE_ROOT.toString()) : (H2O.ICE_ROOT.getScheme() == null || "file".equals(H2O.ICE_ROOT.getScheme()) ? new File(H2O.ICE_ROOT.getPath()) : new File(H2O.DEFAULT_ICE_ROOT()));
                    dir = new File(dir, "h2ologs");
                }
                Log.setLog4jProperties(dir.toString(), p);
            }
            catch (Exception e) {
                System.err.println("ERROR: failed in createLog4j, exiting now.");
                e.printStackTrace();
                H2O.exit(1);
            }
            if (!launchedWithHadoopJar && H2O.haveInheritedLog4jConfiguration()) {
                H2OPropertyConfigurator.configure((Properties)p);
            } else {
                PropertyConfigurator.configure((Properties)p);
            }
        }
        _logger = LogManager.getLogger((String)"water.default");
        return _logger;
    }

    public static String fixedLength(String s, int length) {
        String r = Log.padRight(s, length);
        if (r.length() > length) {
            int a = Math.max(r.length() - length + 1, 0);
            int b = Math.max(a, r.length());
            r = "#" + r.substring(a, b);
        }
        return r;
    }

    static String padRight(String stringToPad, int size) {
        StringBuilder strb = new StringBuilder(stringToPad);
        while (strb.length() < size) {
            if (strb.length() >= size) continue;
            strb.append(' ');
        }
        return strb.toString();
    }

    public static void ignore(Throwable e) {
        Log.ignore(e, "[h2o] Problem ignored: ");
    }

    public static void ignore(Throwable e, String msg) {
        Log.ignore(e, msg, true);
    }

    public static void ignore(Throwable e, String msg, boolean printException) {
        Log.debug(msg + (printException ? e.toString() : ""));
    }

    public static void POST(int n, String s) {
        System.out.println("POST " + n + ": " + s);
    }

    public static void POST(int n, Exception e) {
        if (e.getMessage() != null) {
            Log.POST(n, e.getMessage());
        }
        Log.POST(n, e.toString());
        StackTraceElement[] els = e.getStackTrace();
        for (int i = 0; i < els.length; ++i) {
            Log.POST(n, els[i].toString());
        }
    }

    public static void setQuiet(boolean q) {
        _quiet = q;
    }

    public static boolean getQuiet() {
        return _quiet;
    }

    static {
        INIT_MSGS = new ArrayList();
    }
}

