/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsRegression;
import hex.ModelMojoWriter;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.ToEigenVec;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import hex.genmodel.utils.DistributionFamily;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.joda.time.DateTime;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.Weaver;
import water.api.StreamWriter;
import water.api.StreamingSchema;
import water.api.schemas3.KeyV3;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.C0DChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.IcedHashMap;
import water.util.JCodeGen;
import water.util.LineLimitOutputStreamWrapper;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;
import water.util.SBPrintStream;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class Model<M extends Model<M, P, O>, P extends Parameters, O extends Output>
extends Lockable<M> {
    public P _parms;
    public O _output;
    public String[] _warnings = new String[0];
    public Distribution _dist;
    protected ScoringInfo[] scoringInfo;
    public IcedHashMap<Key, String> _toDelete = new IcedHashMap();

    public double defaultThreshold() {
        if (((Output)this._output).nclasses() != 2 || ((Output)this._output)._training_metrics == null) {
            return 0.5;
        }
        if (((Output)this._output)._validation_metrics != null && ((ModelMetricsBinomial)((Output)this._output)._validation_metrics)._auc != null) {
            return ((ModelMetricsBinomial)((Output)this._output)._validation_metrics)._auc.defaultThreshold();
        }
        if (((ModelMetricsBinomial)((Output)this._output)._training_metrics)._auc != null) {
            return ((ModelMetricsBinomial)((Output)this._output)._training_metrics)._auc.defaultThreshold();
        }
        return 0.5;
    }

    public final boolean isSupervised() {
        return ((Output)this._output).isSupervised();
    }

    public ToEigenVec getToEigenVec() {
        return null;
    }

    public ModelMetrics addModelMetrics(ModelMetrics mm) {
        DKV.put(mm);
        Model.incrementModelMetrics(this._output, mm._key);
        return mm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementModelMetrics(Output out, Key k) {
        Output output = out;
        synchronized (output) {
            for (Key key : out._model_metrics) {
                if (!k.equals(key)) continue;
                return;
            }
            out._model_metrics = Arrays.copyOf(out._model_metrics, out._model_metrics.length + 1);
            out._model_metrics[out._model_metrics.length - 1] = k;
        }
    }

    public void addWarning(String s) {
        this._warnings = Arrays.copyOf(this._warnings, this._warnings.length + 1);
        this._warnings[this._warnings.length - 1] = s;
    }

    protected String[][] scoringDomains() {
        return ((Output)this._output)._domains;
    }

    public ModelMetrics addMetrics(ModelMetrics mm) {
        return this.addModelMetrics(mm);
    }

    public abstract ModelMetrics.MetricBuilder makeMetricBuilder(String[] var1);

    public Model(Key<M> selfKey, P parms, O output) {
        super(selfKey);
        assert (parms != null);
        this._parms = parms;
        this._output = output;
        if (this._output != null) {
            ((Output)this._output).startClock();
        }
        this._dist = this.isSupervised() && ((Output)this._output).nclasses() == 1 ? new Distribution((Parameters)this._parms) : null;
    }

    public double deviance(double w, double y, double f) {
        return this._dist.deviance(w, y, f);
    }

    public ScoringInfo[] scoring_history() {
        return this.scoringInfo;
    }

    public void fillScoringInfo(ScoringInfo scoringInfo) {
        scoringInfo.is_classification = ((Output)this._output).isClassifier();
        scoringInfo.is_autoencoder = ((Output)this._output).isAutoencoder();
        scoringInfo.scored_train = new ScoreKeeper(((Output)this._output)._training_metrics);
        scoringInfo.scored_valid = new ScoreKeeper(((Output)this._output)._validation_metrics);
        scoringInfo.scored_xval = new ScoreKeeper(((Output)this._output)._cross_validation_metrics);
        scoringInfo.validation = ((Output)this._output)._validation_metrics != null;
        boolean bl = scoringInfo.cross_validation = ((Output)this._output)._cross_validation_metrics != null;
        if (((Output)this._output).isBinomialClassifier()) {
            scoringInfo.training_AUC = ((Output)this._output)._training_metrics == null ? null : ((ModelMetricsBinomial)((Output)this._output)._training_metrics)._auc;
            scoringInfo.validation_AUC = ((Output)this._output)._validation_metrics == null ? null : ((ModelMetricsBinomial)((Output)this._output)._validation_metrics)._auc;
        }
    }

    public ScoringInfo last_scored() {
        return this.scoringInfo == null ? null : this.scoringInfo[this.scoringInfo.length - 1];
    }

    public float loss() {
        switch (((Parameters)this._parms)._stopping_metric) {
            case MSE: {
                return (float)this.mse();
            }
            case MAE: {
                return (float)this.mae();
            }
            case RMSLE: {
                return (float)this.rmsle();
            }
            case logloss: {
                return (float)this.logloss();
            }
            case deviance: {
                return (float)this.deviance();
            }
            case misclassification: {
                return (float)this.classification_error();
            }
            case AUC: {
                return (float)(1.0 - this.auc());
            }
            case mean_per_class_error: {
                return (float)this.mean_per_class_error();
            }
            case lift_top_group: {
                return (float)this.lift_top_group();
            }
        }
        return (float)(((Output)this._output).isClassifier() ? this.logloss() : (((Output)this._output).isAutoencoder() ? this.mse() : this.deviance()));
    }

    public int compareTo(M o) {
        if (((Output)((Model)o)._output).isClassifier() != ((Output)this._output).isClassifier()) {
            throw new UnsupportedOperationException("Cannot compare classifier against regressor.");
        }
        if (((Output)((Model)o)._output).isClassifier() && ((Output)((Model)o)._output).nclasses() != ((Output)this._output).nclasses()) {
            throw new UnsupportedOperationException("Cannot compare models with different number of classes.");
        }
        return this.loss() < ((Model)o).loss() ? -1 : (this.loss() > ((Model)o).loss() ? 1 : 0);
    }

    public double classification_error() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._classError : this.last_scored().scored_train._classError;
    }

    public double mse() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._mse : this.last_scored().scored_train._mse;
    }

    public double mae() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._mae : this.last_scored().scored_train._mae;
    }

    public double rmsle() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._rmsle : this.last_scored().scored_train._rmsle;
    }

    public double auc() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._AUC : this.last_scored().scored_train._AUC;
    }

    public double deviance() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._mean_residual_deviance : this.last_scored().scored_train._mean_residual_deviance;
    }

    public double logloss() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._logloss : this.last_scored().scored_train._logloss;
    }

    public double mean_per_class_error() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._mean_per_class_error : this.last_scored().scored_train._mean_per_class_error;
    }

    public double lift_top_group() {
        if (this.scoringInfo == null) {
            return Double.NaN;
        }
        return this.last_scored().validation ? this.last_scored().scored_valid._lift : this.last_scored().scored_train._lift;
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        return Model.adaptTestForTrain(test, ((Output)this._output)._origNames, ((Output)this._output)._origDomains, ((Output)this._output)._names, ((Output)this._output)._domains, this._parms, expensive, computeMetrics, ((Output)this._output).interactions(), this.getToEigenVec(), this._toDelete, false);
    }

    public static String[] adaptTestForTrain(Frame test, String[] origNames, String[][] origDomains, String[] names, String[][] domains, Parameters parms, boolean expensive, boolean computeMetrics, String[] interactions, ToEigenVec tev, IcedHashMap<Key, String> toDelete, boolean catEncoded) throws IllegalArgumentException {
        boolean checkCategoricals;
        String[] msg = new String[]{};
        if (test == null) {
            return msg;
        }
        if (catEncoded && origNames == null) {
            return msg;
        }
        String[][] tdomains = test.domains();
        if (names == test._names && domains == tdomains || Arrays.equals(names, test._names) && Arrays.deepEquals((Object[])domains, (Object[])tdomains)) {
            return msg;
        }
        String[] backupNames = names;
        String[][] backupDomains = domains;
        String weights = parms._weights_column;
        String offset = parms._offset_column;
        String fold = parms._fold_column;
        String response = parms._response_column;
        boolean bl = checkCategoricals = parms._categorical_encoding == Parameters.CategoricalEncodingScheme.OneHotExplicit || parms._categorical_encoding == Parameters.CategoricalEncodingScheme.Eigen || parms._categorical_encoding == Parameters.CategoricalEncodingScheme.Binary;
        if (checkCategoricals && origNames != null) {
            boolean match = Arrays.equals(origNames, test._names);
            if (!match) {
                match = true;
                for (String s : origNames) {
                    if (!(match &= ArrayUtils.contains(test.names(), s))) break;
                }
            }
            if (match) {
                names = origNames;
                domains = origDomains;
            }
        }
        if (null != interactions) {
            int[] interactionIndexes = new int[interactions.length];
            for (int i = 0; i < interactions.length; ++i) {
                interactionIndexes[i] = test.find(interactions[i]);
            }
            test.add(Model.makeInteractions(test, false, InteractionPair.generatePairwiseInteractionsFromList(interactionIndexes), true, true, false));
        }
        double missing = parms.missingColumnsType();
        ArrayList<String> msgs = new ArrayList<String>();
        Vec[] vvecs = new Vec[names.length];
        int good = 0;
        int convNaN = 0;
        for (int i = 0; i < names.length; ++i) {
            boolean isFold;
            Vec vec = test.vec(names[i]);
            boolean isResponse = response != null && names[i].equals(response);
            boolean isWeights = weights != null && names[i].equals(weights);
            boolean isOffset = offset != null && names[i].equals(offset);
            boolean bl2 = isFold = fold != null && names[i].equals(fold);
            if (vec == null) {
                if (isResponse && computeMetrics) {
                    throw new IllegalArgumentException("Test/Validation dataset is missing response column '" + response + "'");
                }
                if (isOffset) {
                    throw new IllegalArgumentException("Test/Validation dataset is missing offset column '" + offset + "'");
                }
                if (isWeights && computeMetrics) {
                    if (expensive) {
                        vec = test.anyVec().makeCon(1.0);
                        toDelete.put(vec._key, "adapted missing vectors");
                        msgs.add(H2O.technote(1, "Test/Validation dataset is missing weights column '" + names[i] + "' (needed because a response was found and metrics are to be computed): substituting in a column of 1s"));
                    }
                } else if (expensive) {
                    String str = "Test/Validation dataset is missing column '" + names[i] + "': substituting in a column of " + (isFold ? 0.0 : missing);
                    vec = test.anyVec().makeCon(isFold ? 0.0 : missing);
                    toDelete.put(vec._key, "adapted missing vectors");
                    if (!isFold) {
                        ++convNaN;
                    }
                    msgs.add(str);
                }
            }
            if (vec != null) {
                if (domains[i] != null) {
                    if (vec.isString()) {
                        vec = VecUtils.stringToCategorical(vec);
                    }
                    if (expensive && vec.domain() != domains[i] && !Arrays.equals(vec.domain(), domains[i])) {
                        CategoricalWrappedVec evec;
                        try {
                            evec = vec.adaptTo(domains[i]);
                            toDelete.put(evec._key, "categorically adapted vec");
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("Test/Validation dataset has a non-categorical column '" + names[i] + "' which is categorical in the training data");
                        }
                        String[] ds = evec.domain();
                        assert (ds != null && ds.length >= domains[i].length);
                        if (isResponse && vec.domain() != null && ds.length == domains[i].length + vec.domain().length) {
                            throw new IllegalArgumentException("Test/Validation dataset has a categorical response column '" + names[i] + "' with no levels in common with the model");
                        }
                        if (ds.length > domains[i].length) {
                            msgs.add("Test/Validation dataset column '" + names[i] + "' has levels not trained on: " + Arrays.toString(Arrays.copyOfRange(ds, domains[i].length, ds.length)));
                        }
                        vec = evec;
                    }
                } else if (vec.isCategorical()) {
                    throw new IllegalArgumentException("Test/Validation dataset has categorical column '" + names[i] + "' which is real-valued in the training data");
                }
                ++good;
            }
            vvecs[i] = vec;
        }
        if (good == names.length || response != null && test.find(response) == -1 && good == names.length - 1) {
            test.restructure(names, vvecs, good);
        }
        boolean haveCategoricalPredictors = false;
        if (expensive && checkCategoricals && !catEncoded) {
            for (int i = 0; i < test.numCols(); ++i) {
                if (test.names()[i].equals(response) || test.names()[i].equals(weights) || test.names()[i].equals(offset) || test.names()[i].equals(fold)) continue;
                if (test.vec(i).cardinality() > 0) {
                    haveCategoricalPredictors = true;
                    break;
                }
                int whichCol = ArrayUtils.find(names, test.name(i));
                if (whichCol < 0 || domains[whichCol] == null) continue;
                haveCategoricalPredictors = true;
                break;
            }
        }
        if (expensive && !catEncoded && haveCategoricalPredictors) {
            Frame updated = FrameUtils.categoricalEncoder(test, new String[]{weights, offset, fold, response}, parms._categorical_encoding, tev);
            toDelete.put(updated._key, "categorically encoded frame");
            test.restructure(updated.names(), updated.vecs());
            String[] msg2 = Model.adaptTestForTrain(test, origNames, origDomains, backupNames, backupDomains, parms, expensive, computeMetrics, interactions, tev, toDelete, true);
            msgs.addAll(Arrays.asList(msg2));
            return msgs.toArray(new String[msgs.size()]);
        }
        if (good == convNaN) {
            throw new IllegalArgumentException("Test/Validation dataset has no columns in common with the training set");
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    public Frame score(Frame fr) throws IllegalArgumentException {
        return this.score(fr, null, null, true);
    }

    public Frame score(Frame fr, String destination_key) throws IllegalArgumentException {
        return this.score(fr, destination_key, null, true);
    }

    public Frame score(Frame fr, String destination_key, Job j) throws IllegalArgumentException {
        return this.score(fr, destination_key, j, true);
    }

    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics) throws IllegalArgumentException {
        Object[] sdomain;
        Vec actual;
        Frame adaptFr = new Frame(fr);
        String[] msg = this.adaptTestForTrain(adaptFr, true, computeMetrics = computeMetrics && (!this.isSupervised() || adaptFr.vec(((Output)this._output).responseName()) != null && !adaptFr.vec(((Output)this._output).responseName()).isBad()));
        if (msg.length > 0) {
            for (String s : msg) {
                Log.warn(s);
            }
        }
        Frame output = this.predictScoreImpl(fr, adaptFr, destination_key, j, computeMetrics);
        Vec predicted = output.vecs()[0];
        Object[] mdomain = predicted.domain();
        if (((Output)this._output).isClassifier() && computeMetrics && (actual = fr.vec(((Output)this._output).responseName())) != null && (sdomain = actual.domain()) != null && mdomain != sdomain && !Arrays.equals(mdomain, sdomain)) {
            output.replace(0, new CategoricalWrappedVec((Key)actual.group().addVec(), actual._rowLayout, (String[])sdomain, predicted._key));
        }
        Model.cleanup_adapt(adaptFr, fr);
        return output;
    }

    public Frame computeDeviances(Frame valid, Frame predictions, String outputName) {
        Distribution myDist;
        assert (((Parameters)this._parms)._response_column != null) : "response column can't be null";
        assert (valid.find(((Parameters)this._parms)._response_column) >= 0) : "validation frame must contain a response column";
        predictions.add(((Parameters)this._parms)._response_column, valid.vec(((Parameters)this._parms)._response_column));
        if (valid.find(((Parameters)this._parms)._weights_column) >= 0) {
            predictions.add(((Parameters)this._parms)._weights_column, valid.vec(((Parameters)this._parms)._weights_column));
        }
        final int respIdx = predictions.find(((Parameters)this._parms)._response_column);
        final int weightIdx = predictions.find(((Parameters)this._parms)._weights_column);
        Distribution distribution = myDist = this._dist == null ? null : IcedUtils.deepCopy(this._dist);
        if (myDist != null && myDist.distribution == DistributionFamily.huber) {
            myDist.setHuberDelta(ModelMetricsRegression.computeHuberDelta(valid.vec(((Parameters)this._parms)._response_column), predictions.vec(0), valid.vec(((Parameters)this._parms)._weights_column), ((Parameters)this._parms)._huber_alpha));
        }
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] nc) {
                Chunk weight = weightIdx >= 0 ? cs[weightIdx] : new C0DChunk(1.0, cs[0]._len);
                Chunk response = cs[respIdx];
                for (int i = 0; i < cs[0]._len; ++i) {
                    double w = weight.atd(i);
                    double y = response.atd(i);
                    if (((Output)Model.this._output).nclasses() == 1) {
                        double f = cs[0].atd(i);
                        if (myDist != null && myDist.distribution == DistributionFamily.huber) {
                            nc[0].addNum(myDist.deviance(w, y, f));
                            continue;
                        }
                        nc[0].addNum(Model.this.deviance(w, y, f));
                        continue;
                    }
                    int iact = (int)y;
                    double err = iact < ((Output)Model.this._output).nclasses() ? 1.0 - cs[1 + iact].atd(i) : 1.0;
                    nc[0].addNum(w * MathUtils.logloss(err));
                }
            }
        }.doAll((byte)3, predictions)).outputFrame(Key.make(outputName), new String[]{"deviance"}, null);
    }

    protected static void cleanup_adapt(Frame adaptFr, Frame fr) {
        Key<Vec>[] keys = adaptFr.keys();
        for (int i = 0; i < keys.length; ++i) {
            if (fr.find(keys[i]) != -1) continue;
            keys[i].remove();
        }
        DKV.remove(adaptFr._key);
    }

    protected String[] makeScoringNames() {
        int nc = ((Output)this._output).nclasses();
        int ncols = nc == 1 ? 1 : nc + 1;
        String[] names = new String[ncols];
        names[0] = "predict";
        for (int i = 1; i < names.length; ++i) {
            names[i] = ((Output)this._output).classNames()[i - 1];
            try {
                Integer.valueOf(names[i]);
                names[i] = "p" + names[i];
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return names;
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics) {
        String[] names = this.makeScoringNames();
        String[][] domains = new String[names.length][];
        domains[0] = names.length == 1 ? null : (!computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        BigScore bs = (BigScore)new BigScore(domains[0], names.length, adaptFrm.means(), ((Output)this._output).hasWeights() && adaptFrm.find(((Output)this._output).weightsName()) >= 0, computeMetrics, true, j).doAll(names.length, (byte)3, adaptFrm);
        if (computeMetrics) {
            bs._mb.makeModelMetrics(this, fr, adaptFrm, bs.outputFrame());
        }
        return bs.outputFrame(Key.make(destination_key), names, domains);
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        boolean computeMetrics = !this.isSupervised() || adaptFrm.vec(((Output)this._output).responseName()) != null && !adaptFrm.vec(((Output)this._output).responseName()).isBad();
        String[] domain = !computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : adaptFrm.lastVec().domain();
        BigScore bs = (BigScore)new BigScore(domain, 0, adaptFrm.means(), ((Output)this._output).hasWeights() && adaptFrm.find(((Output)this._output).weightsName()) >= 0, computeMetrics, false, null).doAll(adaptFrm);
        return bs._mb;
    }

    public double[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
        return this.score0(chks, 1.0, 0.0, row_in_chunk, tmp, preds);
    }

    public double[] score0(Chunk[] chks, double weight, double offset, int row_in_chunk, double[] tmp, double[] preds) {
        assert (((Output)this._output).nfeatures() == tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        double[] scored = this.score0(tmp, preds, weight, offset);
        if (this.isSupervised() && ((Output)this._output).isClassifier()) {
            if (((Parameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])((Output)this._output)._modelClassDist);
            }
            scored[0] = GenModel.getPrediction((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])tmp, (double)this.defaultThreshold());
        }
        return scored;
    }

    protected abstract double[] score0(double[] var1, double[] var2);

    protected double[] score0(double[] data, double[] preds, double weight, double offset) {
        assert (weight == 1.0 && offset == 0.0) : "Override this method for non-trivial weight/offset!";
        return this.score0(data, preds);
    }

    public double score(double[] data) {
        return ArrayUtils.maxIndex(this.score0(data, new double[((Output)this._output).nclasses()]));
    }

    @Override
    protected Futures remove_impl(Futures fs) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key k : ((Output)this._output)._model_metrics) {
                k.remove(fs);
            }
        }
        FrameUtils.cleanUp(this._toDelete);
        return super.remove_impl(fs);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key k : ((Output)this._output)._model_metrics) {
                ab.putKey(k);
            }
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key k : ((Output)this._output)._model_metrics) {
                ab.getKey(k, fs);
            }
        }
        return super.readAll_impl(ab, fs);
    }

    @Override
    protected long checksum_impl() {
        return ((Parameters)this._parms).checksum_impl() * ((Output)this._output).checksum_impl();
    }

    public ModelMojoWriter getMojo() {
        throw H2O.unimpl("MOJO format is not available for " + ((Parameters)this._parms).fullName() + " models.");
    }

    public final String toJava(boolean preview, boolean verboseCode) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(Short.MAX_VALUE);
        this.toJava(os, preview, verboseCode);
        return os.toString();
    }

    public final SBPrintStream toJava(OutputStream os, boolean preview, boolean verboseCode) {
        if (preview) {
            os = new LineLimitOutputStreamWrapper(os, 1000);
        }
        return this.toJava(new SBPrintStream(os), preview, verboseCode);
    }

    protected SBPrintStream toJava(SBPrintStream sb, boolean isGeneratingPreview, boolean verboseCode) {
        CodeGeneratorPipeline fileCtx = new CodeGeneratorPipeline();
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.p("/*").nl();
        sb.p("  Licensed under the Apache License, Version 2.0").nl();
        sb.p("    http://www.apache.org/licenses/LICENSE-2.0.html").nl();
        sb.nl();
        sb.p("  AUTOGENERATED BY H2O at ").p(new DateTime().toString()).nl();
        sb.p("  ").p(H2O.ABV.projectVersion()).nl();
        sb.p("  ").nl();
        sb.p("  Standalone prediction code with sample test data for ").p(this.getClass().getSimpleName()).p(" named ").p(modelName).nl();
        sb.nl();
        sb.p("  How to download, compile and execute:").nl();
        sb.p("      mkdir tmpdir").nl();
        sb.p("      cd tmpdir").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/h2o-genmodel.jar > h2o-genmodel.jar").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/Models.java/").pobj(this._key).p(" > ").p(modelName).p(".java").nl();
        sb.p("      javac -cp h2o-genmodel.jar -J-Xmx2g -J-XX:MaxPermSize=128m ").p(modelName).p(".java").nl();
        sb.nl();
        sb.p("     (Note:  Try java argument -XX:+PrintCompilation to show runtime JIT compiler behavior.)").nl();
        if (((Parameters)this._parms)._offset_column != null) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model export does not support offset_column.").nl();
            sb.nl();
            Log.warn("Java model export does not support offset_column.");
        }
        if (isGeneratingPreview && this.toJavaCheckTooBig()) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model is too large to preview, please download as shown above.").nl();
            sb.nl();
            return sb;
        }
        sb.p("*/").nl();
        sb.p("import java.util.Map;").nl();
        sb.p("import hex.genmodel.GenModel;").nl();
        sb.p("import hex.genmodel.annotations.ModelPojo;").nl();
        sb.nl();
        String algo = this.getClass().getSimpleName().toLowerCase().replace("model", "");
        sb.p("@ModelPojo(name=\"").p(modelName).p("\", algorithm=\"").p(algo).p("\")").nl();
        sb.p("public class ").p(modelName).p(" extends GenModel {").nl().ii(1);
        sb.ip("public hex.ModelCategory getModelCategory() { return hex.ModelCategory." + ((Output)this._output).getModelCategory() + "; }").nl();
        this.toJavaInit(sb, fileCtx).nl();
        this.toJavaNAMES(sb, fileCtx);
        this.toJavaNCLASSES(sb);
        this.toJavaDOMAINS(sb, fileCtx);
        this.toJavaPROB(sb);
        this.toJavaSuper(modelName, sb);
        sb.p("  public String getUUID() { return Long.toString(" + this.checksum() + "L); }").nl();
        this.toJavaPredict(sb, fileCtx, verboseCode);
        sb.p("}").nl().di(1);
        fileCtx.generate(sb);
        sb.nl();
        return sb;
    }

    protected SBPrintStream toJavaSuper(String modelName, SBPrintStream sb) {
        return sb.nl().ip("public " + modelName + "() { super(NAMES,DOMAINS); }").nl();
    }

    private SBPrintStream toJavaNAMES(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        final String namesHolderClassName = "NamesHolder_" + modelName;
        sb.i().p("// ").p("Names of columns used by model.").nl();
        sb.i().p("public static final String[] NAMES = " + namesHolderClassName + ".VALUES;").nl();
        fileCtx.add(new CodeGenerator(){

            @Override
            public void generate(JCodeSB out) {
                out.i().p("// The class representing training column names").nl();
                JCodeGen.toClassWithArray(out, null, namesHolderClassName, Arrays.copyOf(((Output)Model.this._output)._names, ((Output)Model.this._output).nfeatures()));
            }
        });
        return sb;
    }

    protected SBPrintStream toJavaNCLASSES(SBPrintStream sb) {
        return ((Output)this._output).isClassifier() ? JCodeGen.toStaticVar(sb, "NCLASSES", ((Output)this._output).nclasses(), "Number of output classes included in training data response column.") : sb;
    }

    private SBPrintStream toJavaDOMAINS(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.nl();
        sb.ip("// Column domains. The last array contains domain of response column.").nl();
        sb.ip("public static final String[][] DOMAINS = new String[][] {").nl();
        String[][] domains = this.scoringDomains();
        for (int i = 0; i < domains.length; ++i) {
            final int idx = i;
            final String[] dom = domains[i];
            final String colInfoClazz = modelName + "_ColInfo_" + i;
            sb.i(1).p("/* ").p(((Output)this._output)._names[i]).p(" */ ");
            if (dom != null) {
                sb.p(colInfoClazz).p(".VALUES");
            } else {
                sb.p("null");
            }
            if (i != domains.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (dom == null) continue;
            fileCtx.add(new CodeGenerator(){

                @Override
                public void generate(JCodeSB out) {
                    out.ip("// The class representing column ").p(((Output)Model.this._output)._names[idx]).nl();
                    JCodeGen.toClassWithArray(out, null, colInfoClazz, dom);
                }
            });
        }
        return sb.ip("};").nl();
    }

    protected SBPrintStream toJavaPROB(SBPrintStream sb) {
        if (this.isSupervised()) {
            JCodeGen.toStaticVar((JCodeSB)sb, "PRIOR_CLASS_DISTRIB", ((Output)this._output)._priorClassDist, "Prior class distribution");
            JCodeGen.toStaticVar((JCodeSB)sb, "MODEL_CLASS_DISTRIB", ((Output)this._output)._modelClassDist, "Class distribution used for model building");
        }
        return sb;
    }

    protected boolean toJavaCheckTooBig() {
        Log.warn("toJavaCheckTooBig must be overridden for this model type to render it in the browser");
        return true;
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileContext) {
        return sb;
    }

    protected void toJavaPredictBody(SBPrintStream body, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        throw new IllegalArgumentException("This model type does not support conversion to Java");
    }

    private SBPrintStream toJavaPredict(SBPrintStream ccsb, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        ccsb.nl();
        ccsb.ip("// Pass in data in a double[], pre-aligned to the Model's requirements.").nl();
        ccsb.ip("// Jam predictions into the preds[] array; preds[0] is reserved for the").nl();
        ccsb.ip("// main prediction (class for classifiers or value for regression),").nl();
        ccsb.ip("// and remaining columns hold a probability distribution for classifiers.").nl();
        ccsb.ip("public final double[] score0( double[] data, double[] preds ) {").nl();
        CodeGeneratorPipeline classCtx = new CodeGeneratorPipeline();
        this.toJavaPredictBody(ccsb.ii(1), classCtx, fileCtx, verboseCode);
        ccsb.ip("return preds;").nl();
        ccsb.di(1).ip("}").nl();
        classCtx.generate(ccsb.ii(1));
        ccsb.di(1);
        return ccsb;
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon) {
        return this.testJavaScoring(data, model_predictions, rel_epsilon, 1.0E-15, 0.1);
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon, double abs_epsilon) {
        return this.testJavaScoring(data, model_predictions, rel_epsilon, abs_epsilon, 0.1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon, double abs_epsilon, double fraction) {
        mb = ModelBuilder.make(this._parms.algoName().toLowerCase(), null, null);
        havePojo = mb.havePojo();
        haveMojo = mb.haveMojo();
        rnd = RandomUtils.getRNG(new long[]{data.byteSize()});
        if (!Model.$assertionsDisabled && data.numRows() != model_predictions.numRows()) {
            throw new AssertionError();
        }
        fr = new Frame(data);
        computeMetrics = data.vec(this._output.responseName()) != null && data.vec(this._output.responseName()).isBad() == false;
        try {
            warns = this.adaptTestForTrain(fr, true, computeMetrics);
            if (warns.length > 0) {
                System.err.println(Arrays.toString(warns));
            }
            omap = null;
            if (this._output.isClassifier()) {
                actual = fr.vec(this._output.responseName());
                sdomain = actual == null ? null : actual.domain();
                mdomain = model_predictions.vec(0).domain();
                if (sdomain != null && !Arrays.equals(mdomain, sdomain)) {
                    omap = CategoricalWrappedVec.computeMap((String[])mdomain, (String[])sdomain);
                }
            }
            modelName = JCodeGen.toJavaId(this._key.toString());
            preview = false;
            genmodel = null;
            dvecs = fr.vecs();
            pvecs = model_predictions.vecs();
            features = null;
            num_errors = 0;
            num_total = 0;
            if (havePojo) {
                try {
                    java_text = this.toJava(preview, true);
                    clz = JCodeGen.compile(modelName, java_text);
                    genmodel = (GenModel)clz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw H2O.fail("Internal POJO compilation failed", e);
                }
                features = MemoryManager.malloc8d(genmodel._names.length);
                predictions = MemoryManager.malloc8d(genmodel.nclasses() + 1);
                row = 0;
                while ((long)row < fr.numRows()) {
                    if (!(rnd.nextDouble() >= fraction)) {
                        ++num_total;
                        for (col = 0; col < features.length; ++col) {
                            features[col] = dvecs[col].at(row);
                        }
                        genmodel.score0(features, predictions);
                        v0 = col = this._output.isClassifier() != false ? 1 : 0;
                        while (col < pvecs.length) {
                            d = pvecs[col].at(row);
                            if (col == 0 && omap != null) {
                                d = omap[(int)d];
                            }
                            if (!MathUtils.compare(predictions[col], d, abs_epsilon, rel_epsilon)) {
                                if (num_errors++ >= 10) break;
                                System.err.println("Predictions mismatch, row " + row + ", col " + model_predictions._names[col] + ", internal prediction=" + d + ", POJO prediction=" + predictions[col]);
                                break;
                            }
                            ++col;
                        }
                    }
                    ++row;
                }
            }
            for (i = 0; i < 2; ++i) {
                if (i == 0 && !havePojo || i == 1 && !haveMojo) continue;
                if (i == 1) {
                    filename = modelName + ".zip";
                    ss = new StreamingSchema(this.getMojo(), filename);
                    try {
                        os = new FileOutputStream(ss.getFilename());
                        ss.getStreamWriter().writeTo(os);
                        os.close();
                        genmodel = MojoModel.load((String)filename);
                        features = MemoryManager.malloc8d(genmodel._names.length);
                        deleted = new File(filename).delete();
                        ** if (deleted) goto lbl-1000
                    }
                    catch (IOException e1) {
                        try {
                            e1.printStackTrace();
                            throw H2O.fail("Internal MOJO loading failed", e1);
                        }
                        catch (Throwable var30_41) {
                            deleted = new File(filename).delete();
                            if (!deleted) {
                                Log.warn(new Object[]{"Failed to delete the file"});
                            }
                            throw var30_41;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        Log.warn(new Object[]{"Failed to delete the file"});
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                epmw = new EasyPredictModelWrapper(genmodel);
                rowData = new RowData();
                bStr = new BufferedString();
                row = 0;
                while ((long)row < fr.numRows()) {
                    block42: {
                        if (!(rnd.nextDouble() >= fraction) && genmodel.getModelCategory() != ModelCategory.AutoEncoder) {
                            for (col = 0; col < features.length; ++col) {
                                if (dvecs[col].isString()) {
                                    rowData.put((Object)genmodel._names[col], (Object)dvecs[col].atStr(bStr, row).toString());
                                    continue;
                                }
                                val = dvecs[col].at(row);
                                rowData.put((Object)genmodel._names[col], genmodel._domains[col] == null ? Double.valueOf(val) : (Double.isNaN(val) != false ? Double.valueOf(val) : ((int)val < genmodel._domains[col].length ? genmodel._domains[col][(int)val] : "UnknownLevel")));
                            }
                            try {
                                p = epmw.predict(rowData);
                            }
                            catch (PredictException e) {
                                if (++num_errors >= 20) break block42;
                                System.err.println("EasyPredict threw an exception when predicting row " + rowData);
                                e.printStackTrace();
                                break block42;
                            }
                            expected_preds = new double[pvecs.length];
                            actual_preds = new double[pvecs.length];
                            for (col = 0; col < pvecs.length; ++col) {
                                d = pvecs[col].at(row);
                                if (col == 0 && omap != null) {
                                    d = omap[(int)d];
                                }
                                d2 = NaN;
                                switch (4.$SwitchMap$hex$ModelCategory[genmodel.getModelCategory().ordinal()]) {
                                    case 1: {
                                        d2 = ((ClusteringModelPrediction)p).cluster;
                                        break;
                                    }
                                    case 2: {
                                        d2 = ((RegressionModelPrediction)p).value;
                                        break;
                                    }
                                    case 3: {
                                        bmp = (BinomialModelPrediction)p;
                                        d2 = col == 0 ? (double)bmp.labelIndex : bmp.classProbabilities[col - 1];
                                        break;
                                    }
                                    case 4: {
                                        mmp = (MultinomialModelPrediction)p;
                                        d2 = col == 0 ? (double)mmp.labelIndex : mmp.classProbabilities[col - 1];
                                        break;
                                    }
                                    case 5: {
                                        d2 = ((DimReductionModelPrediction)p).dimensions[col];
                                    }
                                }
                                expected_preds[col] = d;
                                actual_preds[col] = d2;
                            }
                            ++num_total;
                            v1 = col = genmodel.isClassifier() != false ? 1 : 0;
                            while (col < pvecs.length) {
                                if (!MathUtils.compare(actual_preds[col], expected_preds[col], abs_epsilon, rel_epsilon)) {
                                    if (++num_errors >= 20) break;
                                    System.err.println((i == 0 ? "POJO" : "MOJO") + " EasyPredict Predictions mismatch for row " + rowData);
                                    System.err.println("  Expected predictions: " + Arrays.toString(expected_preds));
                                    System.err.println("  Actual predictions:   " + Arrays.toString(actual_preds));
                                    break;
                                }
                                ++col;
                            }
                        }
                    }
                    ++row;
                }
            }
            if (num_errors != 0) {
                System.err.println("Number of errors: " + num_errors + (num_errors > 20 ? " (only first 20 are shown)" : "") + " out of " + num_total + " rows tested.");
            }
            var25_25 = num_errors == 0;
            return var25_25;
        }
        finally {
            Model.cleanup_adapt(fr, data);
        }
    }

    public void deleteCrossValidationModels() {
        if (((Output)this._output)._cross_validation_models != null) {
            for (Key k : ((Output)this._output)._cross_validation_models) {
                Model m = (Model)DKV.getGet(k);
                if (m == null) continue;
                m.delete();
            }
        }
    }

    public String toString() {
        return ((Output)this._output).toString();
    }

    @Override
    public Class<KeyV3.ModelKeyV3> makeSchema() {
        return KeyV3.ModelKeyV3.class;
    }

    public static Frame makeInteractions(Frame fr, boolean valid, InteractionPair[] interactions, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyTrainVec = fr.anyVec();
        Vec[] interactionVecs = new Vec[interactions.length];
        String[] interactionNames = new String[interactions.length];
        int idx = 0;
        for (InteractionPair ip : interactions) {
            interactionNames[idx] = fr.name(ip._v1) + "_" + fr.name(ip._v2);
            InteractionWrappedVec iwv = new InteractionWrappedVec(anyTrainVec.group().addVec(), anyTrainVec._rowLayout, ip._v1Enums, ip._v2Enums, useAllFactorLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
            interactionVecs[idx++] = iwv;
        }
        return new Frame(interactionNames, interactionVecs);
    }

    public static InteractionWrappedVec[] makeInteractions(Frame fr, InteractionPair[] interactions, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyTrainVec = fr.anyVec();
        InteractionWrappedVec[] interactionVecs = new InteractionWrappedVec[interactions.length];
        int idx = 0;
        for (InteractionPair ip : interactions) {
            interactionVecs[idx++] = new InteractionWrappedVec(anyTrainVec.group().addVec(), anyTrainVec._rowLayout, ip._v1Enums, ip._v2Enums, useAllFactorLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
        }
        return interactionVecs;
    }

    public static InteractionWrappedVec makeInteraction(Frame fr, InteractionPair ip, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyVec = fr.anyVec();
        return new InteractionWrappedVec(anyVec.group().addVec(), anyVec._rowLayout, ip._v1Enums, ip._v2Enums, useAllFactorLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
    }

    public static class InteractionPair
    extends Iced {
        public int vecIdx;
        private int _v1;
        private int _v2;
        private String[] _domain;
        private String[] _v1Enums;
        private String[] _v2Enums;
        private int _hash;
        private int _p;
        private String _str;

        private InteractionPair() {
        }

        private InteractionPair(int v1, int v2, String[] v1Enums, String[] v2Enums) {
            this._v1 = v1;
            this._v2 = v2;
            this._v1Enums = v1Enums;
            this._v2Enums = v2Enums;
            this._hash = 17;
            this._hash = 31 * this._hash + this._v1;
            this._hash = 31 * this._hash + this._v2;
            if (this._v1Enums == null) {
                this._hash = 31 * this._hash;
            } else {
                for (String s : this._v1Enums) {
                    this._hash = 31 * this._hash + s.hashCode();
                }
            }
            if (this._v2Enums == null) {
                this._hash = 31 * this._hash;
            } else {
                for (String s : this._v2Enums) {
                    this._hash = 31 * this._hash + s.hashCode();
                }
            }
        }

        public static InteractionPair[] generatePairwiseInteractions(int from, int to) {
            if (1 == to - from) {
                throw new IllegalArgumentException("Illegal range of values, must be greater than a single value. Got: " + from + "<" + to);
            }
            InteractionPair[] res = new InteractionPair[(to - from - 1) * (to - from) >> 1];
            int idx = 0;
            for (int i = from; i < to; ++i) {
                for (int j = i + 1; j < to; ++j) {
                    res[idx++] = new InteractionPair(i, j, null, null);
                }
            }
            return res;
        }

        public static InteractionPair[] generatePairwiseInteractionsFromList(int ... indexes) {
            if (null == indexes) {
                return null;
            }
            if (indexes.length < 2) {
                if (indexes.length == 1 && indexes[0] == -1) {
                    return null;
                }
                throw new IllegalArgumentException("Must supply 2 or more columns.");
            }
            InteractionPair[] res = new InteractionPair[(indexes.length - 1) * indexes.length >> 1];
            int idx = 0;
            for (int i = 0; i < indexes.length; ++i) {
                for (int j = i + 1; j < indexes.length; ++j) {
                    res[idx++] = new InteractionPair(indexes[i], indexes[j], null, null);
                }
            }
            return res;
        }

        public void setDomain(String[] dom) {
            this._domain = dom;
        }

        public static int isInteraction(int i, InteractionPair[] ips) {
            int idx = 0;
            for (InteractionPair ip : ips) {
                if (i == ip.vecIdx) {
                    return idx;
                }
                ++idx;
            }
            return -1;
        }

        public static InteractionPair[] read(String interaction) {
            String[] interactions = interaction.split("\n");
            HashSet<InteractionPair> res = new HashSet<InteractionPair>();
            for (String i : interactions) {
                res.addAll(new InteractionPair().parse(i));
            }
            return res.toArray(new InteractionPair[res.size()]);
        }

        private HashSet<InteractionPair> parse(String i) {
            this._p = 0;
            this._str = i;
            HashSet<InteractionPair> res = new HashSet<InteractionPair>();
            int v1 = this.parseNum();
            String[] v1Enums = this.parseEnums();
            if (i.charAt(this._p) != ':' || this._p >= i.length()) {
                throw new IllegalArgumentException("Error");
            }
            while (this._p++ < i.length()) {
                int v2 = this.parseNum();
                String[] v2Enums = this.parseEnums();
                if (v1 == v2) continue;
                res.add(new InteractionPair(v1, v2, v1Enums, v2Enums));
            }
            return res;
        }

        private int parseNum() {
            int start = this._p++;
            while (this._p < this._str.length() && '0' <= this._str.charAt(this._p) && this._str.charAt(this._p) <= '9') {
                ++this._p;
            }
            try {
                return Integer.valueOf(this._str.substring(start, this._p));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("No number could be parsed. Interaction: " + this._str);
            }
        }

        private String[] parseEnums() {
            if (this._p >= this._str.length() || this._str.charAt(this._p) != '[') {
                return null;
            }
            ArrayList<String> enums = new ArrayList<String>();
            while (this._str.charAt(this._p++) != ']') {
                int start;
                ++this._p;
                while (this._str.charAt(this._p) != ',' && this._str.charAt(this._p) != ']') {
                    ++this._p;
                }
                enums.add(this._str.substring(start, this._p));
            }
            return enums.toArray(new String[enums.size()]);
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return this._v1 + (this._v1Enums == null ? "" : Arrays.toString(this._v1Enums)) + ":" + this._v2 + (this._v2Enums == null ? "" : Arrays.toString(this._v2Enums));
        }

        public boolean equals(Object o) {
            boolean res = o instanceof InteractionPair;
            if (res) {
                InteractionPair ip = (InteractionPair)o;
                return this._v1 == ip._v1 && this._v2 == ip._v2 && Arrays.equals(this._v1Enums, ip._v1Enums) && Arrays.equals(this._v2Enums, ip._v2Enums);
            }
            return false;
        }
    }

    public class JavaModelStreamWriter
    extends StreamWriter {
        private final boolean preview;

        public JavaModelStreamWriter(boolean preview) {
            this.preview = preview;
        }

        @Override
        public void writeTo(OutputStream os) {
            Model.this.toJava(os, this.preview, true);
        }
    }

    protected class BigScore
    extends MRTask<BigScore> {
        protected final String[] _domain;
        protected final int _npredcols;
        public ModelMetrics.MetricBuilder _mb;
        final double[] _mean;
        public final boolean _computeMetrics;
        public final boolean _hasWeights;
        public final boolean _makePreds;
        public final Job _j;

        public BigScore(String[] domain, int ncols, double[] mean, boolean testHasWeights, boolean computeMetrics, boolean makePreds, Job j) {
            this._j = j;
            this._domain = domain;
            this._npredcols = ncols;
            this._mean = mean;
            this._computeMetrics = computeMetrics;
            this._makePreds = makePreds;
            if (((Output)Model.this._output)._hasWeights && this._computeMetrics && !testHasWeights) {
                throw new IllegalArgumentException("Missing weights when computing validation metrics.");
            }
            this._hasWeights = testHasWeights;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] cpreds) {
            if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                return;
            }
            Chunk weightsChunk = this._hasWeights && this._computeMetrics ? chks[((Output)Model.this._output).weightsIdx()] : null;
            Chunk offsetChunk = ((Output)Model.this._output).hasOffset() ? chks[((Output)Model.this._output).offsetIdx()] : null;
            Chunk responseChunk = null;
            double[] tmp = new double[((Output)Model.this._output).nfeatures()];
            float[] actual = null;
            this._mb = Model.this.makeMetricBuilder(this._domain);
            if (this._computeMetrics) {
                if (Model.this.isSupervised()) {
                    actual = new float[1];
                    responseChunk = chks[((Output)Model.this._output).responseIdx()];
                } else {
                    actual = new float[chks.length];
                }
            }
            double[] preds = this._mb._work;
            int len = chks[0]._len;
            for (int row = 0; row < len; ++row) {
                double weight;
                double d = weight = weightsChunk != null ? weightsChunk.atd(row) : 1.0;
                if (weight == 0.0) {
                    if (!this._makePreds) continue;
                    for (int c = 0; c < this._npredcols; ++c) {
                        cpreds[c].addNum(0.0);
                    }
                    continue;
                }
                double offset = offsetChunk != null ? offsetChunk.atd(row) : 0.0;
                double[] p = Model.this.score0(chks, weight, offset, row, tmp, preds);
                if (this._computeMetrics) {
                    if (Model.this.isSupervised()) {
                        actual[0] = (float)responseChunk.atd(row);
                    } else {
                        for (int i = 0; i < actual.length; ++i) {
                            actual[i] = (float)chks[i].atd(row);
                        }
                    }
                    this._mb.perRow(preds, actual, weight, offset, Model.this);
                }
                if (!this._makePreds) continue;
                for (int c = 0; c < this._npredcols; ++c) {
                    cpreds[c].addNum(p[c]);
                }
            }
            if (this._j != null) {
                this._j.update(1L);
            }
        }

        @Override
        public void reduce(BigScore bs) {
            if (this._mb != null) {
                this._mb.reduce(bs._mb);
            }
        }

        @Override
        protected void postGlobal() {
            if (this._mb != null) {
                this._mb.postGlobal();
            }
        }
    }

    public static abstract class Output
    extends Iced {
        public String[] _names;
        public String[] _origNames;
        public String[][] _domains;
        public String[][] _origDomains;
        public Key[] _cross_validation_models;
        public Key[] _cross_validation_predictions;
        public Key<Frame> _cross_validation_holdout_predictions_frame_id;
        public Key<Frame> _cross_validation_fold_assignment_frame_id;
        public long _start_time;
        public long _end_time;
        public long _run_time;
        Key[] _model_metrics = new Key[0];
        public Job _job;
        public ModelMetrics _training_metrics;
        public ModelMetrics _validation_metrics;
        public ModelMetrics _cross_validation_metrics;
        public TwoDimTable _cross_validation_metrics_summary;
        public TwoDimTable _model_summary;
        public TwoDimTable _scoring_history;
        public double[] _distribution;
        public double[] _modelClassDist;
        public double[] _priorClassDist;
        protected boolean _isSupervised;
        protected final boolean _hasOffset;
        protected final boolean _hasWeights;
        protected final boolean _hasFold;

        protected void startClock() {
            this._start_time = System.currentTimeMillis();
        }

        protected void stopClock() {
            this._end_time = System.currentTimeMillis();
            this._run_time = this._end_time - this._start_time;
        }

        public Output() {
            this(false, false, false);
        }

        public Output(boolean hasWeights, boolean hasOffset, boolean hasFold) {
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
            this._hasFold = hasFold;
        }

        public Output(ModelBuilder b) {
            this._isSupervised = b.isSupervised();
            if (b.error_count() > 0) {
                throw new IllegalArgumentException(b.validationErrors());
            }
            this._names = b._train.names();
            this._domains = b._train.domains();
            this._origNames = b._origNames;
            this._origDomains = b._origDomains;
            this._hasOffset = b.hasOffsetCol();
            this._hasWeights = b.hasWeightCol();
            this._hasFold = b.hasFoldCol();
            this._distribution = b._distribution;
            this._priorClassDist = b._priorClassDist;
            assert (this._job == null);
        }

        public int nfeatures() {
            return this._names.length - (this._hasOffset ? 1 : 0) - (this._hasWeights ? 1 : 0) - (this._hasFold ? 1 : 0) - (this.isSupervised() ? 1 : 0);
        }

        public boolean isSupervised() {
            return this._isSupervised;
        }

        public boolean hasOffset() {
            return this._hasOffset;
        }

        public boolean hasWeights() {
            return this._hasWeights;
        }

        public boolean hasFold() {
            return this._hasFold;
        }

        public String responseName() {
            return this.isSupervised() ? this._names[this.responseIdx()] : null;
        }

        public String weightsName() {
            return this._hasWeights ? this._names[this.weightsIdx()] : null;
        }

        public String offsetName() {
            return this._hasOffset ? this._names[this.offsetIdx()] : null;
        }

        public String foldName() {
            return this._hasFold ? this._names[this.foldIdx()] : null;
        }

        public String[] interactions() {
            return null;
        }

        public int weightsIdx() {
            if (!this._hasWeights) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - (this.hasOffset() ? 1 : 0) - 1 - (this.hasFold() ? 1 : 0);
        }

        public int offsetIdx() {
            if (!this._hasOffset) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - (this.hasFold() ? 1 : 0) - 1;
        }

        public int foldIdx() {
            if (!this._hasFold) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - 1;
        }

        public int responseIdx() {
            if (!this.isSupervised()) {
                return -1;
            }
            return this._names.length - 1;
        }

        public String[] classNames() {
            if (this._domains == null || this._domains.length == 0 || !this.isSupervised()) {
                return null;
            }
            return this._domains[this._domains.length - 1];
        }

        public boolean isClassifier() {
            return this.isSupervised() && this.nclasses() > 1;
        }

        public boolean isBinomialClassifier() {
            return this.isSupervised() && this.nclasses() == 2;
        }

        public int nclasses() {
            String[] cns = this.classNames();
            return cns == null ? 1 : cns.length;
        }

        public ModelCategory getModelCategory() {
            if (this.isSupervised()) {
                return this.isClassifier() ? (this.nclasses() > 2 ? ModelCategory.Multinomial : ModelCategory.Binomial) : ModelCategory.Regression;
            }
            return ModelCategory.Unknown;
        }

        public boolean isAutoencoder() {
            return false;
        }

        public synchronized void clearModelMetrics() {
            this._model_metrics = new Key[0];
        }

        protected long checksum_impl() {
            return (null == this._names ? 13 : Arrays.hashCode(this._names)) * (null == this._domains ? 17 : Arrays.deepHashCode((Object[])this._domains)) * this.getModelCategory().ordinal();
        }

        public void printTwoDimTables(StringBuilder sb, Object o) {
            for (Field f : Weaver.getWovenFields(o.getClass())) {
                Class<TwoDimTable> c = f.getType();
                if (!c.isAssignableFrom(TwoDimTable.class)) continue;
                try {
                    TwoDimTable t = (TwoDimTable)f.get(this);
                    f.setAccessible(true);
                    if (t == null) continue;
                    sb.append(t.toString(1, false));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._training_metrics != null) {
                sb.append(this._training_metrics.toString());
            }
            if (this._validation_metrics != null) {
                sb.append(this._validation_metrics.toString());
            }
            if (this._cross_validation_metrics != null) {
                sb.append(this._cross_validation_metrics.toString());
            }
            this.printTwoDimTables(sb, this);
            return sb.toString();
        }
    }

    public static abstract class Parameters
    extends Iced<Parameters> {
        public static final int MAX_SUPPORTED_LEVELS = 0x100000;
        public Key<Frame> _train;
        public Key<Frame> _valid;
        public int _nfolds = 0;
        public boolean _keep_cross_validation_predictions = false;
        public boolean _keep_cross_validation_fold_assignment = false;
        public boolean _parallelize_cross_validation = true;
        public boolean _auto_rebalance = true;
        public long _seed = -1L;
        public FoldAssignmentScheme _fold_assignment = FoldAssignmentScheme.AUTO;
        public CategoricalEncodingScheme _categorical_encoding = CategoricalEncodingScheme.AUTO;
        public DistributionFamily _distribution = DistributionFamily.AUTO;
        public double _tweedie_power = 1.5;
        public double _quantile_alpha = 0.5;
        public double _huber_alpha = 0.9;
        public String[] _ignored_columns;
        public boolean _ignore_const_cols;
        public String _weights_column;
        public String _offset_column;
        public String _fold_column;
        public boolean _is_cv_model;
        public boolean _score_each_iteration;
        public double _max_runtime_secs = 0.0;
        public int _stopping_rounds = 0;
        public ScoreKeeper.StoppingMetric _stopping_metric = ScoreKeeper.StoppingMetric.AUTO;
        public double _stopping_tolerance = this.defaultStoppingTolerance();
        public String _response_column;
        public boolean _balance_classes = false;
        public float _max_after_balance_size = 5.0f;
        public float[] _class_sampling_factors;
        public int _max_confusion_matrix_size = 20;
        public Key<? extends Model> _checkpoint;
        public Key<? extends Model> _pretrained_autoencoder;

        public abstract String algoName();

        public abstract String fullName();

        public abstract String javaName();

        protected double defaultStoppingTolerance() {
            return 0.001;
        }

        public abstract long progressUnits();

        public long getOrMakeRealSeed() {
            while (this._seed == -1L) {
                this._seed = RandomUtils.getRNG(System.nanoTime()).nextLong();
                Log.debug("Auto-generated time-based seed for pseudo-random number generator (because it was set to -1): " + this._seed);
            }
            return this._seed;
        }

        public Parameters() {
            this._ignore_const_cols = this.defaultDropConsCols();
        }

        public final Frame train() {
            return this._train == null ? null : this._train.get();
        }

        public final Frame valid() {
            return this._valid == null ? null : this._valid.get();
        }

        public void read_lock_frames(Job job) {
            Frame tr = this.train();
            if (tr != null) {
                tr.read_lock(job._key);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this._valid.get().read_lock(job._key);
            }
        }

        public void read_unlock_frames(Job job) {
            Frame tr = this.train();
            if (tr != null) {
                tr.unlock(job._key, false);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this.valid().unlock(job._key, false);
            }
        }

        protected boolean defaultDropConsCols() {
            return true;
        }

        public double missingColumnsType() {
            return Double.NaN;
        }

        public boolean hasCheckpoint() {
            return this._checkpoint != null;
        }

        public long checksum() {
            return this.checksum_impl();
        }

        protected long checksum_impl() {
            long xs = 24589L;
            int count = 0;
            Field[] fields = Weaver.getWovenFields(this.getClass());
            Arrays.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field field1, Field field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (Field f : fields) {
                long P = MathUtils.PRIMES[count % MathUtils.PRIMES.length];
                Class<?> c = f.getType();
                if (c.isArray()) {
                    try {
                        f.setAccessible(true);
                        if (f.get(this) != null) {
                            Object[] arr;
                            if (c.getComponentType() == Integer.TYPE) {
                                arr = (int[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode(arr);
                            }
                            if (c.getComponentType() == Float.TYPE) {
                                arr = (float[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((float[])arr);
                            }
                            if (c.getComponentType() == Double.TYPE) {
                                arr = (double[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((double[])arr);
                            }
                            if (c.getComponentType() == Long.TYPE) {
                                arr = (long[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((long[])arr);
                            }
                            arr = (Object[])f.get(this);
                            xs = xs * P + (long)Arrays.deepHashCode(arr);
                        }
                        xs *= P;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassCastException t) {
                        throw H2O.fail();
                    }
                } else {
                    try {
                        f.setAccessible(true);
                        Object value = f.get(this);
                        xs = value != null ? xs * P + (long)value.hashCode() : xs * P + P;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++count;
            }
            return xs ^= (this.train() == null ? 43L : this.train().checksum()) * (this.valid() == null ? 17L : this.valid().checksum());
        }

        public static enum CategoricalEncodingScheme {
            AUTO,
            OneHotInternal,
            OneHotExplicit,
            Enum,
            Binary,
            Eigen;

        }

        public static enum FoldAssignmentScheme {
            AUTO,
            Random,
            Modulo,
            Stratified;

        }
    }

    public static interface GetMostImportantFeatures {
        public String[] getMostImportantFeatures(int var1);
    }

    public static interface ExemplarMembers {
        public Frame scoreExemplarMembers(Key<Frame> var1, int var2);
    }

    public static interface LeafNodeAssignment {
        public Frame scoreLeafNodeAssignment(Frame var1, Key<Frame> var2);
    }

    public static interface GLRMArchetypes {
        public Frame scoreReconstruction(Frame var1, Key<Frame> var2, boolean var3);

        public Frame scoreArchetypes(Frame var1, Key<Frame> var2, boolean var3);
    }

    public static interface DeepFeatures {
        public Frame scoreAutoEncoder(Frame var1, Key var2, boolean var3);

        public Frame scoreDeepFeatures(Frame var1, int var2);

        public Frame scoreDeepFeatures(Frame var1, int var2, Job var3);
    }
}

