/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe;

import hex.createframe.CreateFrameColumnMaker;
import hex.createframe.CreateFramePostprocessStep;
import java.util.ArrayList;
import java.util.Random;
import water.DKV;
import water.H2O;
import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.RandomUtils;

public class CreateFrameExecutor
extends H2O.H2OCountedCompleter<CreateFrameExecutor> {
    private Job<Frame> job;
    private ArrayList<CreateFrameColumnMaker> columnMakers;
    private ArrayList<CreateFramePostprocessStep> postprocessSteps;
    private int workAmountPerRow;
    private int workAmountPostprocess;
    private float bytesPerRow;
    private int numRows;
    private int numCols;
    private long seed;

    public CreateFrameExecutor(Job<Frame> job) {
        this.job = job;
        this.columnMakers = new ArrayList(10);
        this.postprocessSteps = new ArrayList(2);
        this.seed = -1L;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    public void setSeed(long s) {
        this.seed = s;
    }

    public void addColumnMaker(CreateFrameColumnMaker maker) {
        maker.setIndex(this.numCols);
        this.columnMakers.add(maker);
        this.workAmountPerRow += maker.workAmount();
        this.bytesPerRow += maker.byteSizePerRow();
        this.numCols += maker.numColumns();
    }

    public void addPostprocessStep(CreateFramePostprocessStep step) {
        this.postprocessSteps.add(step);
        this.workAmountPostprocess += step.workAmount();
    }

    public int workAmount() {
        return this.numRows * this.workAmountPerRow + this.workAmountPostprocess;
    }

    public long estimatedByteSize() {
        return (long)((float)this.numRows * this.bytesPerRow);
    }

    @Override
    public void compute2() {
        int logRowsPerChunk = (int)Math.ceil(Math.log1p(this.rowsPerChunk()));
        Vec dummyVec = Vec.makeCon(0.0, this.numRows, logRowsPerChunk, false);
        if (this.seed == -1L) {
            this.seed = Double.doubleToLongBits(Math.random());
        }
        byte[] types = new byte[this.numCols];
        String[] names = new String[this.numCols];
        String[][] domains = new String[this.numCols][];
        int i = 0;
        for (CreateFrameColumnMaker maker : this.columnMakers) {
            int it = 0;
            int in = 0;
            int id = 0;
            for (byte t : maker.columnTypes()) {
                types[i + it++] = t;
            }
            for (String n : maker.columnNames()) {
                names[i + in++] = n;
            }
            String[][] stringArray = maker.columnDomains();
            if (stringArray != null) {
                for (String[] d : stringArray) {
                    domains[i + id++] = d;
                }
            }
            assert (in == it && (id == it || id == 0) && it == maker.numColumns());
            i += it;
        }
        Frame out = ((ActualFrameCreator)new ActualFrameCreator(this.columnMakers, this.seed, this.job).doAll(types, dummyVec)).outputFrame(this.job._result, names, domains);
        Random rng = RandomUtils.getRNG(this.seed + 40245345791L);
        rng.setSeed(rng.nextLong());
        for (CreateFramePostprocessStep step : this.postprocessSteps) {
            long nextSeed = rng.nextLong();
            step.exec(out, rng);
            rng.setSeed(nextSeed);
            this.job.update(step.workAmount());
        }
        DKV.put(out);
        dummyVec.remove();
        this.tryComplete();
    }

    private int rowsPerChunk() {
        return FileVec.calcOptimalChunkSize(this.estimatedByteSize(), this.numCols, this.numCols * 4, Runtime.getRuntime().availableProcessors(), H2O.getCloudSize(), false, false);
    }

    private static class ActualFrameCreator
    extends MRTask<ActualFrameCreator> {
        private long seed;
        private ArrayList<CreateFrameColumnMaker> columnMakers;
        private Job<Frame> job;

        public ActualFrameCreator(ArrayList<CreateFrameColumnMaker> columnMakers, long seed, Job<Frame> job) {
            this.columnMakers = columnMakers;
            this.seed = seed;
            this.job = job;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            if (this.job.stop_requested()) {
                return;
            }
            int numRowsInChunk = cs[0]._len;
            long chunkPosition = cs[0].start();
            Random rng = RandomUtils.getRNG(0L);
            long taskIndex = 0L;
            for (CreateFrameColumnMaker colTask : this.columnMakers) {
                rng.setSeed(this.seed + chunkPosition * 138457623L + taskIndex++ * 967058L);
                rng.setSeed(rng.nextLong());
                colTask.exec(numRowsInChunk, ncs, rng);
                this.job.update(colTask.workAmount());
            }
        }
    }
}

