/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.postprocess;

import hex.createframe.CreateFramePostprocessStep;
import java.util.HashMap;
import java.util.Random;
import water.DKV;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class ShuffleColumnsCfps
extends CreateFramePostprocessStep {
    private boolean reassignNames;
    private boolean responseFirst;

    public ShuffleColumnsCfps() {
    }

    public ShuffleColumnsCfps(boolean reassignNames, boolean responseFirst) {
        this.reassignNames = reassignNames;
        this.responseFirst = responseFirst;
    }

    @Override
    public void exec(Frame fr, Random rng) {
        int numCols = fr.numCols();
        int[] idx = ArrayUtils.seq(0, numCols);
        ArrayUtils.shuffleArray(idx, rng);
        if (this.responseFirst) {
            int responseIndex = ArrayUtils.find(fr.names(), "response");
            if (responseIndex == -1) {
                responseIndex = ArrayUtils.find(fr.names(), "Response");
            }
            if (responseIndex >= 0) {
                int shuffledIndex = ArrayUtils.find(idx, responseIndex);
                idx[shuffledIndex] = idx[0];
                idx[0] = responseIndex;
            }
        }
        Vec[] newVecs = new Vec[numCols];
        String[] newNames = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            newVecs[i] = fr.vec(idx[i]);
            newNames[i] = fr.name(idx[i]);
        }
        if (this.reassignNames) {
            HashMap<String, Integer> prefixCounts = new HashMap<String, Integer>();
            for (int i = 0; i < numCols; ++i) {
                String prefix = ShuffleColumnsCfps.removeNumericSuffix(newNames[i]);
                int count = prefixCounts.containsKey(prefix) ? (Integer)prefixCounts.get(prefix) + 1 : 1;
                prefixCounts.put(prefix, count);
                if (newNames[i].equals("response")) continue;
                newNames[i] = prefix + count;
            }
        }
        fr.restructure(newNames, newVecs);
        DKV.put(fr);
    }

    public static String removeNumericSuffix(String name) {
        char ch;
        int i = name.length();
        while (--i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9') {
        }
        return name.substring(0, i + 1);
    }
}

