/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.recipes;

import hex.createframe.CreateFrameExecutor;
import hex.createframe.columns.BinaryColumnCfcm;
import hex.createframe.columns.CategoricalColumnCfcm;
import hex.createframe.columns.IntegerColumnCfcm;
import hex.createframe.columns.RealColumnCfcm;
import hex.createframe.columns.StringColumnCfcm;
import hex.createframe.columns.TimeColumnCfcm;
import hex.createframe.postprocess.MissingInserterCfps;
import hex.createframe.postprocess.ShuffleColumnsCfps;
import java.util.Random;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.Log;

public class OriginalCreateFrameRecipe
extends Iced<OriginalCreateFrameRecipe> {
    private Key<Frame> dest;
    private int rows = 10000;
    private int cols = 10;
    private long seed = -1L;
    private double real_range = 100.0;
    private double categorical_fraction = 0.2;
    private int factors = 100;
    private boolean randomize = true;
    private long value = 0L;
    private double integer_fraction = 0.2;
    private double time_fraction = 0.0;
    private double string_fraction = 0.0;
    private int integer_range = 100;
    private double binary_fraction = 0.1;
    private double binary_ones_fraction = 0.02;
    private double missing_fraction = 0.01;
    private int response_factors = 2;
    private boolean positive_response = false;
    private boolean has_response = false;

    public OriginalCreateFrameRecipe(Key<Frame> key) {
        this.dest = key;
    }

    public OriginalCreateFrameRecipe() {
        this.dest = Key.make();
    }

    public Job<Frame> exec() {
        Job<Frame> job = new Job<Frame>(this.dest, Frame.class.getName(), "CreateFrame:original");
        CreateFrameExecutor cfe = new CreateFrameExecutor(job);
        this.fillMissingParameters();
        this.checkParametersValidity();
        this.buildRecipe(cfe);
        this.checkParametersValidity2(cfe);
        return job.start(cfe, cfe.workAmount());
    }

    private void fillMissingParameters() {
        if (this.seed == -1L) {
            this.seed = new Random().nextLong();
            Log.info("Generated seed: " + this.seed);
        }
    }

    private void checkParametersValidity() {
        double total_fraction = this.integer_fraction + this.binary_fraction + this.categorical_fraction + this.time_fraction + this.string_fraction;
        this.check(total_fraction < 1.00000001, "Integer, binary, categorical, time and string fractions must add up to <= 1");
        this.check(this.missing_fraction >= 0.0 && this.missing_fraction < 1.0, "Missing fraction must be between 0 and 1");
        this.check(this.integer_fraction >= 0.0 && this.integer_fraction <= 1.0, "Integer fraction must be between 0 and 1");
        this.check(this.binary_fraction >= 0.0 && this.binary_fraction <= 1.0, "Binary fraction must be between 0 and 1");
        this.check(this.time_fraction >= 0.0 && this.time_fraction <= 1.0, "Time fraction must be between 0 and 1");
        this.check(this.string_fraction >= 0.0 && this.string_fraction <= 1.0, "String fraction must be between 0 and 1");
        this.check(this.binary_ones_fraction >= 0.0 && this.binary_ones_fraction <= 1.0, "Binary ones fraction must be between 0 and 1");
        this.check(this.categorical_fraction >= 0.0 && this.categorical_fraction <= 1.0, "Categorical fraction must be between 0 and 1");
        this.check(this.categorical_fraction == 0.0 || this.factors >= 2, "Factors must be larger than 2 for categorical data");
        this.check(this.response_factors >= 1, "Response factors must be either 1 (real-valued response), or >=2 (factor levels)");
        this.check(this.response_factors <= 1024, "Response factors must be <= 1024");
        this.check(this.factors <= 1000000, "Number of factors must be <= 1,000,000");
        this.check(this.cols > 0 && this.rows > 0, "Must have number of rows and columns > 0");
        this.check(this.real_range >= 0.0, "Real range must be a nonnegative number");
        this.check(this.integer_range >= 0, "Integer range must be a nonnegative number");
        this.check(this.dest != null, "Destination frame must have a key");
        if (this.positive_response) {
            this.check(this.response_factors == 1, "positive_response can only be requested for real-valued response column");
        }
        if (this.randomize) {
            this.check(this.value == 0L, "Cannot set data to a constant value if randomize is true");
        } else {
            this.check(!this.has_response, "Cannot have response column if randomize is false");
            this.check(total_fraction == 0.0, "Cannot have integer, categorical, string, binary or time columns if randomize is false");
        }
    }

    private void checkParametersValidity2(CreateFrameExecutor cfe) {
        long byteEstimate = cfe.estimatedByteSize();
        long clusterFreeMem = H2O.CLOUD.free_mem();
        double gb = 1.073741824E9;
        this.check(byteEstimate <= clusterFreeMem, String.format("Frame is expected to require %.3fGb, which will not fit into H2O's free memory of %.3fGb", (double)byteEstimate / gb, (double)clusterFreeMem / gb));
    }

    private void check(boolean cond, String msg) {
        if (!cond) {
            throw new IllegalArgumentException(msg);
        }
    }

    private void buildRecipe(CreateFrameExecutor cfe) {
        cfe.setSeed(this.seed);
        cfe.setNumRows(this.rows);
        int catcols = (int)(this.categorical_fraction * (double)this.cols + 0.1);
        int intcols = (int)(this.integer_fraction * (double)this.cols + 0.1);
        int bincols = (int)(this.binary_fraction * (double)this.cols + 0.1);
        int timecols = (int)(this.time_fraction * (double)this.cols + 0.1);
        int stringcols = (int)(this.string_fraction * (double)this.cols + 0.1);
        int realcols = this.cols - catcols - intcols - bincols - timecols - stringcols;
        if (realcols < 0 && catcols > 0) {
            --catcols;
            ++realcols;
        }
        if (realcols < 0 && intcols > 0) {
            --intcols;
            ++realcols;
        }
        if (realcols < 0 && bincols > 0) {
            --bincols;
            ++realcols;
        }
        if (realcols < 0 && timecols > 0) {
            --timecols;
            ++realcols;
        }
        if (realcols < 0 && stringcols > 0) {
            --stringcols;
            ++realcols;
        }
        assert (catcols >= 0 && intcols >= 0 && bincols >= 0 && realcols >= 0 && timecols >= 0 && stringcols >= 0);
        if (this.has_response) {
            if (this.response_factors == 1) {
                cfe.addColumnMaker(new RealColumnCfcm("response", this.positive_response ? 0.0 : -this.real_range, this.real_range));
            } else {
                cfe.addColumnMaker(new CategoricalColumnCfcm("response", this.response_factors));
            }
        }
        if (this.randomize) {
            int i;
            int j = 0;
            for (i = 0; i < intcols; ++i) {
                cfe.addColumnMaker(new IntegerColumnCfcm("C" + ++j, -this.integer_range, this.integer_range));
            }
            for (i = 0; i < realcols; ++i) {
                cfe.addColumnMaker(new RealColumnCfcm("C" + ++j, -this.real_range, this.real_range));
            }
            for (i = 0; i < catcols; ++i) {
                cfe.addColumnMaker(new CategoricalColumnCfcm("C" + ++j, this.factors));
            }
            for (i = 0; i < bincols; ++i) {
                cfe.addColumnMaker(new BinaryColumnCfcm("C" + ++j, this.binary_ones_fraction));
            }
            for (i = 0; i < timecols; ++i) {
                cfe.addColumnMaker(new TimeColumnCfcm("C" + ++j, 0L, 1576800000000L));
            }
            for (i = 0; i < stringcols; ++i) {
                cfe.addColumnMaker(new StringColumnCfcm("C" + ++j, 8));
            }
        } else {
            assert (catcols + intcols + bincols + timecols + stringcols == 0);
            for (int i = 0; i < realcols; ++i) {
                cfe.addColumnMaker(new RealColumnCfcm("C" + (i + 1), this.value, this.value));
            }
        }
        cfe.addPostprocessStep(new MissingInserterCfps(this.missing_fraction));
        cfe.addPostprocessStep(new ShuffleColumnsCfps(true, true));
    }
}

