/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.sql.Timestamp;
import water.AutoBuffer;
import water.ExternalFrameUtils;

public final class ExternalFrameReaderClient {
    private boolean isLastNA = false;
    private AutoBuffer ab;
    private String frameKey;
    private int chunkIdx;
    private int[] selectedColumnIndices;
    private ByteChannel channel;
    private int numRows;
    private byte[] expectedTypes = null;

    public ExternalFrameReaderClient(ByteChannel channel, String frameKey, int chunkIdx, int[] selectedColumnIndices, byte[] expectedTypes) throws IOException {
        this.channel = channel;
        this.frameKey = frameKey;
        this.chunkIdx = chunkIdx;
        this.expectedTypes = expectedTypes;
        this.selectedColumnIndices = selectedColumnIndices;
        this.ab = this.initAndGetAb();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public boolean readBoolean() {
        boolean data = this.ab.getZ();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public byte readByte() {
        byte data = this.ab.get1();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public char readChar() {
        char data = this.ab.get2();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public short readShort() {
        short data = this.ab.get2s();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public int readInt() {
        int data = this.ab.getInt();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public long readLong() {
        long data = this.ab.get8();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public float readFloat() {
        float data = this.ab.get4f();
        this.isLastNA = ExternalFrameUtils.isNA(data);
        return data;
    }

    public double readDouble() {
        double data = this.ab.get8d();
        this.isLastNA = ExternalFrameUtils.isNA(data);
        return data;
    }

    public String readString() {
        String data = this.ab.getStr();
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public Timestamp readTimestamp() {
        Timestamp data = new Timestamp(this.ab.get8());
        this.isLastNA = ExternalFrameUtils.isNA(this.ab, data);
        return data;
    }

    public boolean isLastNA() {
        return this.isLastNA;
    }

    public void waitUntilAllReceived() {
        byte controlByte = this.ab.get1();
        assert (controlByte == 1);
    }

    private AutoBuffer initAndGetAb() throws IOException {
        AutoBuffer sentAb = new AutoBuffer();
        sentAb.put1(42);
        sentAb.put1(1);
        sentAb.putStr(this.frameKey);
        sentAb.putInt(this.chunkIdx);
        sentAb.putA1(this.expectedTypes);
        sentAb.putA4(this.selectedColumnIndices);
        ExternalFrameUtils.writeToChannel(sentAb, this.channel);
        AutoBuffer receiveAb = new AutoBuffer(this.channel, null);
        this.numRows = receiveAb.getInt();
        return receiveAb;
    }
}

